/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.jsonschema;

import io.micronaut.jsonschema.generator.SourceGenerator;
import io.micronaut.jsonschema.generator.loaders.UrlLoader;
import io.micronaut.jsonschema.generator.utils.SourceGeneratorConfigBuilder;
import io.micronaut.maven.AbstractMicronautMojo;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-jsonschema", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class JsonSchemaGeneratorMojo
extends AbstractMicronautMojo {
    public static final String MOJO_NAME = "generate-jsonschema";
    static final String MICRONAUT_SCHEMA_PREFIX = "micronaut.jsonschema.generator";
    static final String IO_MICRONAUT_SCHEMA_PREFIX = "io.micronaut.jsonschema";
    @Parameter(property="micronaut.jsonschema.generator.input-url")
    private String inputURL;
    @Parameter(property="micronaut.jsonschema.generator.input-file")
    private File inputFile;
    @Parameter(property="micronaut.jsonschema.generator.input-directory")
    private File inputDirectory;
    @Parameter(property="micronaut.jsonschema.generator.language", defaultValue="JAVA")
    private String language;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/jsonschema")
    private File outputDirectory;
    @Parameter(property="micronaut.jsonschema.generator.output-package-name", defaultValue="io.micronaut.jsonschema")
    private String outputPackageName;
    @Parameter(property="micronaut.jsonschema.generator.output-file-name")
    private String outputFileName;
    @Parameter(property="micronaut.jsonschema.generator.accepted-url-patterns")
    private List<String> acceptedUrlPatterns;
    @Parameter(property="micronaut.jsonschema.generator.enabled", defaultValue="false")
    private boolean enabled;
    private final MavenProject project;

    @Inject
    public JsonSchemaGeneratorMojo(MavenProject project) {
        this.project = project;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.enabled) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"generate-jsonschema is disabled");
            }
            return;
        }
        SourceGenerator langGenerator = new SourceGenerator(this.language.toUpperCase());
        if (this.acceptedUrlPatterns != null && !this.acceptedUrlPatterns.isEmpty()) {
            UrlLoader.addAllowedUrlPatterns(this.acceptedUrlPatterns);
        }
        Path outputDirPath = this.getSourceDirectory(this.language);
        this.project.addCompileSourceRoot(outputDirPath.toString());
        SourceGeneratorConfigBuilder builder = new SourceGeneratorConfigBuilder().withOutputFolder(outputDirPath).withOutputPackageName(this.outputPackageName).withOutputFileName(this.outputFileName);
        String message = "Generating sources for JSON schema from %s in the directory: %s";
        String relativePath = this.relativize(outputDirPath);
        if (this.inputURL != null) {
            builder.withJsonUrl(this.inputURL);
            message = message.formatted("URL [" + this.inputURL + "]", relativePath);
        } else if (this.inputFile != null) {
            builder.withJsonFile(this.inputFile);
            message = message.formatted("file [" + this.relativize(this.inputFile.toPath()) + "]", relativePath);
        } else if (this.inputDirectory != null) {
            builder.withInputFolder(this.inputDirectory.toPath());
            message = message.formatted("directory [" + this.relativize(this.inputDirectory.toPath()) + "]", relativePath);
        } else {
            StringBuilder msg = new StringBuilder("In the generate-jsonschema goal, one of the following parameters needs to be specified:").append(System.lineSeparator()).append("%s.input-file".formatted(MICRONAUT_SCHEMA_PREFIX)).append(System.lineSeparator()).append("%s.input-url".formatted(MICRONAUT_SCHEMA_PREFIX)).append(System.lineSeparator()).append("%s.input-directory".formatted(MICRONAUT_SCHEMA_PREFIX)).append(System.lineSeparator());
            throw new MojoFailureException(msg.toString());
        }
        try {
            this.getLog().info((CharSequence)message);
            langGenerator.generate(builder.build());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error when generating JSON schema", e);
        }
    }

    private String relativize(Path path) {
        return this.project.getBasedir().toPath().relativize(path).toString();
    }

    private Path getSourceDirectory(String language) {
        return this.outputDirectory.toPath().resolve("src/main/" + language.toLowerCase());
    }
}

