/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.maven.services;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Singleton
public class ExecutorService {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorService.class);
    private final MojoExecutor.ExecutionEnvironment executionEnvironment;
    private final MavenProject mavenProject;
    private final MavenSession mavenSession;
    private final Invoker invoker;

    @Inject
    public ExecutorService(MavenProject mavenProject, MavenSession mavenSession, BuildPluginManager pluginManager, Invoker invoker) {
        this.executionEnvironment = MojoExecutor.executionEnvironment((MavenProject)mavenProject, (MavenSession)mavenSession, (BuildPluginManager)pluginManager);
        this.mavenProject = mavenProject;
        this.mavenSession = mavenSession;
        this.invoker = invoker;
    }

    public void executeGoal(String pluginKey, String goal) throws MojoExecutionException {
        AtomicReference<String> executionId;
        Plugin plugin = this.mavenProject.getPlugin(pluginKey);
        if (plugin != null) {
            executionId = new AtomicReference<String>(goal);
            if (goal != null && goal.indexOf(35) > -1) {
                int pos = goal.indexOf(35);
                executionId.set(goal.substring(pos + 1));
                goal = goal.substring(0, pos);
            }
        } else {
            throw new MojoExecutionException("Plugin not found: " + pluginKey);
        }
        Optional<PluginExecution> execution = plugin.getExecutions().stream().filter(e -> e.getId().equals(executionId.get())).findFirst();
        Xpp3Dom configuration = execution.isPresent() ? (Xpp3Dom)execution.get().getConfiguration() : (plugin.getConfiguration() != null ? (Xpp3Dom)plugin.getConfiguration() : MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[0]));
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
    }

    public void executeGoal(String pluginGroup, String pluginArtifact, String pluginVersion, String goal, Xpp3Dom configuration) throws MojoExecutionException {
        Plugin plugin = MojoExecutor.plugin((String)pluginGroup, (String)pluginArtifact, (String)pluginVersion);
        MojoExecutor.executeMojo((Plugin)plugin, (String)MojoExecutor.goal((String)goal), (Xpp3Dom)configuration, (MojoExecutor.ExecutionEnvironment)this.executionEnvironment);
    }

    public InvocationResult invokeGoal(String pluginKey, String goal) throws MavenInvocationException {
        return this.invokeGoals(pluginKey + ":" + goal);
    }

    public InvocationResult invokeGoals(String ... goals) throws MavenInvocationException {
        return this.invokeGoals(this.mavenProject, goals);
    }

    public InvocationResult invokeGoals(MavenProject project, String ... goals) throws MavenInvocationException {
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setPomFile(project.getFile());
        File settingsFile = this.mavenSession.getRequest().getUserSettingsFile();
        if (settingsFile.exists()) {
            request.setUserSettingsFile(settingsFile);
        }
        Properties properties = new Properties();
        properties.put("micronaut.test.resources.enabled", "false");
        request.setLocalRepositoryDirectory(new File(this.mavenSession.getLocalRepository().getBasedir()));
        request.addArgs(Arrays.asList(goals));
        request.setBatchMode(true);
        request.setQuiet(true);
        request.setAlsoMake(true);
        request.setErrorHandler(arg_0 -> ((Logger)LOG).error(arg_0));
        request.setOutputHandler(arg_0 -> ((Logger)LOG).info(arg_0));
        request.setProperties(properties);
        return this.invoker.execute((InvocationRequest)request);
    }
}

