/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.aggregator;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micronaut.configuration.metrics.aggregator.MeterRegistryConfigurer;
import io.micronaut.core.annotation.NonNull;
import java.util.Collection;

public class CompositeMeterRegistryConfigurer
implements MeterRegistryConfigurer<CompositeMeterRegistry> {
    private final Collection<MeterBinder> binders;
    private final Collection<MeterFilter> filters;

    public CompositeMeterRegistryConfigurer(Collection<MeterBinder> binders, Collection<MeterFilter> filters) {
        this.binders = binders;
        this.filters = filters;
    }

    @Override
    public void configure(@NonNull CompositeMeterRegistry meterRegistry) {
        this.addFilters(meterRegistry);
        this.addBinders(meterRegistry);
    }

    @Override
    public Class<CompositeMeterRegistry> getType() {
        return CompositeMeterRegistry.class;
    }

    private void addFilters(@NonNull CompositeMeterRegistry meterRegistry) {
        if (this.filters != null && !this.filters.isEmpty()) {
            MeterRegistry.Config config = meterRegistry.config();
            for (MeterFilter filter : this.filters) {
                config.meterFilter(filter);
            }
        }
    }

    private void addBinders(@NonNull CompositeMeterRegistry meterRegistry) {
        if (this.binders != null && !this.binders.isEmpty()) {
            for (MeterBinder binder : this.binders) {
                binder.bindTo((MeterRegistry)meterRegistry);
            }
        }
    }
}

