/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.cache.JCacheMetrics;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import jakarta.inject.Singleton;
import javax.cache.Cache;
import javax.cache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@RequiresMetrics
@Requirements(value={@Requires(beans={CacheManager.class}), @Requires(property="micronaut.metrics.binders.cache.enabled", notEquals="false")})
public class JCacheMetricsBinder
implements BeanCreatedEventListener<CacheManager> {
    private static final Logger LOG = LoggerFactory.getLogger(JCacheMetricsBinder.class);
    private final BeanProvider<MeterRegistry> meterRegistryProvider;

    protected JCacheMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
    }

    public CacheManager onCreated(BeanCreatedEvent<CacheManager> event) {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        CacheManager cacheManager = (CacheManager)event.getBean();
        for (String cacheName : cacheManager.getCacheNames()) {
            try {
                JCacheMetrics.monitor((MeterRegistry)meterRegistry, (Cache)cacheManager.getCache(cacheName), (String[])new String[0]);
            }
            catch (Exception e) {
                LOG.warn("Unable to instrument JCache CacheManager with metrics: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return cacheManager;
    }
}

