/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.executor;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.scheduling.instrument.InstrumentedExecutorService;
import io.micronaut.scheduling.instrument.InstrumentedScheduledExecutorService;
import jakarta.inject.Singleton;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

@Singleton
@RequiresMetrics
@Requires(property="micronaut.metrics.binders.executor.enabled", notEquals="false")
public class ExecutorServiceMetricsBinder
implements BeanCreatedEventListener<ExecutorService> {
    private static final String THREAD_PER_TASK_EXECUTOR = "java.util.concurrent.ThreadPerTaskExecutor";
    private final BeanProvider<MeterRegistry> meterRegistryProvider;

    public ExecutorServiceMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
    }

    public ExecutorService onCreated(BeanCreatedEvent<ExecutorService> event) {
        ExecutorService executorService;
        ExecutorService unwrapped = executorService = (ExecutorService)event.getBean();
        while (unwrapped instanceof InstrumentedExecutorService) {
            unwrapped = ((InstrumentedExecutorService)unwrapped).getTarget();
        }
        if (unwrapped.getClass().getName().startsWith("io.netty")) {
            return unwrapped;
        }
        if (unwrapped.getClass().getName().equals(THREAD_PER_TASK_EXECUTOR)) {
            return executorService;
        }
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        BeanIdentifier beanIdentifier = event.getBeanIdentifier();
        List tags = Collections.emptyList();
        new ExecutorServiceMetrics(unwrapped, beanIdentifier.getName(), tags).bindTo(meterRegistry);
        final Timer timer = meterRegistry.timer("executor", (Iterable)Tags.concat(tags, (String[])new String[]{"name", beanIdentifier.getName()}));
        if (executorService instanceof ScheduledExecutorService) {
            return new InstrumentedScheduledExecutorService(){

                public ScheduledExecutorService getTarget() {
                    return (ScheduledExecutorService)executorService;
                }

                public <T> Callable<T> instrument(Callable<T> task) {
                    return timer.wrap(task);
                }

                public Runnable instrument(Runnable command) {
                    return timer.wrap(command);
                }
            };
        }
        return new InstrumentedExecutorService(){

            public ExecutorService getTarget() {
                return executorService;
            }

            public <T> Callable<T> instrument(Callable<T> task) {
                return timer.wrap(task);
            }

            public Runnable instrument(Runnable command) {
                return timer.wrap(command);
            }
        };
    }
}

