/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.grpc;

import io.grpc.ClientInterceptor;
import io.grpc.Internal;
import io.grpc.ServerInterceptor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.grpc.MetricCollectingClientInterceptor;
import io.micrometer.core.instrument.binder.grpc.MetricCollectingServerInterceptor;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;

@RequiresMetrics
@Requires(property="micronaut.metrics.binders.grpc.enabled", notEquals="false")
@Factory
@Internal
class GrpcMetricsListenerFactory {
    GrpcMetricsListenerFactory() {
    }

    @Singleton
    @Requirements(value={@Requires(classes={ServerInterceptor.class}), @Requires(property="micronaut.metrics.binders.grpc.server.enabled", notEquals="false")})
    MetricCollectingServerInterceptor grpcServerMetrics(MeterRegistry meterRegistry) {
        return new MetricCollectingServerInterceptor(meterRegistry);
    }

    @Singleton
    @Requirements(value={@Requires(classes={ClientInterceptor.class}), @Requires(property="micronaut.metrics.binders.grpc.client.enabled", notEquals="false")})
    MetricCollectingClientInterceptor grpcClientMetrics(MeterRegistry meterRegistry) {
        return new MetricCollectingClientInterceptor(meterRegistry);
    }
}

