/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.netty.NettyMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Context;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.core.annotation.Internal;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolChunkMetric;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocatorMetric;
import io.netty.buffer.UnpooledByteBufAllocator;
import jakarta.annotation.PostConstruct;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;

@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.netty.bytebuf-allocators.enabled", defaultValue="false", notEquals="false"), @Requires(classes={ByteBufAllocator.class})})
@Context
@Internal
final class ByteBufAllocatorMetricsBinder {
    private final BeanProvider<MeterRegistry> meterRegistryProvider;
    private final Set<ByteBufAllocatorMetricKind> kinds;

    public ByteBufAllocatorMetricsBinder(BeanProvider<MeterRegistry> meterRegistryProvider, @Value(value="${micronaut.metrics.binders.netty.bytebuf-allocators.metrics:null}") Set<ByteBufAllocatorMetricKind> kinds) {
        this.meterRegistryProvider = meterRegistryProvider;
        this.kinds = kinds == null || kinds.isEmpty() ? EnumSet.allOf(ByteBufAllocatorMetricKind.class) : kinds;
    }

    @PostConstruct
    public void configureNettyMetrics() {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        if (this.kinds.contains((Object)ByteBufAllocatorMetricKind.POOLED_ALLOCATOR)) {
            PooledByteBufAllocatorMetric pooledMetric = PooledByteBufAllocator.DEFAULT.metric();
            Tags pooled = Tags.of((String)"alloc", (String)"pooled");
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "memory", "used"), (Object)pooledMetric, ByteBufAllocatorMetric::usedHeapMemory).description("The number of the bytes of the heap memory.").tags((Iterable)pooled.and("memory", "heap")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "memory", "used"), (Object)pooledMetric, ByteBufAllocatorMetric::usedDirectMemory).description("The number of the bytes of the directy memory.").tags((Iterable)pooled.and("memory", "direct")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "count"), (Object)pooledMetric, PooledByteBufAllocatorMetric::numHeapArenas).description("The number of heap arenas.").tags((Iterable)pooled.and("memory", "heap")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "count"), (Object)pooledMetric, PooledByteBufAllocatorMetric::numDirectArenas).description("The number of direct arenas.").tags((Iterable)pooled.and("memory", "direct")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "thread", "local", "cache", "count"), (Object)pooledMetric, PooledByteBufAllocatorMetric::numDirectArenas).description("The number of direct arenas.").tags((Iterable)pooled).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "cache", "size"), (Object)pooledMetric, PooledByteBufAllocatorMetric::smallCacheSize).description("The size of the small cache.").tags((Iterable)pooled.and("cache", "small")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "cache", "size"), (Object)pooledMetric, PooledByteBufAllocatorMetric::normalCacheSize).description("The size of the normat cache.").tags((Iterable)pooled.and("cache", "normal")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "chunk", "size"), (Object)pooledMetric, PooledByteBufAllocatorMetric::chunkSize).description("The chunk size for an arena.").tags((Iterable)pooled).register(meterRegistry);
            if (this.kinds.contains((Object)ByteBufAllocatorMetricKind.POOLED_ARENAS)) {
                Tags tags;
                int i;
                for (i = 0; i < pooledMetric.directArenas().size(); ++i) {
                    tags = Tags.of((String)"memory", (String)"direct").and(NettyMetrics.dot("arena", "number"), Integer.toString(i));
                    this.meterPoolArena(tags, (PoolArenaMetric)pooledMetric.directArenas().get(i));
                }
                for (i = 0; i < pooledMetric.heapArenas().size(); ++i) {
                    tags = Tags.of((String)"memory", (String)"heap").and(NettyMetrics.dot("arena", "number"), Integer.toString(i));
                    this.meterPoolArena(tags, (PoolArenaMetric)pooledMetric.heapArenas().get(i));
                }
            }
        }
        if (this.kinds.contains((Object)ByteBufAllocatorMetricKind.UNPOOLED_ALLOCATOR)) {
            ByteBufAllocatorMetric unpooledMetric = UnpooledByteBufAllocator.DEFAULT.metric();
            Tags unpooled = Tags.of((String)"alloc", (String)"unpooled");
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "memory", "used"), (Object)unpooledMetric, ByteBufAllocatorMetric::usedHeapMemory).description("The number of the bytes of the heap memory.").tags((Iterable)unpooled.and("memory", "heap")).register(meterRegistry);
            Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "memory", "used"), (Object)unpooledMetric, ByteBufAllocatorMetric::usedDirectMemory).description("The number of the bytes of the directy memory.").tags((Iterable)unpooled.and("memory", "direct")).register(meterRegistry);
        }
    }

    private void meterPoolArena(Tags tags, PoolArenaMetric pam) {
        int i;
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "thread", "cache", "count"), (Object)pam, PoolArenaMetric::numThreadCaches).description("Returns the number of thread caches backed by this arena.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "subpage", "count"), (Object)pam, PoolArenaMetric::numSmallSubpages).description("Returns the number of small sub-pages for the arena.").tags((Iterable)tags.and("subpage", "small")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "chunklist", "count"), (Object)pam, PoolArenaMetric::numChunkLists).description("Returns the number of chunk lists for the arena.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "count"), (Object)pam, PoolArenaMetric::numAllocations).description("Return the number of allocations done via the arena. This includes all sizes.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "count"), (Object)pam, PoolArenaMetric::numSmallAllocations).description("Return the number of small allocations done via the arena.").tags((Iterable)tags.and("size", "small")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "count"), (Object)pam, PoolArenaMetric::numNormalAllocations).description("Return the number of normal allocations done via the arena.").tags((Iterable)tags.and("size", "normal")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "count"), (Object)pam, PoolArenaMetric::numHugeAllocations).description("Return the number of huge allocations done via the arena.").tags((Iterable)tags.and("size", "huge")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "deallocation", "count"), (Object)pam, PoolArenaMetric::numDeallocations).description("Return the number of deallocations done via the arena. This includes all sizes.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "deallocation", "count"), (Object)pam, PoolArenaMetric::numSmallDeallocations).description("Return the number of small deallocations done via the arena.").tags((Iterable)tags.and("size", "small")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "deallocation", "count"), (Object)pam, PoolArenaMetric::numNormalDeallocations).description("Return the number of normal deallocations done via the arena.").tags((Iterable)tags.and("size", "normal")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "deallocation", "count"), (Object)pam, PoolArenaMetric::numHugeDeallocations).description("Return the number of huge deallocations done via the arena.").tags((Iterable)tags.and("size", "huge")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "active", "count"), (Object)pam, PoolArenaMetric::numActiveAllocations).description("Return the number of currently active allocations.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "active", "count"), (Object)pam, PoolArenaMetric::numActiveSmallAllocations).description("Return the number of currently active small allocations.").tags((Iterable)tags.and("size", "small")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "active", "count"), (Object)pam, PoolArenaMetric::numActiveNormalAllocations).description("Return the number of currently active normal allocations.").tags((Iterable)tags.and("size", "normal")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "allocation", "active", "count"), (Object)pam, PoolArenaMetric::numActiveHugeAllocations).description("Return the number of currently active huge allocations.").tags((Iterable)tags.and("size", "huge")).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "active", "byte", "count"), (Object)pam, PoolArenaMetric::numActiveBytes).description("Return the number of active bytes that are currently allocated by the arena.").tags((Iterable)tags).register(meterRegistry);
        if (this.kinds.contains((Object)ByteBufAllocatorMetricKind.POOLED_ARENAS_SUBPAGES)) {
            for (i = 0; i < pam.smallSubpages().size(); ++i) {
                Tags tinySubpage = tags.and("subpage", "small").and(NettyMetrics.dot("subpage", "number"), Integer.toString(i));
                this.meterSubpage(tinySubpage, (PoolSubpageMetric)pam.smallSubpages().get(i));
            }
        }
        if (this.kinds.contains((Object)ByteBufAllocatorMetricKind.POOLED_ARENAS_CHUNKLISTS)) {
            for (i = 0; i < pam.chunkLists().size(); ++i) {
                Tags chunkList = tags.and(NettyMetrics.dot("chunklist", "number"), Integer.toString(i));
                this.meterChunkList(chunkList, (PoolChunkListMetric)pam.chunkLists().get(i));
            }
        }
    }

    private void meterSubpage(Tags tags, PoolSubpageMetric psm) {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "subpage", "element", "max"), (Object)psm, PoolSubpageMetric::maxNumElements).description("Return the number of maximal elements that can be allocated out of the sub-page.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "subpage", "available", "count"), (Object)psm, PoolSubpageMetric::numAvailable).description("Return the number of available elements to be allocated.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "subpage", "element", "size"), (Object)psm, PoolSubpageMetric::elementSize).description("Return the size (in bytes) of the elements that will be allocated.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "subpage", "page", "size"), (Object)psm, PoolSubpageMetric::pageSize).description("Return the size (in bytes) of this page.").tags((Iterable)tags).register(meterRegistry);
    }

    private void meterChunkList(Tags tags, PoolChunkListMetric pclm) {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "chunklist", "usage", "min"), (Object)pclm, PoolChunkListMetric::minUsage).description("Return the minimum usage of the chunk list before which chunks are promoted to the previous list.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "chunklist", "usage", "max"), (Object)pclm, PoolChunkListMetric::maxUsage).description("Return the maximum usage of the chunk list after which chunks are promoted to the next list.").tags((Iterable)tags).register(meterRegistry);
        if (this.kinds.contains((Object)ByteBufAllocatorMetricKind.POOLED_ARENAS_CHUNKS)) {
            int index = 0;
            Iterator i = pclm.iterator();
            while (i.hasNext()) {
                this.meterChunk(tags.and(NettyMetrics.dot("chunk", "number"), Integer.toString(index)), (PoolChunkMetric)i.next());
                ++index;
            }
        }
    }

    private void meterChunk(Tags tags, PoolChunkMetric pcm) {
        MeterRegistry meterRegistry = (MeterRegistry)this.meterRegistryProvider.get();
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "chunk", "size"), (Object)pcm, PoolChunkMetric::chunkSize).description("Return the size of the chunk in bytes, this is the maximum of bytes that can be served out of the chunk.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "chunk", "usage"), (Object)pcm, PoolChunkMetric::usage).description("Return the percentage of the current usage of the chunk.").tags((Iterable)tags).register(meterRegistry);
        Gauge.builder((String)NettyMetrics.dot("netty", "alloc", "arena", "chunk", "size", "available"), (Object)pcm, PoolChunkMetric::freeBytes).description("Return the number of free bytes in the chunk.").tags((Iterable)tags).register(meterRegistry);
    }

    static enum ByteBufAllocatorMetricKind {
        POOLED_ALLOCATOR,
        UNPOOLED_ALLOCATOR,
        POOLED_ARENAS,
        POOLED_ARENAS_SUBPAGES,
        POOLED_ARENAS_CHUNKLISTS,
        POOLED_ARENAS_CHUNKS;

    }
}

