/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micronaut.configuration.metrics.binder.netty.NettyMetrics;
import io.micronaut.context.BeanProvider;
import io.micronaut.core.annotation.Internal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.atomic.LongAdder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Internal
final class ChannelMetricsHandler
extends ChannelDuplexHandler {
    static final String CHANNEL_METRICS = "channel-metrics";
    private static final String ACTIVE_CHANNEL_TIMER = "active-channel-timer";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelMetricsHandler.class);
    private final BeanProvider<MeterRegistry> meterRegistryProvider;
    private final Counter bytesRead;
    private final Counter bytesWritten;
    private final Counter channelCount;
    private final Counter channelErrorCount;
    private final LongAdder activeChannelCount;
    private final Timer activeChannelTimer;

    ChannelMetricsHandler(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
        this.activeChannelCount = (LongAdder)((MeterRegistry)meterRegistryProvider.get()).gauge(NettyMetrics.dot("netty", "channel", "count", "active"), (Iterable)Tags.of((String)"channel", (String)"active"), (Number)new LongAdder());
        this.channelCount = Counter.builder((String)NettyMetrics.dot("netty", "channel", "count")).tag("channel", "count").register((MeterRegistry)meterRegistryProvider.get());
        this.channelErrorCount = Counter.builder((String)NettyMetrics.dot("netty", "channel", "count")).tag("channel", "error").register((MeterRegistry)meterRegistryProvider.get());
        this.bytesRead = Counter.builder((String)NettyMetrics.dot("netty", "channel", "byte")).tag("byte", "read").baseUnit("bytes").register((MeterRegistry)meterRegistryProvider.get());
        this.bytesWritten = Counter.builder((String)NettyMetrics.dot("netty", "channel", "byte")).tag("byte", "written").baseUnit("bytes").register((MeterRegistry)meterRegistryProvider.get());
        this.activeChannelTimer = Timer.builder((String)NettyMetrics.dot("netty", "channel", "time")).tag("active", "time").publishPercentileHistogram().register((MeterRegistry)meterRegistryProvider.get());
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.channelCount.increment();
        this.activeChannelCount.increment();
        ctx.pipeline().addAfter(CHANNEL_METRICS, ACTIVE_CHANNEL_TIMER, (ChannelHandler)new ActiveChannelTimerHandler());
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.activeChannelCount.decrement();
        ctx.fireChannelUnregistered();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            if (buffer.readableBytes() > 0) {
                this.bytesRead.increment((double)buffer.readableBytes());
            }
        } else if (msg instanceof ByteBufHolder) {
            ByteBufHolder buffer = (ByteBufHolder)msg;
            if (buffer.content().readableBytes() > 0) {
                this.bytesRead.increment((double)buffer.content().readableBytes());
            }
        } else {
            LOGGER.warn("Message type not supported: {}", msg.getClass());
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            if (buffer.readableBytes() > 0) {
                this.bytesWritten.increment((double)buffer.readableBytes());
            }
        } else if (msg instanceof ByteBufHolder) {
            ByteBufHolder buffer = (ByteBufHolder)msg;
            if (buffer.content().readableBytes() > 0) {
                this.bytesWritten.increment((double)buffer.content().readableBytes());
            }
        } else {
            LOGGER.warn("Message type not supported: {}", (Object)msg.getClass().getName());
        }
        ctx.write(msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.channelErrorCount.increment();
        ctx.fireExceptionCaught(cause);
    }

    private class ActiveChannelTimerHandler
    extends ChannelInboundHandlerAdapter {
        private final Timer.Sample start;

        ActiveChannelTimerHandler() {
            this.start = Timer.start((MeterRegistry)((MeterRegistry)ChannelMetricsHandler.this.meterRegistryProvider.get()));
        }

        public void channelUnregistered(ChannelHandlerContext ctx) {
            this.start.stop(ChannelMetricsHandler.this.activeChannelTimer);
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireChannelUnregistered();
        }
    }
}

