/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.netty.InstrumentedEventLoopTaskQueueFactory;
import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.NioEventLoopGroupFactory;
import io.netty.channel.DefaultSelectStrategyFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.EventLoopTaskQueueFactory;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorChooserFactory;
import io.netty.util.concurrent.EventExecutorChooserFactory;
import io.netty.util.concurrent.RejectedExecutionHandlers;
import io.netty.util.concurrent.ThreadPerTaskExecutor;
import jakarta.inject.Singleton;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;

@Singleton
@Internal
@Replaces(bean=NioEventLoopGroupFactory.class)
@RequiresMetrics
@Requires(property="micronaut.metrics.binders.netty.queues.enabled", defaultValue="false", notEquals="false")
final class InstrumentedNioEventLoopGroupFactory
extends NioEventLoopGroupFactory {
    private final InstrumentedEventLoopTaskQueueFactory instrumentedEventLoopTaskQueueFactory;

    public InstrumentedNioEventLoopGroupFactory(InstrumentedEventLoopTaskQueueFactory factory) {
        this.instrumentedEventLoopTaskQueueFactory = factory;
    }

    public EventLoopGroup createEventLoopGroup(int threads, @Nullable Integer ioRatio) {
        return InstrumentedNioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, null, null, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), (EventLoopTaskQueueFactory)this.instrumentedEventLoopTaskQueueFactory), ioRatio);
    }

    public EventLoopGroup createEventLoopGroup(int threads, ThreadFactory threadFactory, @Nullable Integer ioRatio) {
        return InstrumentedNioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, (Executor)(threadFactory == null ? null : new ThreadPerTaskExecutor(threadFactory)), (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), (EventLoopTaskQueueFactory)this.instrumentedEventLoopTaskQueueFactory), ioRatio);
    }

    public EventLoopGroup createEventLoopGroup(int threads, Executor executor, @Nullable Integer ioRatio) {
        return InstrumentedNioEventLoopGroupFactory.withIoRatio(new NioEventLoopGroup(threads, executor, (EventExecutorChooserFactory)DefaultEventExecutorChooserFactory.INSTANCE, SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE, RejectedExecutionHandlers.reject(), (EventLoopTaskQueueFactory)this.instrumentedEventLoopTaskQueueFactory), ioRatio);
    }

    public Class<? extends ServerSocketChannel> serverSocketChannelClass() {
        return NioServerSocketChannel.class;
    }

    @NonNull
    public Class<? extends SocketChannel> clientSocketChannelClass(@Nullable EventLoopGroupConfiguration configuration) {
        return NioSocketChannel.class;
    }

    private static NioEventLoopGroup withIoRatio(NioEventLoopGroup group, @Nullable Integer ioRatio) {
        if (ioRatio != null) {
            group.setIoRatio(ioRatio.intValue());
        }
        return group;
    }
}

