/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micronaut.configuration.metrics.binder.netty.NettyMetrics;
import io.micronaut.core.annotation.Internal;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

@Internal
final class MonitoredQueue
implements Queue<Runnable> {
    private final Queue<Runnable> delegate;
    private final MeterRegistry meterRegistry;
    private final Timer waitTimeTimer;
    private final Timer executionTimer;
    private final Timer globalWaitTimeTimer;
    private final Timer globalExecutionTimeTimer;
    private final Counter globalTaskCounter;

    MonitoredQueue(int index, MeterRegistry meterRegistry, Tag tag, Counter globalTaskCounter, Timer globalWaitTimeTimer, Timer globalExecutionTimeTimer, Queue<Runnable> queue) {
        this.delegate = queue;
        this.meterRegistry = meterRegistry;
        this.globalExecutionTimeTimer = globalExecutionTimeTimer;
        this.globalWaitTimeTimer = globalWaitTimeTimer;
        this.globalTaskCounter = globalTaskCounter;
        Tags tags = Tags.of((Tag[])new Tag[]{tag, Tag.of((String)"queue", (String)"size")}).and("number", Integer.toString(index));
        Gauge.builder((String)NettyMetrics.dot("netty", "queue", "size"), this.delegate, Collection::size).tags((Iterable)tags).description("The approximate number of tasks that are queued for execution.").register(meterRegistry);
        tags = Tags.of((Tag[])new Tag[]{tag, Tag.of((String)"queue", (String)"wait.time")}).and("number", Integer.toString(index));
        this.waitTimeTimer = Timer.builder((String)NettyMetrics.dot("netty", "queue", "wait.time")).description("Wait time spent in the Queue.").publishPercentileHistogram().tags((Iterable)tags).register(meterRegistry);
        tags = Tags.of((Tag[])new Tag[]{tag, Tag.of((String)"queue", (String)"execution.time")}).and("number", Integer.toString(index));
        this.executionTimer = Timer.builder((String)NettyMetrics.dot("netty", "queue", "execution.time")).description("Runnable execution time.").publishPercentileHistogram().tags((Iterable)tags).register(meterRegistry);
    }

    @Override
    public void forEach(Consumer<? super Runnable> action) {
        this.delegate.forEach(action);
    }

    @Override
    public boolean add(Runnable e) {
        this.globalTaskCounter.increment();
        return this.delegate.add(new TimedRunnable(this.meterRegistry, this.executionTimer, this.waitTimeTimer, this.globalExecutionTimeTimer, this.globalWaitTimeTimer, e));
    }

    @Override
    public boolean offer(Runnable e) {
        this.globalTaskCounter.increment();
        return this.delegate.offer(new TimedRunnable(this.meterRegistry, this.executionTimer, this.waitTimeTimer, this.globalExecutionTimeTimer, this.globalWaitTimeTimer, e));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Runnable remove() {
        return this.delegate.remove();
    }

    @Override
    public Runnable poll() {
        return this.delegate.poll();
    }

    @Override
    public Iterator<Runnable> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Runnable element() {
        return this.delegate.element();
    }

    @Override
    public Runnable peek() {
        return this.delegate.peek();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends Runnable> c) {
        for (Runnable runnable : c) {
            if (this.add(runnable)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super Runnable> filter) {
        return this.delegate.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Spliterator<Runnable> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public Stream<Runnable> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<Runnable> parallelStream() {
        return this.delegate.parallelStream();
    }

    static final class TimedRunnable
    implements Runnable {
        private final MeterRegistry registry;
        private final Timer executionTimer;
        private final Timer waitTimeTimer;
        private final Timer globalWaitTimeTimer;
        private final Timer globalExecutionTimeTimer;
        private final Runnable delegate;
        private final Timer.Sample idleSample;

        TimedRunnable(MeterRegistry registry, Timer executionTimer, Timer waitTimeTimer, Timer globalExecutionTimeTimer, Timer globalWaitTimeTimer, Runnable delegate) {
            this.registry = registry;
            this.executionTimer = executionTimer;
            this.waitTimeTimer = waitTimeTimer;
            this.globalExecutionTimeTimer = globalExecutionTimeTimer;
            this.globalWaitTimeTimer = globalWaitTimeTimer;
            this.delegate = delegate;
            this.idleSample = Timer.start((MeterRegistry)registry);
        }

        @Override
        public void run() {
            this.globalWaitTimeTimer.record(this.idleSample.stop(this.waitTimeTimer), TimeUnit.NANOSECONDS);
            Timer.Sample executionSample = Timer.start((MeterRegistry)this.registry);
            try {
                this.delegate.run();
            }
            finally {
                this.globalExecutionTimeTimer.record(executionSample.stop(this.executionTimer), TimeUnit.NANOSECONDS);
            }
        }
    }
}

