/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.netty;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.netty.ChannelMetricsHandler;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.http.server.netty.NettyServerCustomizer;
import io.micronaut.runtime.server.EmbeddedServer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import jakarta.inject.Singleton;

@Singleton
@Internal
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.netty.channels.enabled", defaultValue="false", notEquals="false"), @Requires(classes={EmbeddedServer.class})})
final class NettyMetricsPipelineBinder
implements BeanCreatedEventListener<NettyServerCustomizer.Registry> {
    private final ChannelMetricsHandler metricsHandler;

    NettyMetricsPipelineBinder(BeanProvider<MeterRegistry> meterRegistryProvider) {
        this.metricsHandler = new ChannelMetricsHandler(meterRegistryProvider);
    }

    public NettyServerCustomizer.Registry onCreated(BeanCreatedEvent<NettyServerCustomizer.Registry> event) {
        NettyServerCustomizer.Registry registry = (NettyServerCustomizer.Registry)event.getBean();
        registry.register((NettyServerCustomizer)new MetricsCustomizer(null, this.metricsHandler));
        return registry;
    }

    private record MetricsCustomizer(Channel channel, ChannelMetricsHandler metricsHandler) implements NettyServerCustomizer
    {
        public NettyServerCustomizer specializeForChannel(Channel channel, NettyServerCustomizer.ChannelRole role) {
            if (role == NettyServerCustomizer.ChannelRole.CONNECTION) {
                return new MetricsCustomizer(channel, this.metricsHandler);
            }
            return this;
        }

        public void onStreamPipelineBuilt() {
            if (this.channel != null) {
                this.channel.pipeline().addFirst("channel-metrics", (ChannelHandler)this.metricsHandler);
            }
        }
    }
}

