/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.r2dbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micronaut.core.annotation.NonNull;
import io.r2dbc.pool.PoolMetrics;
import java.util.function.Function;

public class R2dbcPoolMetricsBinder
implements MeterBinder {
    private final PoolMetrics poolMetrics;
    private final Iterable<Tag> tags;

    public R2dbcPoolMetricsBinder(PoolMetrics metrics, String dataSourceName, Iterable<Tag> tags) {
        this.poolMetrics = metrics;
        this.tags = Tags.concat(tags, (String[])new String[]{"name", dataSourceName});
    }

    public void bindTo(@NonNull MeterRegistry registry) {
        if (this.poolMetrics != null) {
            this.bindToPoolMetrics(registry, "acquired", PoolMetrics::acquiredSize);
            this.bindToPoolMetrics(registry, "allocated", PoolMetrics::allocatedSize);
            this.bindToPoolMetrics(registry, "idle", PoolMetrics::idleSize);
            this.bindToPoolMetrics(registry, "pending", PoolMetrics::pendingAcquireSize);
            this.bindToPoolMetrics(registry, "max.allocated", PoolMetrics::getMaxAllocatedSize);
            this.bindToPoolMetrics(registry, "max.pending", PoolMetrics::getMaxPendingAcquireSize);
        }
    }

    private void bindToPoolMetrics(MeterRegistry registry, String metricName, Function<PoolMetrics, Integer> function) {
        registry.gauge("r2dbc.pool." + metricName, this.tags, (Object)this.poolMetrics, m -> ((Integer)function.apply((PoolMetrics)m)).doubleValue());
    }
}

