/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.web.WebMetricsClientCondition;
import io.micronaut.configuration.metrics.binder.web.WebMetricsHelper;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.ClientFilter;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import jakarta.inject.Provider;
import java.util.Optional;

@ClientFilter(value={"${micronaut.metrics.http.client.path:/**}"})
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.web.enabled", notEquals="false"), @Requires(condition=WebMetricsClientCondition.class)})
@Internal
final class ClientMetricsFilter {
    private static final String START_ATTRIBUTE = ClientMetricsFilter.class.getName() + ".START_ATTRIBUTE";
    private final Provider<MeterRegistry> meterRegistryProvider;

    public ClientMetricsFilter(Provider<MeterRegistry> meterRegistryProvider) {
        this.meterRegistryProvider = meterRegistryProvider;
    }

    @RequestFilter
    void onRequest(HttpRequest<?> request) {
        request.setAttribute((CharSequence)START_ATTRIBUTE, (Object)System.nanoTime());
    }

    @ResponseFilter
    void onResponse(HttpRequest<?> request, HttpResponse<?> response) {
        this.createHelper(request).onResponse(response);
    }

    @ResponseFilter
    void doException(HttpRequest<?> request, Throwable throwable) {
        this.createHelper(request).error(null, throwable);
    }

    private WebMetricsHelper createHelper(HttpRequest<?> request) {
        return new WebMetricsHelper((MeterRegistry)this.meterRegistryProvider.get(), this.resolvePath(request), request.getAttribute((CharSequence)START_ATTRIBUTE, Long.class).orElseGet(System::nanoTime), request.getMethod().toString(), "http.client.requests", this.resolveServiceID(request), true);
    }

    private String resolvePath(HttpRequest<?> request) {
        Optional route = request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class);
        return route.orElse(null);
    }

    private String resolveServiceID(HttpRequest<?> request) {
        String serviceId = request.getAttributes().get((CharSequence)HttpAttributes.SERVICE_ID.toString(), String.class).orElse(null);
        if (StringUtils.isNotEmpty((CharSequence)serviceId) && serviceId.charAt(0) == '/') {
            return "embedded-server";
        }
        return serviceId;
    }
}

