/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.web.config.HttpClientMeterConfig;
import io.micronaut.configuration.metrics.binder.web.config.HttpMeterConfig;
import io.micronaut.configuration.metrics.binder.web.config.HttpMetricsConfig;
import io.micronaut.configuration.metrics.binder.web.config.HttpServerMeterConfig;
import io.micronaut.context.annotation.Bean;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import jakarta.inject.Singleton;
import java.util.Arrays;

@Factory
@RequiresMetrics
@Requires(bean=HttpMetricsConfig.class, beanProperty="enabled", value="true")
public class HttpMeterFilterFactory {
    @Deprecated(forRemoval=true, since="5.9")
    public static final String ENABLED = "micronaut.metrics.binders.web.enabled";
    public static final double SECONDS_TO_NANOS = 1.0E9;

    @Bean
    @Singleton
    @Requires(property="micronaut.metrics.binders.web.server")
    MeterFilter addServerPercentileMeterFilter(HttpServerMeterConfig serverMeterConfig) {
        return this.getMeterFilter(serverMeterConfig, "http.server.requests");
    }

    @Bean
    @Singleton
    @Requires(property="micronaut.metrics.binders.web.client")
    MeterFilter addClientPercentileMeterFilter(HttpClientMeterConfig clientMeterConfig) {
        return this.getMeterFilter(clientMeterConfig, "http.client.requests");
    }

    private MeterFilter getMeterFilter(final HttpMeterConfig meterConfig, final String metricNamePrefix) {
        return new MeterFilter(){

            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                if (id.getName().startsWith(metricNamePrefix)) {
                    DistributionStatisticConfig.Builder builder = DistributionStatisticConfig.builder().percentiles(new double[0]).percentiles(Arrays.stream(meterConfig.getPercentiles()).mapToDouble(Double::doubleValue).toArray()).serviceLevelObjectives(Arrays.stream(meterConfig.getSlos()).mapToDouble(d -> d * 1.0E9).toArray()).percentilesHistogram(meterConfig.getHistogram());
                    if (meterConfig.getMin() != null) {
                        builder.minimumExpectedValue(Double.valueOf(meterConfig.getMin() * 1.0E9));
                    }
                    if (meterConfig.getMax() != null) {
                        builder.maximumExpectedValue(Double.valueOf(meterConfig.getMax() * 1.0E9));
                    }
                    return builder.build().merge(config);
                }
                return config;
            }
        };
    }
}

