/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.binder.web.WebMetricsHelper;
import io.micronaut.configuration.metrics.binder.web.WebMetricsServerCondition;
import io.micronaut.configuration.metrics.binder.web.config.HttpMetricsConfig;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.annotation.RequestFilter;
import io.micronaut.http.annotation.ResponseFilter;
import io.micronaut.http.annotation.ServerFilter;
import io.micronaut.web.router.UriRouteMatch;
import jakarta.inject.Provider;
import java.util.Optional;
import java.util.function.Supplier;

@ServerFilter(value={"${micronaut.metrics.http.path:/**}"})
@RequiresMetrics
@Requirements(value={@Requires(property="micronaut.metrics.binders.web.enabled", notEquals="false"), @Requires(condition=WebMetricsServerCondition.class)})
@Internal
final class ServerMetricsFilter {
    private static final String START_ATTRIBUTE = ServerMetricsFilter.class.getName() + ".START_ATTRIBUTE";
    private static final String UNMATCHED_URI = "UNMATCHED_URI";
    private final Supplier<MeterRegistry> meterRegistryProvider = SupplierUtil.memoized(() -> meterRegistryProvider.get());
    private final boolean reportClientErrorURIs;

    public ServerMetricsFilter(Provider<MeterRegistry> meterRegistryProvider, HttpMetricsConfig.ClientErrorsUrisConfig clientErrorsUrisConfig) {
        this.reportClientErrorURIs = clientErrorsUrisConfig.enabled();
    }

    private String resolvePath(HttpRequest<?> request) {
        Optional<String> routeInfo = request.getAttribute((CharSequence)HttpAttributes.ROUTE_INFO, UriRouteMatch.class).map(match -> match.getRouteInfo().getUriMatchTemplate().toPathString());
        return routeInfo.orElseGet(() -> request.getAttribute((CharSequence)HttpAttributes.URI_TEMPLATE, String.class).orElse(UNMATCHED_URI));
    }

    @RequestFilter
    void onRequest(HttpRequest<?> request) {
        request.setAttribute((CharSequence)START_ATTRIBUTE, (Object)System.nanoTime());
    }

    @ResponseFilter
    void onResponse(HttpRequest<?> request, HttpResponse<?> response) {
        WebMetricsHelper httpResponseWebMetricsPublisher = new WebMetricsHelper(this.meterRegistryProvider.get(), this.resolvePath(request), request.getAttribute((CharSequence)START_ATTRIBUTE, Long.class).orElseGet(System::nanoTime), request.getMethod().toString(), "http.server.requests", null, this.reportClientErrorURIs);
        httpResponseWebMetricsPublisher.onResponse(response);
    }
}

