/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseProvider;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.exceptions.HttpStatusException;
import io.micronaut.web.router.ErrorRouteInfo;
import io.micronaut.web.router.RouteMatch;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Internal
final class WebMetricsHelper {
    private static final String UNKNOWN = "UNKNOWN";
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_UNAUTHORIZED = Tag.of((String)"uri", (String)"UNAUTHORIZED");
    private static final Tag URI_BAD_REQUEST = Tag.of((String)"uri", (String)"BAD_REQUEST");
    private static final String METHOD = "method";
    private static final String STATUS = "status";
    private static final String URI = "uri";
    private static final String EXCEPTION = "exception";
    private static final String SERVICE_ID = "serviceId";
    private final MeterRegistry meterRegistry;
    private final String requestPath;
    private final long start;
    private final String httpMethod;
    private final String metricName;
    private final String serviceID;
    private final boolean reportClientErrorURIs;

    WebMetricsHelper(MeterRegistry meterRegistry, String requestPath, long start, String httpMethod, String metricName, String serviceID, boolean reportClientErrorURIs) {
        this.meterRegistry = meterRegistry;
        this.requestPath = requestPath;
        this.start = start;
        this.httpMethod = httpMethod;
        this.metricName = metricName;
        this.serviceID = serviceID;
        this.reportClientErrorURIs = reportClientErrorURIs;
    }

    private static List<Tag> getTags(HttpResponse<?> httpResponse, String httpMethod, String requestPath, Throwable throwable, String serviceId, boolean reportClientErrorURIs) {
        ArrayList<@NonNull Tag> tags = new ArrayList<Tag>(5);
        Tag t1 = WebMetricsHelper.method(httpMethod);
        if (t1 != null) {
            tags.add(t1);
        }
        tags.add(WebMetricsHelper.status(httpResponse, throwable));
        tags.add(WebMetricsHelper.uri(httpResponse, requestPath, reportClientErrorURIs));
        tags.add(WebMetricsHelper.exception(throwable));
        Tag t5 = WebMetricsHelper.serviceId(serviceId);
        if (t5 != null) {
            tags.add(t5);
        }
        return tags;
    }

    @Nullable
    private static Tag method(@Nullable String httpMethod) {
        return httpMethod == null ? null : Tag.of((String)METHOD, (String)httpMethod);
    }

    private static Tag status(@Nullable HttpResponse<?> httpResponse, @Nullable Throwable throwable) {
        if (httpResponse == null) {
            if (throwable instanceof HttpStatusException) {
                HttpStatusException httpStatusException = (HttpStatusException)throwable;
                return Tag.of((String)STATUS, (String)String.valueOf(httpStatusException.getStatus().getCode()));
            }
            return Tag.of((String)STATUS, (String)"500");
        }
        return Tag.of((String)STATUS, (String)String.valueOf(httpResponse.code()));
    }

    @NonNull
    private static Tag uri(HttpResponse<?> httpResponse, String path, boolean reportClientErrorURIs) {
        if (httpResponse != null) {
            int code = httpResponse.code();
            if (code >= 300 && code < 400) {
                return URI_REDIRECTION;
            }
            if (!reportClientErrorURIs && code >= 400 && code < 500) {
                if (code == HttpStatus.UNAUTHORIZED.getCode()) {
                    return URI_UNAUTHORIZED;
                }
                return URI_BAD_REQUEST;
            }
            if (code == HttpStatus.NOT_FOUND.getCode()) {
                return URI_NOT_FOUND;
            }
        }
        return Tag.of((String)URI, (String)WebMetricsHelper.sanitizePath(path));
    }

    private static Tag exception(Throwable throwable) {
        if (throwable == null) {
            return Tag.of((String)EXCEPTION, (String)"none");
        }
        return Tag.of((String)EXCEPTION, (String)throwable.getClass().getSimpleName());
    }

    @Nullable
    private static Tag serviceId(@Nullable String serviceId) {
        return serviceId == null ? null : Tag.of((String)SERVICE_ID, (String)serviceId);
    }

    @NonNull
    static String sanitizePath(@Nullable String path) {
        if (path == null) {
            return UNKNOWN;
        }
        CharSequence builder = null;
        for (int i = 0; i < path.length() - 1; ++i) {
            if (path.charAt(i) != '/' || path.charAt(i + 1) != '/') continue;
            builder = new StringBuilder(path);
            ((StringBuilder)builder).deleteCharAt(i + 1);
            while (i < ((StringBuilder)builder).length() - 1) {
                if (((StringBuilder)builder).charAt(i) == '/' && ((StringBuilder)builder).charAt(i + 1) == '/') {
                    ((StringBuilder)builder).deleteCharAt(i + 1);
                    --i;
                }
                ++i;
            }
            break;
        }
        if (builder != null) {
            if (!builder.isEmpty() && ((StringBuilder)builder).charAt(((StringBuilder)builder).length() - 1) == '/') {
                ((StringBuilder)builder).setLength(((StringBuilder)builder).length() - 1);
            }
            path = ((StringBuilder)builder).toString();
        } else if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.isEmpty()) {
            return "root";
        }
        return path;
    }

    public void onResponse(HttpResponse<?> httpResponse) {
        Object exception = httpResponse.getAttribute((CharSequence)HttpAttributes.EXCEPTION).orElse(null);
        if (exception instanceof Throwable) {
            Throwable throwable = exception;
            RouteMatch routeMatch = httpResponse.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH, RouteMatch.class).orElse(null);
            if (routeMatch != null && routeMatch.getRouteInfo() instanceof ErrorRouteInfo) {
                this.success(httpResponse, throwable);
            } else {
                this.error(httpResponse, throwable);
            }
        } else {
            this.success(httpResponse, null);
        }
    }

    public void success(HttpResponse<?> httpResponse, @Nullable Throwable throwable) {
        List<Tag> tags = WebMetricsHelper.getTags(httpResponse, this.httpMethod, this.requestPath, httpResponse.code() >= 400 ? throwable : null, this.serviceID, this.reportClientErrorURIs);
        this.meterRegistry.timer(this.metricName, tags).record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
    }

    public void error(HttpResponse<?> httpResponse, Throwable throwable) {
        if (httpResponse == null && throwable instanceof HttpResponseProvider) {
            HttpResponseProvider httpResponseProvider = (HttpResponseProvider)throwable;
            httpResponse = httpResponseProvider.getResponse();
        }
        List<Tag> tags = WebMetricsHelper.getTags(httpResponse, this.httpMethod, this.requestPath, throwable, this.serviceID, this.reportClientErrorURIs);
        this.meterRegistry.timer(this.metricName, tags).record(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
    }
}

