/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.binder.web;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpResponseProvider;
import io.micronaut.http.HttpStatus;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.util.context.Context;

@Deprecated(since="5.9", forRemoval=true)
public class WebMetricsPublisher<T extends HttpResponse<?>>
extends Flux<T> {
    public static final String ENABLED = "micronaut.metrics.binders.web.enabled";
    public static final String CLIENT_ERROR_URIS_ENABLED = "micronaut.metrics.binders.web.client-errors-uris.enabled";
    public static final String METRIC_HTTP_SERVER_REQUESTS = "http.server.requests";
    public static final String METRIC_HTTP_CLIENT_REQUESTS = "http.client.requests";
    static final String UNKNOWN = "UNKNOWN";
    private static final Tag URI_NOT_FOUND = Tag.of((String)"uri", (String)"NOT_FOUND");
    private static final Tag URI_REDIRECTION = Tag.of((String)"uri", (String)"REDIRECTION");
    private static final Tag URI_UNAUTHORIZED = Tag.of((String)"uri", (String)"UNAUTHORIZED");
    private static final Tag URI_BAD_REQUEST = Tag.of((String)"uri", (String)"BAD_REQUEST");
    private static final String METHOD = "method";
    private static final String STATUS = "status";
    private static final String URI = "uri";
    private static final String EXCEPTION = "exception";
    private static final String SERVICE_ID = "serviceId";
    private final Flux<T> publisher;
    private final MeterRegistry meterRegistry;
    private final String requestPath;
    private final long start;
    private final String httpMethod;
    private final String metricName;
    private final String serviceID;
    private final boolean reportErrors;
    private final boolean reportClientErrorURIs;

    WebMetricsPublisher(Publisher<T> publisher, MeterRegistry meterRegistry, String requestPath, long start, String httpMethod, boolean isServer, boolean reportErrors, boolean reportClientErrorURIs) {
        this(publisher, meterRegistry, requestPath, start, httpMethod, isServer, null, reportErrors, reportClientErrorURIs);
    }

    WebMetricsPublisher(Publisher<T> publisher, MeterRegistry meterRegistry, String requestPath, long start, String httpMethod, boolean isServer, String serviceID, boolean reportErrors, boolean reportClientErrorURIs) {
        this.publisher = Flux.from(publisher);
        this.meterRegistry = meterRegistry;
        this.requestPath = requestPath;
        this.start = start;
        this.httpMethod = httpMethod;
        this.metricName = isServer ? METRIC_HTTP_SERVER_REQUESTS : METRIC_HTTP_CLIENT_REQUESTS;
        this.serviceID = serviceID;
        this.reportErrors = reportErrors;
        this.reportClientErrorURIs = reportClientErrorURIs;
    }

    WebMetricsPublisher(Publisher<T> publisher, MeterRegistry meterRegistry, String requestPath, long start, String httpMethod, boolean reportErrors, boolean reportClientErrorURIs) {
        this(publisher, meterRegistry, requestPath, start, httpMethod, true, null, reportErrors, reportClientErrorURIs);
    }

    public void subscribe(final CoreSubscriber<? super T> actual) {
        this.publisher.subscribe(new CoreSubscriber<T>(){

            public Context currentContext() {
                return actual.currentContext();
            }

            public void onSubscribe(Subscription subscription) {
                actual.onSubscribe(subscription);
            }

            public void onNext(T httpResponse) {
                WebMetricsPublisher.this.success((HttpResponse<?>)httpResponse, WebMetricsPublisher.this.start, WebMetricsPublisher.this.httpMethod, WebMetricsPublisher.this.requestPath, WebMetricsPublisher.this.serviceID);
                actual.onNext(httpResponse);
            }

            public void onError(Throwable throwable) {
                if (WebMetricsPublisher.this.reportErrors) {
                    WebMetricsPublisher.this.error(WebMetricsPublisher.this.start, WebMetricsPublisher.this.httpMethod, WebMetricsPublisher.this.requestPath, throwable, WebMetricsPublisher.this.serviceID);
                }
                actual.onError(throwable);
            }

            public void onComplete() {
                actual.onComplete();
            }
        });
    }

    private static List<Tag> getTags(HttpResponse<?> httpResponse, String httpMethod, String requestPath, Throwable throwable, String serviceId, boolean reportClientErrorURIs) {
        return Stream.of(WebMetricsPublisher.method(httpMethod), WebMetricsPublisher.status(httpResponse), WebMetricsPublisher.uri(httpResponse, requestPath, reportClientErrorURIs), WebMetricsPublisher.exception(throwable), WebMetricsPublisher.serviceId(serviceId)).filter(Objects::nonNull).toList();
    }

    private static Tag method(String httpMethod) {
        return httpMethod == null ? null : Tag.of((String)METHOD, (String)httpMethod);
    }

    private static Tag status(HttpResponse<?> httpResponse) {
        if (httpResponse == null) {
            return Tag.of((String)STATUS, (String)"500");
        }
        return Tag.of((String)STATUS, (String)String.valueOf(httpResponse.code()));
    }

    private static Tag uri(HttpResponse<?> httpResponse, String path, boolean reportClientErrorURIs) {
        if (httpResponse != null) {
            int code = httpResponse.code();
            if (code >= 300 && code < 400) {
                return URI_REDIRECTION;
            }
            if (!reportClientErrorURIs && code >= 400 && code < 500) {
                if (code == HttpStatus.UNAUTHORIZED.getCode()) {
                    return URI_UNAUTHORIZED;
                }
                return URI_BAD_REQUEST;
            }
            if (code == HttpStatus.NOT_FOUND.getCode()) {
                return URI_NOT_FOUND;
            }
        }
        return Tag.of((String)URI, (String)WebMetricsPublisher.sanitizePath(path));
    }

    private static Tag exception(Throwable throwable) {
        if (throwable == null) {
            return Tag.of((String)EXCEPTION, (String)"none");
        }
        return Tag.of((String)EXCEPTION, (String)throwable.getClass().getSimpleName());
    }

    private static Tag serviceId(String serviceId) {
        return serviceId == null ? null : Tag.of((String)SERVICE_ID, (String)serviceId);
    }

    private static String sanitizePath(String path) {
        if (!StringUtils.isEmpty((CharSequence)path)) {
            path = path.replaceAll("//+", "/").replaceAll("/$", "");
        }
        return path != null ? (path.isEmpty() ? "root" : path) : UNKNOWN;
    }

    private void success(HttpResponse<?> httpResponse, long start, String httpMethod, String requestPath, String serviceId) {
        List<Tag> tags = WebMetricsPublisher.getTags(httpResponse, httpMethod, requestPath, null, serviceId, this.reportClientErrorURIs);
        this.meterRegistry.timer(this.metricName, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }

    private void error(long start, String httpMethod, String requestPath, Throwable throwable, String serviceId) {
        HttpResponse response = null;
        if (throwable instanceof HttpResponseProvider) {
            HttpResponseProvider httpResponseProvider = (HttpResponseProvider)throwable;
            response = httpResponseProvider.getResponse();
        }
        List<Tag> tags = WebMetricsPublisher.getTags(response, httpMethod, requestPath, throwable, serviceId, this.reportClientErrorURIs);
        this.meterRegistry.timer(this.metricName, tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
    }
}

