/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.common.tags;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micronaut.configuration.metrics.aggregator.MeterRegistryConfigurer;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.micrometer.ExportConfigurationProperties;
import io.micronaut.context.annotation.Factory;
import io.micronaut.context.annotation.Requires;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@Factory
@RequiresMetrics
@Requires(property="micronaut.metrics.tags")
public class CommonTagsConfigurer
implements MeterRegistryConfigurer<MeterRegistry> {
    private final List<Tag> commonTags = new ArrayList<Tag>();

    public CommonTagsConfigurer(ExportConfigurationProperties configuration) {
        Properties tags = configuration.getTags();
        for (String key : tags.stringPropertyNames()) {
            this.commonTags.add(Tag.of((String)key, (String)tags.getProperty(key)));
        }
    }

    @Override
    public void configure(MeterRegistry meterRegistry) {
        meterRegistry.config().commonTags(this.commonTags);
    }

    @Override
    public Class<MeterRegistry> getType() {
        return MeterRegistry.class;
    }
}

