/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.intercept;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micronaut.aop.InterceptedMethod;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.metrics.aggregator.AbstractMethodTagger;
import io.micronaut.configuration.metrics.annotation.MetricOptions;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.configuration.metrics.util.MetricOptionsUtil;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.StringUtils;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RequiresMetrics
@InterceptorBean(value={Counted.class})
public class CountedInterceptor
implements MethodInterceptor<Object, Object> {
    public static final String DEFAULT_METRIC_NAME = "method.counted";
    public static final String RESULT_TAG = "result";
    private final MeterRegistry meterRegistry;
    private final ConversionService conversionService;
    private final List<AbstractMethodTagger> methodTaggers;

    @Deprecated
    public CountedInterceptor(MeterRegistry meterRegistry) {
        this(meterRegistry, ConversionService.SHARED);
    }

    @Deprecated
    public CountedInterceptor(MeterRegistry meterRegistry, ConversionService conversionService) {
        this(meterRegistry, conversionService, Collections.emptyList());
    }

    @Inject
    public CountedInterceptor(MeterRegistry meterRegistry, ConversionService conversionService, List<AbstractMethodTagger> methodTaggers) {
        this.meterRegistry = meterRegistry;
        this.conversionService = conversionService;
        this.methodTaggers = Objects.requireNonNullElse(methodTaggers, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        AnnotationMetadata metadata = context.getAnnotationMetadata();
        String metricName = metadata.stringValue(Counted.class).orElse(DEFAULT_METRIC_NAME);
        boolean conditionMet = MetricOptionsUtil.evaluateCondition(context);
        if (!StringUtils.isNotEmpty((CharSequence)metricName)) return context.proceed();
        if (!conditionMet) return context.proceed();
        InterceptedMethod interceptedMethod = InterceptedMethod.of(context, (ConversionService)this.conversionService);
        try {
            InterceptedMethod.ResultType resultType = interceptedMethod.resultType();
            switch (resultType) {
                case PUBLISHER: {
                    Mono reactiveResult;
                    Object interceptResult = context.proceed();
                    if (interceptResult == null) {
                        return null;
                    }
                    if (context.getReturnType().isSingleResult()) {
                        Mono single = Mono.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)interceptResult, Publisher.class)));
                        reactiveResult = single.doOnError(throwable -> this.doCount(metadata, metricName, (Throwable)throwable, context)).doOnSuccess(o -> this.doCount(metadata, metricName, null, context));
                        return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)reactiveResult, (Class)context.getReturnType().getType());
                    }
                    Flux flowable = Flux.from((Publisher)((Publisher)Publishers.convertPublisher((ConversionService)this.conversionService, (Object)interceptResult, Publisher.class)));
                    reactiveResult = flowable.doOnError(throwable -> this.doCount(metadata, metricName, (Throwable)throwable, context)).doOnComplete(() -> this.doCount(metadata, metricName, null, context));
                    return Publishers.convertPublisher((ConversionService)this.conversionService, (Object)reactiveResult, (Class)context.getReturnType().getType());
                }
                case COMPLETION_STAGE: {
                    CompletionStage completionStage = interceptedMethod.interceptResultAsCompletionStage();
                    CompletionStage<Object> completionStageResult = completionStage.whenComplete((o, throwable) -> this.doCount(metadata, metricName, (Throwable)throwable, context));
                    return interceptedMethod.handleResult(completionStageResult);
                }
                case SYNCHRONOUS: {
                    Object result = context.proceed();
                    try {
                        Object object = result;
                        return object;
                    }
                    finally {
                        if (metadata.isFalse(Counted.class, "recordFailuresOnly")) {
                            this.doCount(metadata, metricName, null, context);
                        }
                    }
                }
            }
            return interceptedMethod.unsupported();
        }
        catch (Exception e) {
            try {
                Object object = interceptedMethod.handleException(e);
                return object;
            }
            finally {
                this.doCount(metadata, metricName, e, context);
            }
        }
    }

    private void doCount(AnnotationMetadata metadata, String metricName, @Nullable Throwable e, MethodInvocationContext<Object, Object> context) {
        List<Class> taggers = Arrays.asList(metadata.classValues(MetricOptions.class, "taggers"));
        boolean filter = metadata.booleanValue(MetricOptions.class, "filterTaggers").orElse(false);
        Counter.builder((String)metricName).tags(this.methodTaggers.isEmpty() ? Collections.emptyList() : this.methodTaggers.stream().sorted(OrderUtil.ORDERED_COMPARATOR).filter(t -> !filter || taggers.contains(t.getClass())).flatMap(t -> t.getTags(context).stream()).toList()).tags(metadata.stringValues(Counted.class, "extraTags")).description((String)metadata.stringValue(Counted.class, "description").orElse(null)).tag("exception", e != null ? e.getClass().getSimpleName() : "none").tag(RESULT_TAG, e != null ? "failure" : "success").register(this.meterRegistry).increment();
    }
}

