/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.micrometer.intercept;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micronaut.aop.InterceptorBean;
import io.micronaut.aop.MethodInterceptor;
import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.metrics.aggregator.AbstractMethodTagger;
import io.micronaut.configuration.metrics.annotation.MetricOptions;
import io.micronaut.configuration.metrics.annotation.RequiresMetrics;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.util.CollectionUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.HdrHistogram.ConcurrentHistogram;
import org.HdrHistogram.Histogram;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@RequiresMetrics
@TypeHint(value={Histogram.class, ConcurrentHistogram.class})
@InterceptorBean(value={Timed.class})
public class TimedInterceptor
implements MethodInterceptor<Object, Object> {
    public static final String DEFAULT_METRIC_NAME = "method.timed";
    public static final String EXCEPTION_TAG = "exception";
    private static final Logger LOGGER = LoggerFactory.getLogger(TimedInterceptor.class);
    private final MeterRegistry meterRegistry;
    private final ConversionService conversionService;
    private final List<AbstractMethodTagger> methodTaggers;

    @Deprecated
    protected TimedInterceptor(MeterRegistry meterRegistry) {
        this(meterRegistry, ConversionService.SHARED, Collections.emptyList());
    }

    @Deprecated
    protected TimedInterceptor(MeterRegistry meterRegistry, ConversionService conversionService) {
        this(meterRegistry, conversionService, Collections.emptyList());
    }

    @Inject
    protected TimedInterceptor(MeterRegistry meterRegistry, ConversionService conversionService, List<AbstractMethodTagger> methodTaggers) {
        this.meterRegistry = meterRegistry;
        this.conversionService = conversionService;
        this.methodTaggers = Objects.requireNonNullElse(methodTaggers, Collections.emptyList());
    }

    /*
     * Exception decompiling
     */
    public Object intercept(MethodInvocationContext<Object, Object> context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Timer.Sample> initSamples(List<AnnotationValue<Timed>> timedAnnotations) {
        ArrayList<Timer.Sample> syncInvokeSamples = new ArrayList<Timer.Sample>(timedAnnotations.size());
        for (AnnotationValue<Timed> ignored : timedAnnotations) {
            syncInvokeSamples.add(Timer.start((MeterRegistry)this.meterRegistry));
        }
        return syncInvokeSamples;
    }

    private void finalizeSamples(List<AnnotationValue<Timed>> timedAnnotations, String exceptionClass, List<Timer.Sample> syncInvokeSamples, MethodInvocationContext<Object, Object> context) {
        if (CollectionUtils.isNotEmpty(syncInvokeSamples) && timedAnnotations.size() == syncInvokeSamples.size()) {
            Iterator<AnnotationValue<Timed>> i = timedAnnotations.iterator();
            for (Timer.Sample syncInvokeSample : syncInvokeSamples) {
                AnnotationValue<Timed> timedAnn = i.next();
                String metricName = timedAnn.stringValue().orElse(DEFAULT_METRIC_NAME);
                this.stopTimed(metricName, syncInvokeSample, exceptionClass, timedAnn, context);
            }
        }
    }

    private void stopTimed(String metricName, Timer.Sample sample, String exceptionClass, AnnotationValue<Timed> metadata, MethodInvocationContext<Object, Object> context) {
        try {
            String description = metadata.stringValue("description").orElse(null);
            String[] tags = metadata.stringValues("extraTags");
            AnnotationMetadata annotationMetadata = context.getAnnotationMetadata();
            List<Class> taggers = Arrays.asList(annotationMetadata.classValues(MetricOptions.class, "taggers"));
            boolean filter = annotationMetadata.booleanValue(MetricOptions.class, "filterTaggers").orElse(false);
            double[] percentiles = metadata.doubleValues("percentiles");
            boolean histogram = metadata.isTrue("histogram");
            Timer timer = Timer.builder((String)metricName).description(description).tags(this.methodTaggers.isEmpty() ? Collections.emptyList() : this.methodTaggers.stream().sorted(OrderUtil.ORDERED_COMPARATOR).filter(t -> !filter || taggers.contains(t.getClass())).flatMap(b -> b.getTags(context).stream()).toList()).tags(tags).tags(new String[]{EXCEPTION_TAG, exceptionClass}).publishPercentileHistogram(Boolean.valueOf(histogram)).publishPercentiles(percentiles).register(this.meterRegistry);
            sample.stop(timer);
        }
        catch (Exception e) {
            LOGGER.error("Error registering timer in the registry", (Throwable)e);
        }
    }

    private /* synthetic */ void lambda$intercept$6(List timedAnnotations, List completionStageInvokeSamples, MethodInvocationContext context, Object o, Throwable throwable) {
        this.finalizeSamples(timedAnnotations, throwable == null ? "none" : throwable.getClass().getSimpleName(), completionStageInvokeSamples, (MethodInvocationContext<Object, Object>)context);
    }

    private /* synthetic */ void lambda$intercept$5(List timedAnnotations, AtomicReference exceptionClassHolder, AtomicReference reactiveInvokeSample, MethodInvocationContext context) {
        this.finalizeSamples(timedAnnotations, (String)exceptionClassHolder.get(), (List)reactiveInvokeSample.get(), (MethodInvocationContext<Object, Object>)context);
    }

    private static /* synthetic */ void lambda$intercept$4(AtomicReference exceptionClassHolder, Throwable throwable) {
        exceptionClassHolder.set(throwable.getClass().getSimpleName());
    }

    private /* synthetic */ void lambda$intercept$3(AtomicReference reactiveInvokeSample, List timedAnnotations, long n) {
        reactiveInvokeSample.set(this.initSamples(timedAnnotations));
    }

    private /* synthetic */ void lambda$intercept$2(List timedAnnotations, AtomicReference reactiveInvokeSample, MethodInvocationContext context, Object o) {
        this.finalizeSamples(timedAnnotations, "none", (List)reactiveInvokeSample.get(), (MethodInvocationContext<Object, Object>)context);
    }

    private /* synthetic */ void lambda$intercept$1(List timedAnnotations, AtomicReference reactiveInvokeSample, MethodInvocationContext context, Throwable throwable) {
        this.finalizeSamples(timedAnnotations, throwable.getClass().getSimpleName(), (List)reactiveInvokeSample.get(), (MethodInvocationContext<Object, Object>)context);
    }

    private /* synthetic */ void lambda$intercept$0(AtomicReference reactiveInvokeSample, List timedAnnotations, Subscription d) {
        reactiveInvokeSample.set(this.initSamples(timedAnnotations));
    }
}

