/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.metrics.util;

import io.micronaut.aop.MethodInvocationContext;
import io.micronaut.configuration.metrics.annotation.MetricOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricOptionsUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MetricOptionsUtil.class);

    public static boolean evaluateCondition(MethodInvocationContext<?, ?> context) {
        if (!context.isPresent(MetricOptions.class, "condition")) {
            return true;
        }
        boolean expressionResult = context.booleanValue(MetricOptions.class, "condition").orElse(false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("MetricOptions condition evaluated to {} for invocation: {}", (Object)expressionResult, context);
        }
        return expressionResult;
    }
}

