/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.runtime.context.scope;

import io.micronaut.context.BeanRegistration;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.exceptions.BeanDestructionException;
import io.micronaut.context.scope.BeanCreationContext;
import io.micronaut.context.scope.CreatedBean;
import io.micronaut.context.scope.CustomScope;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.inject.BeanIdentifier;
import io.micronaut.runtime.context.scope.ThreadLocal;
import jakarta.inject.Singleton;
import java.lang.ref.Cleaner;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
final class ThreadLocalCustomScope
implements CustomScope<ThreadLocal>,
LifeCycle<ThreadLocalCustomScope>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLocalCustomScope.class);
    private static final Supplier<Cleaner> LIFECYCLE_CLEANER = SupplierUtil.memoized(Cleaner::create);
    private final java.lang.ThreadLocal<LocalHolder> threadScope = new java.lang.ThreadLocal();
    private final Set<Cleaner.Cleanable> toClean = ConcurrentHashMap.newKeySet();

    ThreadLocalCustomScope() {
    }

    public boolean isRunning() {
        return true;
    }

    public Class<ThreadLocal> annotationType() {
        return ThreadLocal.class;
    }

    public <T> T getOrCreate(BeanCreationContext<T> creationContext) {
        CreatedBean bean;
        LocalHolder local = this.threadScope.get();
        if (local == null) {
            local = new LocalHolder();
            this.threadScope.set(local);
        }
        if ((bean = local.beans.get(creationContext.id())) == null) {
            bean = creationContext.create();
            local.add(bean);
        }
        return (T)bean.bean();
    }

    public <T> Optional<T> remove(BeanIdentifier identifier) {
        LocalHolder local = this.threadScope.get();
        if (local == null) {
            return Optional.empty();
        }
        CreatedBean<?> bean = local.remove(identifier);
        if (bean == null) {
            return Optional.empty();
        }
        try {
            bean.close();
        }
        catch (BeanDestructionException e) {
            this.handleDestructionException(e);
        }
        return Optional.ofNullable(bean.bean());
    }

    public <T> Optional<BeanRegistration<T>> findBeanRegistration(T bean) {
        LocalHolder local = this.threadScope.get();
        if (local == null) {
            return Optional.empty();
        }
        for (CreatedBean<?> createdBean : local.beans.values()) {
            if (createdBean.bean() != bean) continue;
            if (createdBean instanceof BeanRegistration) {
                return Optional.of((BeanRegistration)createdBean);
            }
            return Optional.of(new BeanRegistration(createdBean.id(), createdBean.definition(), bean));
        }
        return Optional.empty();
    }

    private void handleDestructionException(BeanDestructionException e) {
        LOG.error("Error occurred destroying bean of scope @ThreadLocal: {}", (Object)e.getMessage(), (Object)e);
    }

    @NonNull
    public ThreadLocalCustomScope stop() {
        for (Cleaner.Cleanable cleanable : this.toClean) {
            cleanable.clean();
        }
        return this;
    }

    private final class LocalHolder {
        final Map<BeanIdentifier, CreatedBean<?>> beans = new HashMap();
        LifecycleBeanHolder lifecycleBeans;

        private LocalHolder() {
        }

        void add(CreatedBean<?> createdBean) {
            this.beans.put(createdBean.id(), createdBean);
            if (createdBean.definition().booleanValue(ThreadLocal.class, "lifecycle").orElse(false).booleanValue()) {
                if (this.lifecycleBeans == null) {
                    Cleaner.Cleanable cleanable;
                    LifecycleBeanHolder holder = new LifecycleBeanHolder();
                    holder.cleanable = cleanable = LIFECYCLE_CLEANER.get().register(this, holder);
                    ThreadLocalCustomScope.this.toClean.add(cleanable);
                    this.lifecycleBeans = holder;
                }
                this.lifecycleBeans.lifecycleBeans.add(createdBean);
            }
        }

        @Nullable
        CreatedBean<?> remove(BeanIdentifier identifier) {
            CreatedBean<?> createdBean = this.beans.remove(identifier);
            if (createdBean != null && this.lifecycleBeans != null) {
                this.lifecycleBeans.lifecycleBeans.remove(createdBean);
            }
            return createdBean;
        }
    }

    private final class LifecycleBeanHolder
    implements Runnable {
        final Set<CreatedBean<?>> lifecycleBeans = new HashSet();
        Cleaner.Cleanable cleanable;

        private LifecycleBeanHolder() {
        }

        @Override
        public void run() {
            ThreadLocalCustomScope.this.toClean.remove(this.cleanable);
            for (CreatedBean<?> bean : this.lifecycleBeans) {
                try {
                    bean.close();
                }
                catch (BeanDestructionException e) {
                    ThreadLocalCustomScope.this.handleDestructionException(e);
                }
            }
        }
    }
}

