/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.async.publisher;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.async.publisher.CompletableFuturePublisher;
import io.micronaut.core.async.subscriber.Completable;
import io.micronaut.core.async.subscriber.CompletionAwareSubscriber;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.reflect.ClassUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

@Internal
public class Publishers {
    private static final List<Class<?>> REACTIVE_TYPES;
    private static final List<Class<?>> SINGLE_TYPES;
    private static final List<Class<?>> COMPLETABLE_TYPES;

    public static void registerReactiveType(Class<?> type) {
        if (type != null) {
            REACTIVE_TYPES.add(type);
        }
    }

    public static void registerReactiveSingle(Class<?> type) {
        if (type != null) {
            Publishers.registerReactiveType(type);
            SINGLE_TYPES.add(type);
        }
    }

    public static void registerReactiveCompletable(Class<?> type) {
        if (type != null) {
            Publishers.registerReactiveType(type);
            COMPLETABLE_TYPES.add(type);
        }
    }

    public static List<Class<?>> getKnownReactiveTypes() {
        return Collections.unmodifiableList(new ArrayList(REACTIVE_TYPES));
    }

    public static <T> Publisher<T> fromCompletableFuture(Supplier<CompletableFuture<T>> futureSupplier) {
        return new CompletableFuturePublisher<T>(futureSupplier);
    }

    public static <T> Publisher<T> fromCompletableFuture(CompletableFuture<T> future) {
        return new CompletableFuturePublisher(() -> future);
    }

    public static <T> Publisher<T> just(T value) {
        return new JustPublisher<T>(value);
    }

    public static <T> Publisher<T> just(Throwable error) {
        return new JustThrowPublisher(error);
    }

    public static <T> Publisher<T> empty() {
        return new JustCompletePublisher();
    }

    public static <T, R> Publisher<R> map(Publisher<T> publisher, final Function<T, R> mapper) {
        return actual -> publisher.subscribe((Subscriber)new CompletionAwareSubscriber<T>(){

            @Override
            protected void doOnSubscribe(Subscription subscription) {
                actual.onSubscribe(subscription);
            }

            @Override
            protected void doOnNext(T message) {
                try {
                    Object result = Objects.requireNonNull(mapper.apply(message), "The mapper returned a null value.");
                    actual.onNext(result);
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }

            @Override
            protected void doOnError(Throwable t) {
                actual.onError(t);
            }

            @Override
            protected void doOnComplete() {
                actual.onComplete();
            }
        });
    }

    public static <T> Publisher<T> then(Publisher<T> publisher, final Consumer<T> consumer) {
        return actual -> publisher.subscribe((Subscriber)new CompletionAwareSubscriber<T>(){

            @Override
            protected void doOnSubscribe(Subscription subscription) {
                actual.onSubscribe(subscription);
            }

            @Override
            protected void doOnNext(T message) {
                try {
                    actual.onNext(message);
                    consumer.accept(message);
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }

            @Override
            protected void doOnError(Throwable t) {
                actual.onError(t);
            }

            @Override
            protected void doOnComplete() {
                actual.onComplete();
            }
        });
    }

    public static <T> Publisher<T> onComplete(Publisher<T> publisher, final Supplier<CompletableFuture<Void>> future) {
        return actual -> publisher.subscribe((Subscriber)new CompletionAwareSubscriber<T>(){

            @Override
            protected void doOnSubscribe(Subscription subscription) {
                actual.onSubscribe(subscription);
            }

            @Override
            protected void doOnNext(T message) {
                try {
                    actual.onNext(message);
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }

            @Override
            protected void doOnError(Throwable t) {
                actual.onError(t);
            }

            @Override
            protected void doOnComplete() {
                ((CompletableFuture)future.get()).whenComplete((aVoid, throwable) -> {
                    if (throwable != null) {
                        actual.onError(throwable);
                    } else {
                        actual.onComplete();
                    }
                });
            }
        });
    }

    public static boolean isConvertibleToPublisher(Class<?> type) {
        if (Publisher.class.isAssignableFrom(type)) {
            return true;
        }
        for (Class<?> reactiveType : REACTIVE_TYPES) {
            if (!reactiveType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isConvertibleToPublisher(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Publisher) {
            return true;
        }
        return Publishers.isConvertibleToPublisher(object.getClass());
    }

    public static <T> T convertPublisher(Object object, Class<T> publisherType) {
        Objects.requireNonNull(object, "Argument [object] cannot be null");
        Objects.requireNonNull(publisherType, "Argument [publisherType] cannot be null");
        if (object instanceof CompletableFuture) {
            Publisher<T> futurePublisher = Publishers.fromCompletableFuture(() -> (CompletableFuture)object);
            return ConversionService.SHARED.convert(futurePublisher, publisherType).orElseThrow(() -> Publishers.unconvertibleError(object, publisherType));
        }
        if (object instanceof MicronautPublisher && MicronautPublisher.class.isAssignableFrom(publisherType)) {
            return (T)object;
        }
        return ConversionService.SHARED.convert(object, publisherType).orElseThrow(() -> Publishers.unconvertibleError(object, publisherType));
    }

    public static boolean isSingle(Class<?> type) {
        for (Class<?> reactiveType : SINGLE_TYPES) {
            if (!reactiveType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCompletable(Class<?> type) {
        for (Class<?> reactiveType : COMPLETABLE_TYPES) {
            if (!reactiveType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private static <T> IllegalArgumentException unconvertibleError(Object object, Class<T> publisherType) {
        return new IllegalArgumentException("Cannot convert reactive type [" + object.getClass() + "] to type [" + publisherType + "]. Ensure that you have the necessary Reactive module on your classpath. For example for Reactor you should have 'micronaut-reactor'.");
    }

    static {
        Optional<Class> aClass;
        REACTIVE_TYPES = new ArrayList(3);
        SINGLE_TYPES = new ArrayList(3);
        COMPLETABLE_TYPES = new ArrayList(3);
        ClassLoader classLoader = Publishers.class.getClassLoader();
        SINGLE_TYPES.add(CompletableFuturePublisher.class);
        SINGLE_TYPES.add(JustPublisher.class);
        COMPLETABLE_TYPES.add(Completable.class);
        List<String> typeNames = Arrays.asList("io.reactivex.Observable", "reactor.core.publisher.Flux", "kotlinx.coroutines.flow.Flow", "io.reactivex.rxjava3.core.Flowable", "io.reactivex.rxjava3.core.Observable");
        for (String name : typeNames) {
            aClass = ClassUtils.forName(name, classLoader);
            aClass.ifPresent(REACTIVE_TYPES::add);
        }
        for (String name : Arrays.asList("io.reactivex.Single", "reactor.core.publisher.Mono", "io.reactivex.Maybe", "io.reactivex.rxjava3.core.Single", "io.reactivex.rxjava3.core.Maybe")) {
            aClass = ClassUtils.forName(name, classLoader);
            aClass.ifPresent(aClass1 -> {
                SINGLE_TYPES.add((Class<?>)aClass1);
                REACTIVE_TYPES.add((Class<?>)aClass1);
            });
        }
        for (String name : Arrays.asList("io.reactivex.Completable", "io.reactivex.rxjava3.core.Completable")) {
            aClass = ClassUtils.forName(name, classLoader);
            aClass.ifPresent(aClass1 -> {
                COMPLETABLE_TYPES.add((Class<?>)aClass1);
                REACTIVE_TYPES.add((Class<?>)aClass1);
            });
        }
    }

    private static class JustCompletePublisher<T>
    implements MicronautPublisher<T> {
        private JustCompletePublisher() {
        }

        public void subscribe(final Subscriber<? super T> subscriber) {
            subscriber.onSubscribe(new Subscription(){
                boolean done;

                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    subscriber.onComplete();
                }

                public void cancel() {
                    this.done = true;
                }
            });
        }
    }

    private static class JustThrowPublisher<T>
    implements MicronautPublisher<T> {
        private final Throwable error;

        public JustThrowPublisher(Throwable error) {
            this.error = error;
        }

        public void subscribe(final Subscriber<? super T> subscriber) {
            subscriber.onSubscribe(new Subscription(){
                boolean done;

                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    subscriber.onError(error);
                }

                public void cancel() {
                    this.done = true;
                }
            });
        }
    }

    private static class JustPublisher<T>
    implements MicronautPublisher<T> {
        private final T value;

        public JustPublisher(T value) {
            this.value = value;
        }

        public void subscribe(final Subscriber<? super T> subscriber) {
            subscriber.onSubscribe(new Subscription(){
                boolean done;

                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    this.done = true;
                    if (value != null) {
                        subscriber.onNext(value);
                    }
                    subscriber.onComplete();
                }

                public void cancel() {
                    this.done = true;
                }
            });
        }
    }

    public static interface MicronautPublisher<T>
    extends Publisher<T> {
    }
}

