/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.micronaut.core.io.Streamable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public interface Writable
extends Streamable {
    public void writeTo(Writer var1) throws IOException;

    @Override
    default public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
    }

    @Override
    default public void writeTo(File file) throws IOException {
        try (OutputStream outputStream = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            this.writeTo(outputStream);
        }
    }

    @Override
    default public void writeTo(OutputStream outputStream, @Nullable Charset charset) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(outputStream, charset == null ? StandardCharsets.UTF_8 : charset);
        this.writeTo(writer);
        writer.flush();
    }
}

