/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.annotation;

import io.micronaut.core.annotation.AnnotationUtil;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.util.ArgumentUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Optional;

public interface AnnotationSource {
    public static final AnnotationSource EMPTY = new AnnotationSource(){};

    @Nullable
    default public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return null;
    }

    @Nullable
    default public <T extends Annotation> T synthesize(@NonNull Class<T> annotationClass, @NonNull String sourceAnnotation) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        ArgumentUtils.requireNonNull("sourceAnnotation", sourceAnnotation);
        return null;
    }

    @Nullable
    default public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass, @NonNull String sourceAnnotation) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        ArgumentUtils.requireNonNull("sourceAnnotation", sourceAnnotation);
        return null;
    }

    @Nullable
    default public <T extends Annotation> T synthesizeDeclared(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return null;
    }

    @NonNull
    default public Annotation[] synthesizeAll() {
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    @NonNull
    default public Annotation[] synthesizeDeclared() {
        return AnnotationUtil.ZERO_ANNOTATIONS;
    }

    @NonNull
    default public <T extends Annotation> T[] synthesizeAnnotationsByType(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @NonNull
    default public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return (Annotation[])Array.newInstance(annotationClass, 0);
    }

    @NonNull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return Optional.empty();
    }

    @NonNull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return Optional.empty();
    }

    @NonNull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return Optional.empty();
    }

    @NonNull
    default public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return Optional.empty();
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.findAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getAnnotation(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return this.findAnnotation(annotationClass).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(@NonNull String annotation) {
        ArgumentUtils.requireNonNull("annotation", annotation);
        return this.findDeclaredAnnotation(annotation).orElse(null);
    }

    @Nullable
    default public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(@NonNull Class<T> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return this.findDeclaredAnnotation(annotationClass).orElse(null);
    }

    default public boolean isAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return false;
    }

    default public boolean isDeclaredAnnotationPresent(@NonNull Class<? extends Annotation> annotationClass) {
        ArgumentUtils.requireNonNull("annotationClass", annotationClass);
        return false;
    }

    default public boolean isAnnotationPresent(@NonNull String annotationName) {
        ArgumentUtils.requireNonNull("annotationClass", annotationName);
        return false;
    }

    default public boolean isDeclaredAnnotationPresent(@NonNull String annotationName) {
        ArgumentUtils.requireNonNull("annotationClass", annotationName);
        return false;
    }

    default public AnnotationSource getTargetAnnotationMetadata() {
        return this;
    }
}

