/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.convert.format;

import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.format.FormattingTypeConverter;
import io.micronaut.core.convert.format.ReadableBytes;
import io.micronaut.core.util.StringUtils;
import java.util.Locale;
import java.util.Optional;

public class ReadableBytesTypeConverter
implements FormattingTypeConverter<CharSequence, Number, ReadableBytes> {
    private static final String KILOBYTES = "KB";
    private static final String MEGABYTES = "MB";
    private static final String GIGABYTES = "GB";
    private static final int KB_UNIT = 1024;

    @Override
    public Class<ReadableBytes> annotationType() {
        return ReadableBytes.class;
    }

    @Override
    public Optional<Number> convert(CharSequence object, Class<Number> targetType, ConversionContext context) {
        if (StringUtils.isEmpty(object)) {
            return Optional.empty();
        }
        String value = object.toString().toUpperCase(Locale.ENGLISH);
        try {
            long size;
            if (value.endsWith(KILOBYTES)) {
                long numberPart = this.parseSizeWithUnit(value);
                size = numberPart * 1024L;
            } else if (value.endsWith(MEGABYTES)) {
                long numberPart = this.parseSizeWithUnit(value);
                size = numberPart * 1024L * 1024L;
            } else if (value.endsWith(GIGABYTES)) {
                long numberPart = this.parseSizeWithUnit(value);
                size = numberPart * 1024L * 1024L * 1024L;
            } else {
                size = Long.parseLong(value);
            }
            return ConversionService.SHARED.convert((Object)size, targetType);
        }
        catch (NumberFormatException e) {
            context.reject(value, e);
            return Optional.empty();
        }
    }

    private long parseSizeWithUnit(String value) {
        return Long.parseLong(value.substring(0, value.length() - 2));
    }
}

