/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadataProvider;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.type.TypeInformationProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.ServiceLoader;

@Internal
final class RuntimeTypeInformation {
    RuntimeTypeInformation() {
    }

    private static boolean isJavaBasicTypeAndNotReactiveAndNotWrapper(Class<?> type) {
        return ClassUtils.isJavaBasicType(type);
    }

    static boolean isSpecifiedSingle(Class<?> type, AnnotationMetadataProvider annotationMetadata) {
        if (RuntimeTypeInformation.isJavaBasicTypeAndNotReactiveAndNotWrapper(type)) {
            return false;
        }
        for (TypeInformationProvider provider : LazyTypeInfo.TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isSpecifiedSingle(annotationMetadata)) continue;
            return true;
        }
        return false;
    }

    static boolean isSingle(Class<?> type) {
        if (RuntimeTypeInformation.isJavaBasicTypeAndNotReactiveAndNotWrapper(type)) {
            return false;
        }
        for (TypeInformationProvider provider : LazyTypeInfo.TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isSingle(type)) continue;
            return true;
        }
        return false;
    }

    static boolean isReactive(Class<?> type) {
        if (RuntimeTypeInformation.isJavaBasicTypeAndNotReactiveAndNotWrapper(type)) {
            return false;
        }
        for (TypeInformationProvider provider : LazyTypeInfo.TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isReactive(type)) continue;
            return true;
        }
        return false;
    }

    static boolean isCompletable(Class<?> type) {
        if (RuntimeTypeInformation.isJavaBasicTypeAndNotReactiveAndNotWrapper(type)) {
            return false;
        }
        for (TypeInformationProvider provider : LazyTypeInfo.TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isCompletable(type)) continue;
            return true;
        }
        return false;
    }

    static <T> boolean isWrapperType(Class<T> type) {
        if (RuntimeTypeInformation.isJavaBasicTypeAndNotReactiveAndNotWrapper(type)) {
            return false;
        }
        for (TypeInformationProvider provider : LazyTypeInfo.TYPE_INFORMATION_PROVIDERS) {
            if (!provider.isWrapperType(type)) continue;
            return true;
        }
        return type == Optional.class || LazyWrappers.WRAPPER_TO_TYPE.containsKey(type);
    }

    static <T> Argument<?> getWrappedType(@NonNull TypeInformation<?> typeInfo) {
        Argument<?> a = LazyWrappers.WRAPPER_TO_TYPE.get(typeInfo.getType());
        if (a != null) {
            return a;
        }
        return typeInfo.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
    }

    private static class LazyTypeInfo {
        private static final Collection<TypeInformationProvider> TYPE_INFORMATION_PROVIDERS;

        private LazyTypeInfo() {
        }

        static {
            ServiceLoader<TypeInformationProvider> loader = ServiceLoader.load(TypeInformationProvider.class);
            ArrayList<TypeInformationProvider> informationProviders = new ArrayList<TypeInformationProvider>(2);
            for (TypeInformationProvider informationProvider : loader) {
                informationProviders.add(informationProvider);
            }
            TYPE_INFORMATION_PROVIDERS = Collections.unmodifiableList(informationProviders);
        }
    }

    private static class LazyWrappers {
        private static final Map<Class<?>, Argument<?>> WRAPPER_TO_TYPE = new HashMap(3);

        private LazyWrappers() {
        }

        static {
            WRAPPER_TO_TYPE.put(OptionalDouble.class, Argument.DOUBLE);
            WRAPPER_TO_TYPE.put(OptionalLong.class, Argument.LONG);
            WRAPPER_TO_TYPE.put(OptionalInt.class, Argument.INT);
        }
    }
}

