/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.graal.reflect;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Generated;
import io.micronaut.core.graal.GraalReflectionConfigurer;
import io.micronaut.inject.annotation.AnnotationMetadataGenUtils;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.ByteCodeWriterUtils;
import io.micronaut.inject.writer.ClassOutputWriter;
import io.micronaut.inject.writer.ClassWriterOutputVisitor;
import io.micronaut.sourcegen.model.AnnotationDef;
import io.micronaut.sourcegen.model.ClassDef;
import io.micronaut.sourcegen.model.ClassTypeDef;
import io.micronaut.sourcegen.model.FieldDef;
import io.micronaut.sourcegen.model.ObjectDef;
import io.micronaut.sourcegen.model.StatementDef;
import io.micronaut.sourcegen.model.TypeDef;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.function.Function;
import javax.lang.model.element.Modifier;

final class GraalReflectionMetadataWriter
implements ClassOutputWriter {
    private final ClassElement originatingElement;
    private final AnnotationMetadata annotationMetadata;
    private final String className;
    private final VisitorContext visitorContext;

    public GraalReflectionMetadataWriter(ClassElement originatingElement, AnnotationMetadata annotationMetadata, VisitorContext visitorContext) {
        this.annotationMetadata = annotationMetadata;
        this.originatingElement = originatingElement;
        this.className = GraalReflectionMetadataWriter.resolveName(originatingElement);
        this.visitorContext = visitorContext;
    }

    private static String resolveName(ClassElement originatingElement) {
        return originatingElement.getPackageName() + ".$" + originatingElement.getSimpleName() + "$ReflectConfig";
    }

    public void accept(ClassWriterOutputVisitor classWriterOutputVisitor) throws IOException {
        ClassTypeDef thisType = ClassTypeDef.of((String)this.className);
        try (OutputStream outputStream = classWriterOutputVisitor.visitClass(this.className, (Element)this.originatingElement);){
            ClassDef.ClassDefBuilder classDefBuilder = (ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)((ClassDef.ClassDefBuilder)ClassDef.builder((String)this.className).synthetic()).addModifiers(new Modifier[]{Modifier.PUBLIC})).addAnnotation(AnnotationDef.builder(Generated.class).addMember("service", (Object)GraalReflectionConfigurer.class.getName()).build())).addSuperinterface((TypeDef)ClassTypeDef.of(GraalReflectionConfigurer.class))).addMethod(AnnotationMetadataGenUtils.createGetAnnotationMetadataMethodDef((ClassTypeDef)thisType, (AnnotationMetadata)this.annotationMetadata));
            LinkedHashMap loadTypeMethods = new LinkedHashMap();
            Function loadClassValueExpressionFn = AnnotationMetadataGenUtils.createLoadClassValueExpressionFn((ClassTypeDef)thisType, loadTypeMethods);
            ArrayList staticInit = new ArrayList();
            AnnotationMetadataGenUtils.addAnnotationDefaults(staticInit, (AnnotationMetadata)this.annotationMetadata, (Function)loadClassValueExpressionFn);
            FieldDef annotationMetadataField = AnnotationMetadataGenUtils.createAnnotationMetadataFieldAndInitialize((AnnotationMetadata)this.annotationMetadata, (Function)loadClassValueExpressionFn);
            loadTypeMethods.values().forEach(arg_0 -> ((ClassDef.ClassDefBuilder)classDefBuilder).addMethod(arg_0));
            if (annotationMetadataField != null) {
                classDefBuilder.addField(annotationMetadataField);
            }
            if (!staticInit.isEmpty()) {
                classDefBuilder.addStaticInitializer(StatementDef.multi(staticInit));
            }
            outputStream.write(ByteCodeWriterUtils.writeByteCode((ObjectDef)classDefBuilder.build(), (VisitorContext)this.visitorContext));
        }
        classWriterOutputVisitor.visitServiceDescriptor(GraalReflectionConfigurer.class, this.className, (Element)this.originatingElement);
    }
}

