/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client;

import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.exceptions.NoAvailableServiceException;
import io.micronaut.http.client.loadbalance.FixedLoadBalancer;
import java.net.URL;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;

@FunctionalInterface
public interface LoadBalancer {
    public Publisher<ServiceInstance> select(@Nullable Object var1);

    default public Publisher<ServiceInstance> select() {
        return this.select(null);
    }

    public static LoadBalancer fixed(URL url) {
        return new FixedLoadBalancer(url);
    }

    public static LoadBalancer empty() {
        return discriminator -> Publishers.just((Throwable)new NoAvailableServiceException("Load balancer contains no servers"));
    }
}

