/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.multipart;

import io.micronaut.http.MediaType;
import io.micronaut.http.client.multipart.AbstractFilePart;
import io.micronaut.http.client.multipart.BytePart;
import io.micronaut.http.client.multipart.FilePart;
import io.micronaut.http.client.multipart.InputStreamPart;
import io.micronaut.http.client.multipart.Part;
import io.micronaut.http.client.multipart.StringPart;
import io.micronaut.http.multipart.MultipartException;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class MultipartBody {
    private final List<Part> parts;

    private MultipartBody(List<Part> parts) {
        this.parts = parts;
    }

    public List<InterfaceHttpData> getData(HttpRequest request, HttpDataFactory factory) {
        ArrayList<InterfaceHttpData> data = new ArrayList<InterfaceHttpData>(this.parts.size());
        for (Part part : this.parts) {
            data.add(part.getData(request, factory));
        }
        return data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Part> parts = new ArrayList<Part>();

        private Builder() {
        }

        public Builder addPart(String name, File file) {
            return this.addPart(name, file.getName(), file);
        }

        public Builder addPart(String name, String filename, File file) {
            return this.addFilePart(new FilePart(name, filename, file));
        }

        public Builder addPart(String name, String filename, MediaType contentType, File file) {
            return this.addFilePart(new FilePart(name, filename, contentType, file));
        }

        public Builder addPart(String name, String filename, byte[] data) {
            return this.addFilePart(new BytePart(name, filename, data));
        }

        public Builder addPart(String name, String filename, MediaType contentType, byte[] data) {
            return this.addFilePart(new BytePart(name, filename, contentType, data));
        }

        public Builder addPart(String name, String filename, InputStream data, long contentLength) {
            return this.addFilePart(new InputStreamPart(name, filename, data, contentLength));
        }

        public Builder addPart(String name, String filename, MediaType contentType, InputStream data, long contentLength) {
            return this.addFilePart(new InputStreamPart(name, filename, contentType, data, contentLength));
        }

        public Builder addPart(String name, String value) {
            this.parts.add(new StringPart(name, value));
            return this;
        }

        private Builder addFilePart(AbstractFilePart filePart) {
            this.parts.add(filePart);
            return this;
        }

        public MultipartBody build() throws MultipartException {
            if (this.parts.isEmpty()) {
                throw new MultipartException("Cannot create a MultipartBody with no parts");
            }
            return new MultipartBody(this.parts);
        }
    }
}

