/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.env.CachedEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.discovery.EmbeddedServerInstance;
import io.micronaut.discovery.ServiceInstance;
import io.micronaut.discovery.event.ServiceReadyEvent;
import io.micronaut.discovery.event.ServiceStoppedEvent;
import io.micronaut.http.context.event.HttpRequestTerminatedEvent;
import io.micronaut.http.netty.channel.ChannelPipelineListener;
import io.micronaut.http.netty.channel.DefaultEventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.EventLoopGroupConfiguration;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.netty.stream.StreamingInboundHttp2ToHttpAdapter;
import io.micronaut.http.netty.websocket.WebSocketSessionRepository;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.exceptions.ServerStartupException;
import io.micronaut.http.server.netty.DefaultHttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpPipelineBuilder;
import io.micronaut.http.server.netty.NettyEmbeddedServer;
import io.micronaut.http.server.netty.NettyEmbeddedServerInstance;
import io.micronaut.http.server.netty.NettyEmbeddedServices;
import io.micronaut.http.server.netty.RoutingInBoundHandler;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.http.server.netty.ssl.ServerSslBuilder;
import io.micronaut.http.server.netty.types.NettyCustomizableResponseTypeHandlerRegistry;
import io.micronaut.http.server.util.DefaultHttpHostResolver;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.ssl.ServerSslConfiguration;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.runtime.ApplicationConfiguration;
import io.micronaut.runtime.context.scope.refresh.RefreshEvent;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.runtime.server.event.ServerShutdownEvent;
import io.micronaut.runtime.server.event.ServerStartupEvent;
import io.micronaut.web.router.Router;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@TypeHint(value={ChannelOption.class}, accessType={TypeHint.AccessType.ALL_DECLARED_CONSTRUCTORS, TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class NettyHttpServer
implements NettyEmbeddedServer {
    public static final String OUTBOUND_KEY = "-outbound-";
    private static final Logger LOG = LoggerFactory.getLogger(NettyHttpServer.class);
    private final NettyEmbeddedServices nettyEmbeddedServices;
    private final NettyHttpServerConfiguration serverConfiguration;
    private final ServerSslConfiguration sslConfiguration;
    private final Environment environment;
    private final int specifiedPort;
    private final RoutingInBoundHandler routingHandler;
    private final HttpContentProcessorResolver httpContentProcessorResolver;
    private final boolean isDefault;
    private volatile int serverPort;
    private final ApplicationContext applicationContext;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ChannelGroup webSocketSessions = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private final HttpHostResolver hostResolver;
    private boolean shutdownWorker = false;
    private boolean shutdownParent = false;
    private EventLoopGroup workerGroup;
    private EventLoopGroup parentGroup;
    private EmbeddedServerInstance serviceInstance;
    private final Collection<ChannelPipelineListener> pipelineListeners = new ArrayList<ChannelPipelineListener>(2);
    private NettyHttpServerInitializer childHandler;
    private final Set<Integer> boundPorts = new HashSet<Integer>(2);

    public NettyHttpServer(NettyHttpServerConfiguration serverConfiguration, NettyEmbeddedServices nettyEmbeddedServices, NettyCustomizableResponseTypeHandlerRegistry handlerRegistry, boolean isDefault) {
        int port;
        this.isDefault = isDefault;
        this.serverConfiguration = serverConfiguration;
        this.nettyEmbeddedServices = nettyEmbeddedServices;
        Optional location = this.serverConfiguration.getMultipart().getLocation();
        location.ifPresent(dir -> {
            DiskFileUpload.baseDirectory = dir.getAbsolutePath();
        });
        this.applicationContext = nettyEmbeddedServices.getApplicationContext();
        this.environment = this.applicationContext.getEnvironment();
        ServerSslBuilder serverSslBuilder = nettyEmbeddedServices.getServerSslBuilder();
        if (serverSslBuilder != null) {
            this.sslConfiguration = serverSslBuilder.getSslConfiguration();
            this.specifiedPort = this.sslConfiguration.isEnabled() ? (port = this.sslConfiguration.getPort()) : (port = this.getHttpPort(this.serverConfiguration));
        } else {
            this.specifiedPort = port = this.getHttpPort(this.serverConfiguration);
            this.sslConfiguration = null;
        }
        this.serverPort = port;
        ApplicationEventPublisher<HttpRequestTerminatedEvent> httpRequestTerminatedEventPublisher = nettyEmbeddedServices.getEventPublisher(HttpRequestTerminatedEvent.class);
        Supplier ioExecutor = SupplierUtil.memoized(() -> nettyEmbeddedServices.getExecutorSelector().select("io").orElse(null));
        this.httpContentProcessorResolver = new DefaultHttpContentProcessorResolver((BeanLocator)nettyEmbeddedServices.getApplicationContext(), (BeanProvider<NettyHttpServerConfiguration>)((BeanProvider)() -> serverConfiguration));
        this.routingHandler = new RoutingInBoundHandler(serverConfiguration, handlerRegistry, nettyEmbeddedServices, ioExecutor, this.httpContentProcessorResolver, httpRequestTerminatedEventPublisher);
        this.hostResolver = new DefaultHttpHostResolver((HttpServerConfiguration)serverConfiguration, () -> this);
    }

    private int getHttpPort(NettyHttpServerConfiguration serverConfiguration) {
        Integer configPort = serverConfiguration.getPort().orElse(null);
        return this.getHttpPort(configPort);
    }

    private int getHttpPort(Integer configPort) {
        if (configPort != null) {
            return configPort;
        }
        if (this.environment.getActiveNames().contains("test")) {
            return -1;
        }
        return 8080;
    }

    public boolean isKeepAlive() {
        return false;
    }

    public NettyHttpServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public synchronized NettyEmbeddedServer start() {
        if (!this.isRunning()) {
            EventLoopGroupConfiguration workerConfig = this.resolveWorkerConfiguration();
            this.workerGroup = this.createWorkerEventLoopGroup(workerConfig);
            this.parentGroup = this.createParentEventLoopGroup();
            ServerBootstrap serverBootstrap = this.createServerBootstrap();
            serverBootstrap.channelFactory(() -> this.nettyEmbeddedServices.getServerSocketChannelInstance(workerConfig));
            this.processOptions(this.serverConfiguration.getOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).option(arg_0, arg_1));
            this.processOptions(this.serverConfiguration.getChildOptions(), (arg_0, arg_1) -> ((ServerBootstrap)serverBootstrap).childOption(arg_0, arg_1));
            this.childHandler = new NettyHttpServerInitializer();
            serverBootstrap = serverBootstrap.group(this.parentGroup, this.workerGroup).childHandler((ChannelHandler)this.childHandler);
            Optional host = this.serverConfiguration.getHost();
            String definedHost = host.orElse(null);
            this.serverPort = this.bindServerToHost(serverBootstrap, definedHost, this.serverPort);
            if (this.isDefault) {
                ArrayList<Integer> defaultPorts = new ArrayList<Integer>(2);
                defaultPorts.add(this.serverPort);
                if (this.serverConfiguration.isDualProtocol()) {
                    defaultPorts.add(this.bindServerToHost(serverBootstrap, definedHost, this.getHttpPort(this.serverConfiguration)));
                }
                Router router = this.nettyEmbeddedServices.getRouter();
                Set exposedPorts = router.getExposedPorts();
                this.boundPorts.addAll(defaultPorts);
                if (CollectionUtils.isNotEmpty((Collection)exposedPorts)) {
                    router.applyDefaultPorts(defaultPorts);
                    for (Integer exposedPort : exposedPorts) {
                        if (defaultPorts.contains(exposedPort)) continue;
                        try {
                            if (definedHost != null) {
                                serverBootstrap.bind(definedHost, exposedPort.intValue()).sync();
                            } else {
                                serverBootstrap.bind(exposedPort.intValue()).sync();
                            }
                            this.boundPorts.add(exposedPort);
                        }
                        catch (Throwable e) {
                            boolean isBindError = e instanceof BindException;
                            if (LOG.isErrorEnabled()) {
                                if (isBindError) {
                                    LOG.error("Unable to start server. Additional specified server port {} already in use.", (Object)exposedPort);
                                } else {
                                    LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                                }
                            }
                            throw new ServerStartupException("Unable to start Micronaut server on port: " + this.serverPort, e);
                        }
                    }
                }
            }
            this.fireStartupEvents();
            this.running.set(true);
        }
        return this;
    }

    private EventLoopGroupConfiguration resolveWorkerConfiguration() {
        NettyHttpServerConfiguration.Worker workerConfig = this.serverConfiguration.getWorker();
        if (workerConfig == null) {
            workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration("default").orElse(null);
        } else {
            String eventLoopGroupName = workerConfig.getName();
            if (!"default".equals(eventLoopGroupName)) {
                workerConfig = this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroupConfiguration(eventLoopGroupName).orElse(workerConfig);
            }
        }
        return workerConfig;
    }

    @Override
    public synchronized NettyEmbeddedServer stop() {
        if (this.isRunning() && this.workerGroup != null && this.running.compareAndSet(true, false)) {
            this.stopInternal();
        }
        return this;
    }

    public int getPort() {
        if (!this.isRunning() && this.serverPort == -1) {
            throw new UnsupportedOperationException("Retrieving the port from the server before it has started is not supported when binding to a random port");
        }
        return this.serverPort;
    }

    public String getHost() {
        return this.serverConfiguration.getHost().orElseGet(() -> Optional.ofNullable(CachedEnvironment.getenv((String)"HOSTNAME")).orElse("localhost"));
    }

    public String getScheme() {
        return this.sslConfiguration != null && this.sslConfiguration.isEnabled() ? "https" : "http";
    }

    public URL getURL() {
        try {
            return new URL(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public URI getURI() {
        try {
            return new URI(this.getScheme() + "://" + this.getHost() + ':' + this.getPort());
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException("Invalid server URL: " + e.getMessage(), (Throwable)e);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.serverConfiguration.getApplicationConfiguration();
    }

    @Override
    public final Set<Integer> getBoundPorts() {
        return Collections.unmodifiableSet(this.boundPorts);
    }

    protected EventLoopGroup createParentEventLoopGroup() {
        NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(parent != null ? parent.getName() : "parent").orElseGet(() -> {
            EventLoopGroup newGroup = this.newEventLoopGroup(parent);
            this.shutdownParent = true;
            return newGroup;
        });
    }

    protected EventLoopGroup createWorkerEventLoopGroup(@Nullable EventLoopGroupConfiguration workerConfig) {
        String configName = workerConfig != null ? workerConfig.getName() : "default";
        return this.nettyEmbeddedServices.getEventLoopGroupRegistry().getEventLoopGroup(configName).orElseGet(() -> {
            LOG.warn("The configuration for 'micronaut.server.netty.worker.{}' is deprecated. Use 'micronaut.netty.event-loops.default' configuration instead.", (Object)configName);
            EventLoopGroup newGroup = this.newEventLoopGroup(workerConfig);
            this.shutdownWorker = true;
            return newGroup;
        });
    }

    protected ServerBootstrap createServerBootstrap() {
        return new ServerBootstrap();
    }

    private int bindServerToHost(ServerBootstrap serverBootstrap, @Nullable String host, int port) {
        boolean isRandomPort = this.specifiedPort == -1;
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        if (applicationName.isPresent()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Binding {} server to {}:{}", new Object[]{applicationName.get(), host != null ? host : "*", port});
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("Binding server to {}:{}", (Object)(host != null ? host : "*"), (Object)port);
        }
        try {
            if (isRandomPort) {
                ChannelFuture future = host != null ? serverBootstrap.bind(host, 0).sync() : serverBootstrap.bind(0).sync();
                InetSocketAddress ia = (InetSocketAddress)future.channel().localAddress();
                return ia.getPort();
            }
            if (host != null) {
                serverBootstrap.bind(host, port).sync();
            } else {
                serverBootstrap.bind(port).sync();
            }
            return port;
        }
        catch (Throwable e) {
            boolean isBindError = e instanceof BindException;
            if (LOG.isErrorEnabled()) {
                if (isBindError) {
                    LOG.error("Unable to start server. Port {} already in use.", (Object)port);
                } else {
                    LOG.error("Error starting Micronaut server: " + e.getMessage(), e);
                }
            }
            this.stopInternal();
            throw new ServerStartupException("Unable to start Micronaut server on port: " + port, e);
        }
    }

    private void fireStartupEvents() {
        Optional applicationName = this.serverConfiguration.getApplicationConfiguration().getName();
        this.applicationContext.getEventPublisher(ServerStartupEvent.class).publishEvent((Object)new ServerStartupEvent((EmbeddedServer)this));
        applicationName.ifPresent(id -> {
            this.serviceInstance = (EmbeddedServerInstance)this.applicationContext.createBean(NettyEmbeddedServerInstance.class, new Object[]{id, this});
            this.applicationContext.getEventPublisher(ServiceReadyEvent.class).publishEvent((Object)new ServiceReadyEvent((ServiceInstance)this.serviceInstance));
        });
    }

    private void logShutdownErrorIfNecessary(Future<?> future) {
        if (!future.isSuccess() && LOG.isWarnEnabled()) {
            Throwable e = future.cause();
            LOG.warn("Error stopping Micronaut server: " + e.getMessage(), e);
        }
    }

    private void stopInternal() {
        block9: {
            try {
                if (this.shutdownParent) {
                    NettyHttpServerConfiguration.Parent parent = this.serverConfiguration.getParent();
                    if (parent != null) {
                        long quietPeriod = parent.getShutdownQuietPeriod().toMillis();
                        long timeout = parent.getShutdownTimeout().toMillis();
                        this.parentGroup.shutdownGracefully(quietPeriod, timeout, TimeUnit.MILLISECONDS).addListener(this::logShutdownErrorIfNecessary);
                    } else {
                        this.parentGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                    }
                }
                if (this.shutdownWorker) {
                    this.workerGroup.shutdownGracefully().addListener(this::logShutdownErrorIfNecessary);
                }
                this.webSocketSessions.close();
                this.applicationContext.getEventPublisher(ServerShutdownEvent.class).publishEvent((Object)new ServerShutdownEvent((EmbeddedServer)this));
                if (this.serviceInstance != null) {
                    this.applicationContext.getEventPublisher(ServiceStoppedEvent.class).publishEvent((Object)new ServiceStoppedEvent((ServiceInstance)this.serviceInstance));
                }
                if (this.isDefault) {
                    if (this.applicationContext.isRunning()) {
                        this.applicationContext.stop();
                    }
                    this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                        DiskFileUpload.baseDirectory = null;
                    });
                }
                this.serverConfiguration.getMultipart().getLocation().ifPresent(dir -> {
                    DiskFileUpload.baseDirectory = null;
                });
                this.childHandler = null;
                this.boundPorts.clear();
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error("Error stopping Micronaut server: " + e.getMessage(), e);
            }
        }
    }

    private EventLoopGroup newEventLoopGroup(EventLoopGroupConfiguration config) {
        if (config != null) {
            ExecutorService executorService = config.getExecutorName().flatMap(name -> this.applicationContext.findBean(ExecutorService.class, Qualifiers.byName((String)name))).orElse(null);
            if (executorService != null) {
                return this.nettyEmbeddedServices.createEventLoopGroup(config.getNumThreads(), executorService, config.getIoRatio().orElse(null));
            }
            return this.nettyEmbeddedServices.createEventLoopGroup(config);
        }
        return this.nettyEmbeddedServices.createEventLoopGroup((EventLoopGroupConfiguration)new DefaultEventLoopGroupConfiguration());
    }

    private void processOptions(Map<ChannelOption, Object> options, BiConsumer<ChannelOption, Object> biConsumer) {
        ChannelOptionFactory channelOptionFactory = this.nettyEmbeddedServices.getChannelOptionFactory();
        options.forEach((option, value) -> biConsumer.accept((ChannelOption)option, channelOptionFactory.convertValue(option, value, this.environment)));
    }

    public void addChannel(Channel channel) {
        this.webSocketSessions.add((Object)channel);
    }

    public void removeChannel(Channel channel) {
        this.webSocketSessions.remove((Object)channel);
    }

    public ChannelGroup getChannelGroup() {
        return this.webSocketSessions;
    }

    public WebSocketSessionRepository getWebSocketSessionRepository() {
        return this;
    }

    private HttpToHttp2ConnectionHandler newHttpToHttp2ConnectionHandler() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        StreamingInboundHttp2ToHttpAdapter http2ToHttpAdapter = new StreamingInboundHttp2ToHttpAdapter((Http2Connection)connection, (int)this.serverConfiguration.getMaxRequestSize(), this.serverConfiguration.isValidateHeaders(), true);
        HttpToHttp2ConnectionHandlerBuilder builder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)http2ToHttpAdapter).validateHeaders(this.serverConfiguration.isValidateHeaders()).initialSettings(this.serverConfiguration.getHttp2().http2Settings());
        this.serverConfiguration.getLogLevel().ifPresent(logLevel -> builder.frameLogger(new Http2FrameLogger(logLevel, NettyHttpServer.class)));
        return builder.connection((Http2Connection)connection).build();
    }

    public boolean isClientChannel() {
        return false;
    }

    public void doOnConnect(@NonNull ChannelPipelineListener listener) {
        this.pipelineListeners.add(Objects.requireNonNull(listener, "The listener cannot be null"));
    }

    public Set<String> getObservedConfigurationPrefixes() {
        return Collections.singleton("micronaut.server");
    }

    public void onApplicationEvent(RefreshEvent event) {
        if (this.childHandler != null) {
            this.childHandler.initHttpCoders();
        }
    }

    final void triggerPipelineListeners(ChannelPipeline pipeline) {
        for (ChannelPipelineListener pipelineListener : this.pipelineListeners) {
            pipelineListener.onConnect(pipeline);
        }
    }

    private HttpPipelineBuilder createPipelineBuilder() {
        return new HttpPipelineBuilder(this, this.nettyEmbeddedServices, this.sslConfiguration, this.routingHandler, this.hostResolver);
    }

    @Internal
    public EmbeddedChannel buildEmbeddedChannel(boolean ssl) {
        EmbeddedChannel embeddedChannel = new EmbeddedChannel();
        HttpPipelineBuilder httpPipelineBuilder = this.createPipelineBuilder();
        httpPipelineBuilder.getClass();
        httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline((Channel)embeddedChannel, ssl).initChannel();
        return embeddedChannel;
    }

    static Predicate<String> inclusionPredicate(NettyHttpServerConfiguration.AccessLogger config) {
        List<String> exclusions = config.getExclusions();
        if (CollectionUtils.isEmpty(exclusions)) {
            return null;
        }
        List patterns = exclusions.stream().map(Pattern::compile).collect(Collectors.toList());
        return uri -> patterns.stream().noneMatch(pattern -> pattern.matcher((CharSequence)uri).matches());
    }

    private class NettyHttpServerInitializer
    extends ChannelInitializer<SocketChannel> {
        private volatile HttpPipelineBuilder httpPipelineBuilder;

        private NettyHttpServerInitializer() {
            this.initHttpCoders();
        }

        void initHttpCoders() {
            this.httpPipelineBuilder = NettyHttpServer.this.createPipelineBuilder();
        }

        protected void initChannel(SocketChannel ch) {
            int port = ch.localAddress().getPort();
            boolean ssl = this.httpPipelineBuilder.supportsSsl() && NettyHttpServer.this.sslConfiguration != null && port == NettyHttpServer.this.serverPort;
            HttpPipelineBuilder httpPipelineBuilder = this.httpPipelineBuilder;
            httpPipelineBuilder.getClass();
            httpPipelineBuilder.new HttpPipelineBuilder.ConnectionPipeline((Channel)ch, ssl).initChannel();
        }
    }
}

