/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.exceptions;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Produces;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import io.micronaut.http.server.exceptions.response.Error;
import io.micronaut.http.server.exceptions.response.ErrorContext;
import io.micronaut.http.server.exceptions.response.ErrorResponseProcessor;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;

@Produces
@Singleton
public class JsonExceptionHandler
implements ExceptionHandler<JsonProcessingException, Object> {
    private final ErrorResponseProcessor<?> responseProcessor;

    @Inject
    public JsonExceptionHandler(ErrorResponseProcessor<?> responseProcessor) {
        this.responseProcessor = responseProcessor;
    }

    @Override
    public Object handle(HttpRequest request, final JsonProcessingException exception) {
        MutableHttpResponse response = HttpResponse.status((HttpStatus)HttpStatus.BAD_REQUEST, (String)"Invalid JSON");
        return this.responseProcessor.processResponse(ErrorContext.builder(request).cause((Throwable)exception).error(new Error(){

            @Override
            public String getMessage() {
                return "Invalid JSON: " + exception.getMessage();
            }

            @Override
            public Optional<String> getTitle() {
                return Optional.of("Invalid JSON");
            }
        }).build(), response);
    }
}

