/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.cookie;

import io.micronaut.http.exceptions.HttpException;

public final class CookieSizeExceededException
extends HttpException {
    private final String cookieName;
    private final int maxSize;
    private final int size;

    public CookieSizeExceededException(String cookieName, int maxSize, int size) {
        super("The cookie [%s] byte size [%d] exceeds the maximum cookie size [%d]".formatted(cookieName, size, maxSize));
        this.cookieName = cookieName;
        this.maxSize = maxSize;
        this.size = size;
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getSize() {
        return this.size;
    }
}

