/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing.visitor;

import io.micronaut.annotation.processing.AnnotationUtils;
import io.micronaut.annotation.processing.visitor.JavaClassElement;
import io.micronaut.annotation.processing.visitor.JavaEnumElement;
import io.micronaut.annotation.processing.visitor.JavaGenericPlaceholderElement;
import io.micronaut.annotation.processing.visitor.JavaVisitorContext;
import io.micronaut.annotation.processing.visitor.JavaWildcardElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueBuilder;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.annotation.AbstractAnnotationMetadataBuilder;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.PrimitiveElement;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.UnionType;
import javax.lang.model.type.WildcardType;

public abstract class AbstractJavaElement
implements Element,
AnnotationMetadataDelegate {
    private final javax.lang.model.element.Element element;
    private final JavaVisitorContext visitorContext;
    private AnnotationMetadata annotationMetadata;

    AbstractJavaElement(javax.lang.model.element.Element element, AnnotationMetadata annotationMetadata, JavaVisitorContext visitorContext) {
        this.element = element;
        this.annotationMetadata = annotationMetadata;
        this.visitorContext = visitorContext;
    }

    @NonNull
    public <T extends Annotation> Element annotate(@NonNull String annotationType, @NonNull Consumer<AnnotationValueBuilder<T>> consumer) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        ArgumentUtils.requireNonNull((String)"consumer", consumer);
        AnnotationValueBuilder builder = AnnotationValue.builder((String)annotationType);
        consumer.accept(builder);
        AnnotationValue av = builder.build();
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        this.annotationMetadata = annotationUtils.newAnnotationBuilder().annotate(this.annotationMetadata, av);
        this.updateMetadataCaches();
        return this;
    }

    public <T extends Annotation> Element annotate(AnnotationValue<T> annotationValue) {
        ArgumentUtils.requireNonNull((String)"annotationValue", annotationValue);
        AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
        this.annotationMetadata = annotationUtils.newAnnotationBuilder().annotate(this.annotationMetadata, annotationValue);
        this.updateMetadataCaches();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeAnnotation(@NonNull String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        try {
            AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
            this.annotationMetadata = annotationUtils.newAnnotationBuilder().removeAnnotation(this.annotationMetadata, annotationType);
            AbstractJavaElement abstractJavaElement = this;
            return abstractJavaElement;
        }
        finally {
            this.updateMetadataCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Annotation> Element removeAnnotationIf(@NonNull Predicate<AnnotationValue<T>> predicate) {
        if (predicate != null) {
            try {
                AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
                this.annotationMetadata = annotationUtils.newAnnotationBuilder().removeAnnotationIf(this.annotationMetadata, predicate);
                AbstractJavaElement abstractJavaElement = this;
                return abstractJavaElement;
            }
            finally {
                this.updateMetadataCaches();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element removeStereotype(@NonNull String annotationType) {
        ArgumentUtils.requireNonNull((String)"annotationType", (Object)annotationType);
        try {
            AnnotationUtils annotationUtils = this.visitorContext.getAnnotationUtils();
            this.annotationMetadata = annotationUtils.newAnnotationBuilder().removeStereotype(this.annotationMetadata, annotationType);
            AbstractJavaElement abstractJavaElement = this;
            return abstractJavaElement;
        }
        finally {
            this.updateMetadataCaches();
        }
    }

    private void updateMetadataCaches() {
        String declaringTypeName = this.resolveDeclaringTypeName();
        AbstractAnnotationMetadataBuilder.addMutatedMetadata((String)declaringTypeName, (Object)this.element, (AnnotationMetadata)this.annotationMetadata);
        AnnotationUtils.invalidateMetadata(this.element);
    }

    private String resolveDeclaringTypeName() {
        String declaringTypeName;
        if (this instanceof MemberElement) {
            ClassElement owningType = ((MemberElement)this).getOwningType();
            javax.lang.model.element.Element nativeType = (javax.lang.model.element.Element)owningType.getNativeType();
            declaringTypeName = this.resolveCanonicalName(nativeType);
        } else {
            javax.lang.model.element.Element nativeType = (javax.lang.model.element.Element)this.getNativeType();
            declaringTypeName = this.resolveCanonicalName(nativeType);
        }
        return declaringTypeName;
    }

    private String resolveCanonicalName(javax.lang.model.element.Element nativeType) {
        TypeElement typeElement = this.visitorContext.getModelUtils().classElementFor(nativeType);
        String declaringTypeName = typeElement == null ? this.getName() : typeElement.getQualifiedName().toString();
        return declaringTypeName;
    }

    public boolean isPackagePrivate() {
        Set<Modifier> modifiers = this.element.getModifiers();
        return !modifiers.contains((Object)Modifier.PUBLIC) && !modifiers.contains((Object)Modifier.PROTECTED) && !modifiers.contains((Object)Modifier.PRIVATE);
    }

    public String getName() {
        return this.element.getSimpleName().toString();
    }

    public Set<ElementModifier> getModifiers() {
        return this.element.getModifiers().stream().map(m -> ElementModifier.valueOf((String)m.name())).collect(Collectors.toSet());
    }

    public boolean isAbstract() {
        return this.hasModifier(Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return this.hasModifier(Modifier.STATIC);
    }

    public boolean isPublic() {
        return this.hasModifier(Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return this.hasModifier(Modifier.PRIVATE);
    }

    public boolean isFinal() {
        return this.hasModifier(Modifier.FINAL);
    }

    public boolean isProtected() {
        return this.hasModifier(Modifier.PROTECTED);
    }

    public Object getNativeType() {
        return this.element;
    }

    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    public String toString() {
        return this.element.toString();
    }

    @NonNull
    protected ClassElement parameterizedClassElement(TypeMirror typeMirror, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> declaredGenericInfo) {
        return this.mirrorToClassElement(typeMirror, visitorContext, declaredGenericInfo, true);
    }

    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext) {
        return this.mirrorToClassElement(returnType, visitorContext, Collections.emptyMap(), true);
    }

    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo) {
        return this.mirrorToClassElement(returnType, visitorContext, genericsInfo, true);
    }

    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo, boolean includeTypeAnnotations) {
        return this.mirrorToClassElement(returnType, visitorContext, genericsInfo, includeTypeAnnotations, returnType instanceof TypeVariable);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    protected ClassElement mirrorToClassElement(TypeMirror returnType, JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo222, boolean includeTypeAnnotations, boolean isTypeVariable) {
        void genericsInfo222;
        if (genericsInfo222 == null) {
            Map genericsInfo222 = Collections.emptyMap();
        }
        if (returnType instanceof NoType) {
            return PrimitiveElement.VOID;
        }
        if (returnType instanceof DeclaredType) {
            AnnotationMetadata newAnnotationMetadata;
            DeclaredType dt = (DeclaredType)returnType;
            javax.lang.model.element.Element element = dt.asElement();
            if (!(element.asType() instanceof DeclaredType)) return this.mirrorToClassElement(element.asType(), visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations);
            List<? extends TypeMirror> typeArguments = dt.getTypeArguments();
            if (!(element instanceof TypeElement)) return PrimitiveElement.VOID;
            TypeElement typeElement = (TypeElement)element;
            Map<String, TypeMirror> boundGenerics = this.resolveBoundGenerics(visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222);
            AnnotationUtils annotationUtils = visitorContext.getAnnotationUtils();
            List<? extends AnnotationMirror> annotationMirrors = dt.getAnnotationMirrors();
            if (!annotationMirrors.isEmpty()) {
                newAnnotationMetadata = annotationUtils.newAnnotationBuilder().buildDeclared(typeElement, annotationMirrors, (boolean)includeTypeAnnotations);
            } else {
                AnnotationMetadata annotationMetadata = newAnnotationMetadata = includeTypeAnnotations != false ? annotationUtils.getAnnotationMetadata(typeElement) : AnnotationMetadata.EMPTY_METADATA;
            }
            if (visitorContext.getModelUtils().resolveKind(typeElement, ElementKind.ENUM).isPresent()) {
                return new JavaEnumElement(typeElement, newAnnotationMetadata, visitorContext);
            }
            Map<String, Map<String, TypeMirror>> genericsInfo222 = visitorContext.getGenericUtils().alignNewGenericsInfo(typeElement, typeArguments, boundGenerics);
            return new JavaClassElement(typeElement, newAnnotationMetadata, visitorContext, typeArguments, genericsInfo222, (boolean)isTypeVariable);
        }
        if (returnType instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)returnType;
            return this.resolveTypeVariable(visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations, tv, tv);
        }
        if (returnType instanceof ArrayType) {
            ClassElement arrayType;
            ArrayType at = (ArrayType)returnType;
            TypeMirror typeMirror = at.getComponentType();
            if (typeMirror instanceof TypeVariable && typeMirror.getKind() == TypeKind.TYPEVAR) {
                TypeVariable tv = (TypeVariable)typeMirror;
                arrayType = this.resolveTypeVariable(visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations, tv, at);
                return arrayType.toArray();
            } else {
                arrayType = this.mirrorToClassElement(typeMirror, visitorContext, (Map<String, Map<String, TypeMirror>>)genericsInfo222, (boolean)includeTypeAnnotations);
            }
            return arrayType.toArray();
        }
        if (returnType instanceof PrimitiveType) {
            PrimitiveType pt = (PrimitiveType)returnType;
            return PrimitiveElement.valueOf((String)pt.getKind().name());
        }
        if (!(returnType instanceof WildcardType)) return PrimitiveElement.VOID;
        WildcardType wt = (WildcardType)returnType;
        void var7_16 = genericsInfo222;
        TypeMirror superBound = wt.getSuperBound();
        Stream<Object> lowerBounds = superBound instanceof UnionType ? ((UnionType)superBound).getAlternatives().stream() : (superBound == null ? Stream.empty() : Stream.of(superBound));
        TypeMirror extendsBound = wt.getExtendsBound();
        Stream<Object> upperBounds = extendsBound instanceof IntersectionType ? ((IntersectionType)extendsBound).getBounds().stream() : (extendsBound == null ? Stream.of(visitorContext.getElements().getTypeElement("java.lang.Object").asType()) : Stream.of(extendsBound));
        return new JavaWildcardElement(wt, upperBounds.map(arg_0 -> this.lambda$mirrorToClassElement$1(visitorContext, (Map)var7_16, (boolean)includeTypeAnnotations, arg_0)).collect(Collectors.toList()), lowerBounds.map(arg_0 -> this.lambda$mirrorToClassElement$2(visitorContext, (Map)var7_16, (boolean)includeTypeAnnotations, arg_0)).collect(Collectors.toList()));
    }

    private ClassElement resolveTypeVariable(JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo, boolean includeTypeAnnotations, TypeVariable tv, TypeMirror declaration) {
        TypeMirror upperBound = tv.getUpperBound();
        Map<String, TypeMirror> boundGenerics = this.resolveBoundGenerics(visitorContext, genericsInfo);
        TypeMirror bound = boundGenerics.get(tv.toString());
        if (bound != null && bound != declaration) {
            return this.mirrorToClassElement(bound, visitorContext, genericsInfo, includeTypeAnnotations, true);
        }
        List<TypeMirror> boundsUnresolved = upperBound instanceof IntersectionType ? ((IntersectionType)upperBound).getBounds() : Collections.singletonList(upperBound);
        List<JavaClassElement> bounds = boundsUnresolved.stream().map(tm -> (JavaClassElement)this.mirrorToClassElement((TypeMirror)tm, visitorContext, genericsInfo, includeTypeAnnotations)).collect(Collectors.toList());
        return new JavaGenericPlaceholderElement(tv, bounds, 0);
    }

    private Map<String, TypeMirror> resolveBoundGenerics(JavaVisitorContext visitorContext, Map<String, Map<String, TypeMirror>> genericsInfo) {
        Map<String, TypeMirror> boundGenerics;
        String declaringTypeName = null;
        TypeElement typeElement = visitorContext.getModelUtils().classElementFor(this.element);
        if (typeElement != null) {
            declaringTypeName = typeElement.getQualifiedName().toString();
        }
        if ((boundGenerics = genericsInfo.get(declaringTypeName)) == null) {
            boundGenerics = Collections.emptyMap();
        }
        return boundGenerics;
    }

    private boolean hasModifier(Modifier modifier) {
        return this.element.getModifiers().contains((Object)modifier);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractJavaElement that = (AbstractJavaElement)o;
        return this.element.equals(that.element);
    }

    public int hashCode() {
        return Objects.hash(this.element);
    }

    private /* synthetic */ JavaClassElement lambda$mirrorToClassElement$2(JavaVisitorContext visitorContext, Map finalGenericsInfo, boolean includeTypeAnnotations, TypeMirror tm) {
        return (JavaClassElement)this.mirrorToClassElement(tm, visitorContext, finalGenericsInfo, includeTypeAnnotations);
    }

    private /* synthetic */ JavaClassElement lambda$mirrorToClassElement$1(JavaVisitorContext visitorContext, Map finalGenericsInfo, boolean includeTypeAnnotations, TypeMirror tm) {
        return (JavaClassElement)this.mirrorToClassElement(tm, visitorContext, finalGenericsInfo, includeTypeAnnotations);
    }
}

