/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.ApplicationContext;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.DefaultBeanResolutionContext;
import io.micronaut.context.DefaultConstructorInjectionPoint;
import io.micronaut.context.DefaultFieldConstructorInjectionPoint;
import io.micronaut.context.DefaultFieldInjectionPoint;
import io.micronaut.context.DefaultMethodConstructorInjectionPoint;
import io.micronaut.context.DefaultMethodInjectionPoint;
import io.micronaut.context.EnvironmentAwareArgument;
import io.micronaut.context.EnvironmentConfigurable;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.MissingMethodInjectionPoint;
import io.micronaut.context.Qualifier;
import io.micronaut.context.ReflectionConstructorInjectionPoint;
import io.micronaut.context.ReflectionFieldInjectionPoint;
import io.micronaut.context.ReflectionMethodConstructorInjectionPoint;
import io.micronaut.context.ReflectionMethodInjectionPoint;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.annotation.Parameter;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.annotation.Property;
import io.micronaut.context.annotation.Provided;
import io.micronaut.context.annotation.Type;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.Environment;
import io.micronaut.context.event.BeanInitializedEventListener;
import io.micronaut.context.event.BeanInitializingEvent;
import io.micronaut.context.exceptions.BeanContextException;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.context.exceptions.DependencyInjectionException;
import io.micronaut.context.exceptions.DisabledBeanException;
import io.micronaut.context.exceptions.NoSuchBeanException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.DefaultArgument;
import io.micronaut.core.type.TypeInformation;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.PropertyResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.ConstructorInjectionPoint;
import io.micronaut.inject.ExecutableMethod;
import io.micronaut.inject.FieldInjectionPoint;
import io.micronaut.inject.MethodInjectionPoint;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.annotation.AbstractEnvironmentAnnotationMetadata;
import io.micronaut.inject.qualifiers.InterceptorBindingQualifier;
import io.micronaut.inject.qualifiers.Qualifiers;
import io.micronaut.inject.qualifiers.TypeAnnotationQualifier;
import java.lang.annotation.Annotation;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class AbstractBeanDefinition<T>
extends AbstractBeanContextConditional
implements BeanDefinition<T>,
EnvironmentConfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBeanDefinition.class);
    private static final String NAMED_ATTRIBUTE = Named.class.getName();
    protected final List<MethodInjectionPoint<T, ?>> methodInjectionPoints = new ArrayList(3);
    protected final List<FieldInjectionPoint<T, ?>> fieldInjectionPoints = new ArrayList(3);
    protected List<MethodInjectionPoint<T, ?>> postConstructMethods;
    protected List<MethodInjectionPoint<T, ?>> preDestroyMethods;
    protected Map<MethodKey, ExecutableMethod<T, ?>> executableMethodMap;
    private final Class<T> type;
    private final boolean isAbstract;
    private final boolean isConfigurationProperties;
    private final Class<?> declaringType;
    private final ConstructorInjectionPoint<T> constructor;
    private final Collection<Class<?>> requiredComponents = new HashSet(3);
    private AnnotationMetadata beanAnnotationMetadata;
    private Environment environment;
    private Set<Class<?>> exposedTypes;
    private Argument<?> containerElement;

    @Internal
    protected AbstractBeanDefinition(Class<T> producedType, Class<?> declaringType, String fieldName, AnnotationMetadata fieldMetadata, boolean isFinal) {
        this.type = producedType;
        this.isAbstract = false;
        this.declaringType = declaringType;
        this.constructor = new DefaultFieldConstructorInjectionPoint<T>(this, declaringType, producedType, fieldName, fieldMetadata);
        this.isConfigurationProperties = this.hasStereotype(ConfigurationReader.class) || this.isIterable();
        this.initContainerElement();
    }

    @Internal
    protected AbstractBeanDefinition(Class<T> producedType, Class<?> declaringType, String methodName, AnnotationMetadata methodMetadata, boolean requiresReflection, Argument<?> ... arguments) {
        this.type = producedType;
        this.isAbstract = false;
        this.declaringType = declaringType;
        this.constructor = requiresReflection ? new ReflectionMethodConstructorInjectionPoint((BeanDefinition)this, declaringType, methodName, (Argument[])arguments, methodMetadata) : new DefaultMethodConstructorInjectionPoint(this, declaringType, methodName, arguments, methodMetadata);
        this.isConfigurationProperties = this.hasStereotype(ConfigurationReader.class) || this.isIterable();
        this.addRequiredComponents(arguments);
        this.initContainerElement();
    }

    @Internal
    protected AbstractBeanDefinition(Class<T> type, AnnotationMetadata constructorAnnotationMetadata, boolean requiresReflection, Argument ... arguments) {
        this.type = type;
        this.isAbstract = Modifier.isAbstract(this.type.getModifiers());
        this.declaringType = type;
        this.constructor = requiresReflection ? new ReflectionConstructorInjectionPoint<T>(this, type, constructorAnnotationMetadata, arguments) : new DefaultConstructorInjectionPoint<T>(this, type, constructorAnnotationMetadata, arguments);
        this.isConfigurationProperties = this.hasStereotype(ConfigurationReader.class) || this.isIterable();
        this.addRequiredComponents(arguments);
        this.initContainerElement();
    }

    private void initContainerElement() {
        List iterableArguments;
        if (this.isContainerType() && !(iterableArguments = this.getTypeArguments(Iterable.class)).isEmpty()) {
            this.containerElement = (Argument)iterableArguments.iterator().next();
        }
    }

    @Override
    public Optional<Argument<?>> getContainerElement() {
        return Optional.ofNullable(this.containerElement);
    }

    @Override
    public final boolean hasPropertyExpressions() {
        return this.getAnnotationMetadata().hasPropertyExpressions();
    }

    @Override
    @NonNull
    public List<Argument<?>> getTypeArguments(String type) {
        if (type == null) {
            return Collections.emptyList();
        }
        Map<String, Argument<?>[]> typeArguments = this.getTypeArgumentsMap();
        Argument<?>[] arguments = typeArguments.get(type);
        if (arguments != null) {
            return Arrays.asList(arguments);
        }
        return Collections.emptyList();
    }

    @NonNull
    public AnnotationMetadata getAnnotationMetadata() {
        if (this.beanAnnotationMetadata == null) {
            this.beanAnnotationMetadata = this.initializeAnnotationMetadata();
        }
        return this.beanAnnotationMetadata;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isIterable() {
        return this.hasDeclaredStereotype(EachProperty.class) || this.hasDeclaredStereotype(EachBean.class);
    }

    @Override
    public boolean isPrimary() {
        return this.hasDeclaredStereotype(Primary.class);
    }

    @Override
    public <R> Optional<ExecutableMethod<T, R>> findMethod(String name, Class<?> ... argumentTypes) {
        MethodKey methodKey;
        ExecutableMethod<T, ?> invocableMethod;
        if (this.executableMethodMap != null && (invocableMethod = this.executableMethodMap.get(methodKey = new MethodKey(name, argumentTypes))) != null) {
            return Optional.of(invocableMethod);
        }
        return Optional.empty();
    }

    @Override
    public Stream<ExecutableMethod<T, ?>> findPossibleMethods(String name) {
        if (this.executableMethodMap != null && this.executableMethodMap.keySet().stream().anyMatch(methodKey -> methodKey.name.equals(name))) {
            return this.executableMethodMap.values().stream().filter(method -> method.getMethodName().equals(name));
        }
        return Stream.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        return "Definition: " + this.declaringType.getName();
    }

    @Override
    public boolean isProvided() {
        return this.getAnnotationMetadata().hasDeclaredStereotype(Provided.class);
    }

    @Override
    public Optional<Class<? extends Annotation>> getScope() {
        return this.getAnnotationMetadata().getAnnotationTypeByStereotype("javax.inject.Scope");
    }

    @Override
    public Optional<String> getScopeName() {
        return this.getAnnotationMetadata().getAnnotationNameByStereotype("javax.inject.Scope");
    }

    @Override
    public final Class<T> getBeanType() {
        return this.type;
    }

    @Override
    @NonNull
    public final Set<Class<?>> getExposedTypes() {
        if (this.exposedTypes == null) {
            this.exposedTypes = BeanDefinition.super.getExposedTypes();
        }
        return this.exposedTypes;
    }

    @Override
    public final Optional<Class<?>> getDeclaringType() {
        return Optional.ofNullable(this.declaringType);
    }

    @Override
    public final ConstructorInjectionPoint<T> getConstructor() {
        return this.constructor;
    }

    @Override
    public Collection<Class<?>> getRequiredComponents() {
        return Collections.unmodifiableCollection(this.requiredComponents);
    }

    @Override
    public final Collection<MethodInjectionPoint<T, ?>> getInjectedMethods() {
        return Collections.unmodifiableCollection(this.methodInjectionPoints);
    }

    @Override
    public final Collection<FieldInjectionPoint<T, ?>> getInjectedFields() {
        return Collections.unmodifiableCollection(this.fieldInjectionPoints);
    }

    @Override
    public final Collection<MethodInjectionPoint<T, ?>> getPostConstructMethods() {
        if (this.postConstructMethods != null) {
            return Collections.unmodifiableCollection(this.postConstructMethods);
        }
        return Collections.emptyList();
    }

    @Override
    public final Collection<MethodInjectionPoint<T, ?>> getPreDestroyMethods() {
        if (this.preDestroyMethods != null) {
            return Collections.unmodifiableCollection(this.preDestroyMethods);
        }
        return Collections.emptyList();
    }

    @Override
    @NonNull
    public String getName() {
        return this.getBeanType().getName();
    }

    @Override
    public T inject(BeanContext context, T bean) {
        return (T)this.injectBean(new DefaultBeanResolutionContext(context, this), context, bean);
    }

    @Override
    public T inject(BeanResolutionContext resolutionContext, BeanContext context, T bean) {
        return (T)this.injectBean(resolutionContext, context, bean);
    }

    @Override
    public Collection<ExecutableMethod<T, ?>> getExecutableMethods() {
        if (this.executableMethodMap != null) {
            return Collections.unmodifiableCollection(this.executableMethodMap.values());
        }
        return Collections.emptyList();
    }

    @Override
    @Internal
    public final void configure(Environment environment) {
        if (environment != null) {
            this.environment = environment;
            if (this.constructor instanceof EnvironmentConfigurable) {
                ((EnvironmentConfigurable)((Object)this.constructor)).configure(environment);
            }
            for (MethodInjectionPoint<T, ?> methodInjectionPoint : this.methodInjectionPoints) {
                if (!(methodInjectionPoint instanceof EnvironmentConfigurable)) continue;
                ((EnvironmentConfigurable)((Object)methodInjectionPoint)).configure(environment);
            }
            if (this.executableMethodMap != null) {
                for (ExecutableMethod executableMethod : this.executableMethodMap.values()) {
                    if (!(executableMethod instanceof EnvironmentConfigurable)) continue;
                    ((EnvironmentConfigurable)((Object)executableMethod)).configure(environment);
                }
            }
        }
    }

    @Internal
    protected final void warn(String message) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(message);
        }
    }

    @Internal
    protected final void warnMissingProperty(Class type, String method, String property) {
        if (LOG.isWarnEnabled()) {
            LOG.warn("Configuration property [{}] could not be set as the underlying method [{}] does not exist on builder [{}]. This usually indicates the configuration option was deprecated and has been removed by the builder implementation (potentially a third-party library).", new Object[]{property, method, type});
        }
    }

    @Internal
    protected final Object getProxiedBean(BeanContext beanContext) {
        DefaultBeanContext defaultBeanContext = (DefaultBeanContext)beanContext;
        Optional qualifier = this.getAnnotationMetadata().getAnnotationNameByStereotype("javax.inject.Qualifier");
        return defaultBeanContext.getProxyTargetBean(this.getBeanType(), (Qualifier)qualifier.map(q -> Qualifiers.byAnnotation(this.getAnnotationMetadata(), q)).orElse(null));
    }

    @Internal
    protected final AbstractBeanDefinition<T> addExecutableMethod(ExecutableMethod<T, ?> executableMethod) {
        MethodKey key = new MethodKey(executableMethod.getMethodName(), executableMethod.getArgumentTypes());
        if (this.executableMethodMap == null) {
            this.executableMethodMap = new LinkedHashMap(3);
        }
        this.executableMethodMap.put(key, executableMethod);
        return this;
    }

    @Internal
    protected final AbstractBeanDefinition addInjectionPoint(Class declaringType, Class fieldType, String field, @Nullable AnnotationMetadata annotationMetadata, @Nullable Argument[] typeArguments, boolean requiresReflection) {
        DefaultFieldInjectionPoint injectionPoint = requiresReflection ? new ReflectionFieldInjectionPoint(this, declaringType, fieldType, field, annotationMetadata, typeArguments) : new DefaultFieldInjectionPoint(this, declaringType, fieldType, field, annotationMetadata, typeArguments);
        if (annotationMetadata != null && annotationMetadata.hasDeclaredAnnotation("javax.inject.Inject")) {
            this.addRequiredComponents(injectionPoint.asArgument());
        }
        this.fieldInjectionPoints.add(injectionPoint);
        return this;
    }

    @Internal
    protected final AbstractBeanDefinition addInjectionPoint(Class declaringType, String method, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        return this.addInjectionPointInternal(declaringType, method, arguments, annotationMetadata, requiresReflection, this.methodInjectionPoints);
    }

    @Internal
    protected final AbstractBeanDefinition addPostConstruct(Class declaringType, String method, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        if (this.postConstructMethods == null) {
            this.postConstructMethods = new ArrayList(1);
        }
        return this.addInjectionPointInternal(declaringType, method, arguments, annotationMetadata, requiresReflection, this.postConstructMethods);
    }

    @Internal
    protected final AbstractBeanDefinition addPreDestroy(Class declaringType, String method, Argument[] arguments, AnnotationMetadata annotationMetadata, boolean requiresReflection) {
        if (this.preDestroyMethods == null) {
            this.preDestroyMethods = new ArrayList(1);
        }
        return this.addInjectionPointInternal(declaringType, method, arguments, annotationMetadata, requiresReflection, this.preDestroyMethods);
    }

    @Internal
    protected Object injectBean(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        return bean;
    }

    @Internal
    protected Object injectAnother(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        if (bean == null) {
            throw new BeanInstantiationException(resolutionContext, "Bean factory returned null");
        }
        DefaultBeanContext defaultContext = (DefaultBeanContext)context;
        return defaultContext.inject(resolutionContext, this, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    protected Object postConstruct(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        Set<Map.Entry<Class, List<BeanInitializedEventListener>>> beanInitializedEventListeners;
        boolean addInCreationHandling = this.isSingleton() && !CollectionUtils.isNotEmpty(this.postConstructMethods);
        DefaultBeanContext.BeanKey key = null;
        if (addInCreationHandling) {
            key = new DefaultBeanContext.BeanKey(this, resolutionContext.getCurrentQualifier());
            resolutionContext.addInFlightBean(key, bean);
        }
        if (CollectionUtils.isNotEmpty(beanInitializedEventListeners = ((DefaultBeanContext)context).beanInitializedEventListeners)) {
            for (Map.Entry<Class, List<BeanInitializedEventListener>> entry : beanInitializedEventListeners) {
                if (!entry.getKey().isAssignableFrom(this.getBeanType())) continue;
                for (BeanInitializedEventListener listener : entry.getValue()) {
                    bean = listener.onInitialized(new BeanInitializingEvent<Object>(context, this, bean));
                    if (bean != null) continue;
                    throw new BeanInstantiationException(resolutionContext, "Listener [" + listener + "] returned null from onInitialized event");
                }
            }
        }
        DefaultBeanContext defaultContext = (DefaultBeanContext)context;
        for (int i = 0; i < this.methodInjectionPoints.size(); ++i) {
            MethodInjectionPoint<T, ?> methodInjectionPoint = this.methodInjectionPoints.get(i);
            if (!methodInjectionPoint.isPostConstructMethod() || !methodInjectionPoint.requiresReflection()) continue;
            this.injectBeanMethod(resolutionContext, defaultContext, i, bean);
        }
        if (bean instanceof LifeCycle) {
            bean = ((LifeCycle)bean).start();
        }
        try {
            Object object = bean;
            return object;
        }
        finally {
            if (addInCreationHandling) {
                resolutionContext.removeInFlightBean(key);
            }
        }
    }

    protected Object preDestroy(BeanResolutionContext resolutionContext, BeanContext context, Object bean) {
        DefaultBeanContext defaultContext = (DefaultBeanContext)context;
        for (int i = 0; i < this.methodInjectionPoints.size(); ++i) {
            MethodInjectionPoint<T, ?> methodInjectionPoint = this.methodInjectionPoints.get(i);
            if (!methodInjectionPoint.isPreDestroyMethod() || !methodInjectionPoint.requiresReflection()) continue;
            this.injectBeanMethod(resolutionContext, defaultContext, i, bean);
        }
        if (bean instanceof LifeCycle) {
            bean = ((LifeCycle)bean).stop();
        }
        return bean;
    }

    @Internal
    protected void injectBeanMethod(BeanResolutionContext resolutionContext, DefaultBeanContext context, int methodIndex, Object bean) {
        MethodInjectionPoint<T, ?> methodInjectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?>[] methodArgumentTypes = methodInjectionPoint.getArguments();
        Object[] methodArgs = new Object[methodArgumentTypes.length];
        for (int i = 0; i < methodArgumentTypes.length; ++i) {
            methodArgs[i] = this.getBeanForMethodArgument(resolutionContext, (BeanContext)context, methodIndex, i);
        }
        try {
            methodInjectionPoint.invoke(bean, methodArgs);
        }
        catch (Throwable e) {
            throw new BeanInstantiationException(this, e);
        }
    }

    @Internal
    protected final void injectBeanField(BeanResolutionContext resolutionContext, DefaultBeanContext context, int index, Object bean) {
        FieldInjectionPoint<T, ?> fieldInjectionPoint = this.fieldInjectionPoints.get(index);
        boolean isInject = fieldInjectionPoint.getAnnotationMetadata().hasDeclaredAnnotation("javax.inject.Inject");
        try {
            Object value;
            if (isInject) {
                this.instrumentAnnotationMetadata(context, fieldInjectionPoint);
                value = this.getBeanForField(resolutionContext, (BeanContext)context, fieldInjectionPoint);
            } else {
                value = this.getValueForField(resolutionContext, context, index);
            }
            if (value != null) {
                fieldInjectionPoint.set(bean, value);
            }
        }
        catch (Throwable e) {
            if (e instanceof BeanContextException) {
                throw (BeanContextException)e;
            }
            throw new DependencyInjectionException(resolutionContext, fieldInjectionPoint, "Error setting field value: " + e.getMessage(), e);
        }
    }

    @Internal
    protected final Object getValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        MethodInjectionPoint<T, ?> injectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument argument = injectionPoint.getArguments()[argIndex];
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, injectionPoint, argument);
        if (context instanceof ApplicationContext) {
            try {
                Argument argumentType;
                String valueAnnStr = argument.getAnnotationMetadata().stringValue(Value.class).orElse(null);
                boolean isCollection = false;
                if (Collection.class.isAssignableFrom(argument.getType())) {
                    argumentType = argument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                    isCollection = true;
                } else {
                    argumentType = argument;
                }
                if (this.isInnerConfiguration(argumentType, context)) {
                    Qualifier qualifier = this.resolveQualifier(resolutionContext, argument, true);
                    if (isCollection) {
                        Collection beans = ((DefaultBeanContext)context).getBeansOfType(resolutionContext, argumentType, qualifier);
                        Object object = this.coerceCollectionToCorrectType(argument.getType(), beans);
                        return object;
                    }
                    Object beans = ((DefaultBeanContext)context).getBean(resolutionContext, argumentType, qualifier);
                    return beans;
                }
                String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint.getAnnotationMetadata(), argument, valueAnnStr);
                ApplicationContext applicationContext = (ApplicationContext)context;
                ArgumentConversionContext conversionContext = ConversionContext.of((Argument)argument);
                Optional value = this.resolveValue(applicationContext, conversionContext, valueAnnStr != null, valString);
                if (argumentType.isOptional()) {
                    Object object = this.resolveOptionalObject(value);
                    return object;
                }
                if (value.isPresent()) {
                    Object t = value.get();
                    return t;
                }
                if (argument.isDeclaredNullable()) {
                    Object var15_21 = null;
                    return var15_21;
                }
                throw new DependencyInjectionException(resolutionContext, injectionPoint, conversionContext, valString);
            }
            finally {
                path.pop();
            }
        }
        path.pop();
        throw new DependencyInjectionException(resolutionContext, argument, "BeanContext must support property resolution");
    }

    @Internal
    protected final boolean containsValueForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        if (context instanceof ApplicationContext) {
            String cliOption;
            boolean result;
            MethodInjectionPoint<T, ?> injectionPoint = this.methodInjectionPoints.get(methodIndex);
            Argument<?> argument = injectionPoint.getArguments()[argIndex];
            String valueAnnStr = argument.getAnnotationMetadata().stringValue(Value.class).orElse(null);
            String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint.getAnnotationMetadata(), argument, valueAnnStr);
            ApplicationContext applicationContext = (ApplicationContext)context;
            Class type = argument.getType();
            boolean isConfigProps = type.isAnnotationPresent(ConfigurationProperties.class);
            boolean bl = result = isConfigProps || Map.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) ? applicationContext.containsProperties(valString) : applicationContext.containsProperty(valString);
            if (!result && this.isConfigurationProperties() && (cliOption = this.resolveCliOption(argument.getName())) != null) {
                result = applicationContext.containsProperty(cliOption);
            }
            if (result && injectionPoint instanceof MissingMethodInjectionPoint) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Bean definition for type [{}] is compiled against an older version and value [{}] can no longer be set for missing method: {}", new Object[]{this.getBeanType(), valString, injectionPoint.getName()});
                }
                result = false;
            }
            return result;
        }
        return false;
    }

    @Internal
    protected final Object getBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        MethodInjectionPoint<T, ?> injectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?> argument = this.resolveArgument(context, argIndex, injectionPoint.getArguments());
        return this.getBeanForMethodArgument(resolutionContext, context, injectionPoint, argument);
    }

    @Internal
    protected final Collection getBeansOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> {
            boolean hasNoGenerics;
            boolean bl = hasNoGenerics = !argument.getType().isArray() && argument.getTypeVariables().isEmpty();
            if (hasNoGenerics) {
                return (Collection)((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            }
            return ((DefaultBeanContext)context).getBeansOfType(resolutionContext, beanType, qualifier);
        });
    }

    @Internal
    protected final Optional findBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).findBean(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Stream streamOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromMethodArgument(resolutionContext, injectionPoint, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).streamOfType(resolutionContext, beanType, qualifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    protected final Object getBeanForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex) {
        ConstructorInjectionPoint<T> constructorInjectionPoint = this.getConstructor();
        Argument<?> argument = this.getArgument(context, constructorInjectionPoint.getArguments(), argIndex);
        Class beanType = argument.getType();
        if (beanType == BeanResolutionContext.class) {
            return resolutionContext;
        }
        if (argument.isArray()) {
            Collection beansOfType = this.getBeansOfTypeForConstructorArgument(resolutionContext, context, constructorInjectionPoint, argument);
            return beansOfType.toArray((Object[])Array.newInstance(beanType.getComponentType(), beansOfType.size()));
        }
        if (Collection.class.isAssignableFrom(beanType)) {
            Collection beansOfType = this.getBeansOfTypeForConstructorArgument(resolutionContext, context, constructorInjectionPoint, argument);
            return this.coerceCollectionToCorrectType(beanType, beansOfType);
        }
        if (Stream.class.isAssignableFrom(beanType)) {
            return this.streamOfTypeForConstructorArgument(resolutionContext, context, constructorInjectionPoint, argument);
        }
        if (argument.isOptional()) {
            return this.findBeanForConstructorArgument(resolutionContext, context, constructorInjectionPoint, argument);
        }
        BeanResolutionContext.Path path = resolutionContext.getPath();
        BeanResolutionContext.Segment current = (BeanResolutionContext.Segment)path.peek();
        boolean isNullable = argument.isDeclaredNullable();
        if (isNullable && current != null && current.getArgument().equals(argument)) {
            return null;
        }
        path.pushConstructorResolve(this, argument);
        try {
            Qualifier<Object> bean;
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument, this.isInnerConfiguration(argument, context));
            if (Qualifier.class.isAssignableFrom(beanType)) {
                bean = qualifier;
            } else {
                Object previous = !argument.isAnnotationPresent(Parameter.class) ? resolutionContext.removeAttribute(NAMED_ATTRIBUTE) : null;
                try {
                    bean = ((DefaultBeanContext)context).getBean(resolutionContext, argument, qualifier);
                }
                finally {
                    if (previous != null) {
                        resolutionContext.setAttribute(NAMED_ATTRIBUTE, previous);
                    }
                }
            }
            path.pop();
            return bean;
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)argument.getTypeName(), (Object)e.getMessage());
            }
            if (this.isIterable() && this.getAnnotationMetadata().hasDeclaredAnnotation(EachBean.class)) {
                throw new DisabledBeanException("Bean [" + this.getBeanType().getSimpleName() + "] disabled by parent: " + e.getMessage());
            }
            if (isNullable) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
        catch (NoSuchBeanException e) {
            if (isNullable) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    private Argument<?> getArgument(BeanContext context, Argument[] arguments, int argIndex) {
        Argument<?> argument = this.resolveArgument(context, argIndex, arguments);
        return argument;
    }

    @Internal
    protected final Object getValueForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex) {
        ConstructorInjectionPoint<T> constructorInjectionPoint = this.getConstructor();
        BeanResolutionContext.Path path = resolutionContext.getPath();
        Argument<?> argument = constructorInjectionPoint.getArguments()[argIndex];
        path.pushConstructorResolve(this, argument);
        try {
            Object result;
            if (context instanceof ApplicationContext) {
                ApplicationContext propertyResolver = (ApplicationContext)context;
                AnnotationMetadata argMetadata = argument.getAnnotationMetadata();
                Optional valAnn = argMetadata.stringValue(Value.class);
                String prop = this.resolvePropertyValueName(resolutionContext, argMetadata, argument, valAnn.orElse(null));
                ArgumentConversionContext conversionContext = ConversionContext.of(argument);
                Optional value = this.resolveValue(propertyResolver, conversionContext, valAnn.isPresent(), prop);
                if (argument.getType() == Optional.class) {
                    Object object = this.resolveOptionalObject(value);
                    return object;
                }
                result = value.isPresent() ? value.get() : (argument.isDeclaredNullable() ? null : argMetadata.getValue(Bindable.class, "defaultValue", argument).orElseThrow(() -> new DependencyInjectionException(resolutionContext, conversionContext, prop)));
            } else {
                throw new DependencyInjectionException(resolutionContext, argument, "BeanContext must support property resolution");
            }
            if (this instanceof ValidatedBeanDefinition) {
                ((ValidatedBeanDefinition)((Object)this)).validateBeanArgument(resolutionContext, constructorInjectionPoint, argument, argIndex, result);
            }
            Object t = result;
            return t;
        }
        catch (BeanInstantiationException | NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
        finally {
            path.pop();
        }
    }

    @Internal
    protected final Collection getBeansOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint<T> constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> {
            boolean hasNoGenerics;
            boolean bl = hasNoGenerics = !argument.getType().isArray() && argument.getTypeVariables().isEmpty();
            if (hasNoGenerics) {
                return (Collection)((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            }
            return ((DefaultBeanContext)context).getBeansOfType(resolutionContext, beanType, qualifier);
        });
    }

    @Internal
    protected final Object getBeansOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argumentIndex) {
        ConstructorInjectionPoint<T> constructorInjectionPoint = this.getConstructor();
        Argument<?> argument = this.getArgument(context, constructorInjectionPoint.getArguments(), argumentIndex);
        Class argumentType = argument.getType();
        Argument<?> genericType = this.resolveGenericType(argument, () -> new DependencyInjectionException(resolutionContext, argument, "Type " + argumentType + " has no generic argument"));
        Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushConstructorResolve(this, argument);
        return this.doGetBeansOfType(resolutionContext, (DefaultBeanContext)context, argumentType, genericType, qualifier, path);
    }

    @Internal
    protected final Object getBeansOfTypeForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argumentIndex) {
        MethodInjectionPoint methodInjectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?> argument = this.getArgument(context, methodInjectionPoint.getArguments(), argumentIndex);
        Class argumentType = argument.getType();
        Argument<?> genericType = this.resolveGenericType(argument, () -> new DependencyInjectionException(resolutionContext, methodInjectionPoint, argument, "Type " + argumentType + " has no generic argument"));
        Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, methodInjectionPoint, argument);
        return this.doGetBeansOfType(resolutionContext, (DefaultBeanContext)context, argumentType, genericType, qualifier, path);
    }

    @Internal
    protected final Object getBeansOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint fieldInjectionPoint = this.fieldInjectionPoints.get(fieldIndex);
        Argument argument = fieldInjectionPoint.asArgument();
        Class argumentType = argument.getType();
        Argument<?> genericType = this.resolveGenericType(argument, () -> new DependencyInjectionException(resolutionContext, fieldInjectionPoint, "Type " + argumentType + " has no generic argument"));
        Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, fieldInjectionPoint);
        return this.doGetBeansOfType(resolutionContext, (DefaultBeanContext)context, argumentType, genericType, qualifier, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doGetBeansOfType(BeanResolutionContext resolutionContext, DefaultBeanContext context, Class<?> argumentType, Argument<?> genericType, Qualifier qualifier, BeanResolutionContext.Path path) {
        try {
            Collection<?> beansOfType = context.getBeansOfType(resolutionContext, genericType, qualifier);
            if (argumentType.isArray()) {
                Object[] objectArray = beansOfType.toArray((Object[])Array.newInstance(genericType.getType(), beansOfType.size()));
                return objectArray;
            }
            Object object = this.coerceCollectionToCorrectType(argumentType, beansOfType);
            return object;
        }
        finally {
            path.pop();
        }
    }

    private Argument<?> resolveGenericType(Argument<?> argument, Supplier<DependencyInjectionException> exceptionSupplier) {
        Argument genericType = argument.isArray() ? Argument.of(argument.getType().getComponentType()) : (Argument)argument.getFirstTypeVariable().orElseThrow(exceptionSupplier);
        return genericType;
    }

    @Internal
    protected final Object getBeanRegistrationsForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argumentIndex) {
        Argument<?> argument = this.getArgument(context, this.getConstructor().getArguments(), argumentIndex);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushConstructorResolve(this, argument);
        return this.doResolveBeanRegistrations(resolutionContext, (DefaultBeanContext)context, argument, path);
    }

    @Internal
    protected final BeanRegistration<?> getBeanRegistrationForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, int argIndex) {
        Argument<?> argument = this.getArgument(context, this.getConstructor().getArguments(), argIndex);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushConstructorResolve(this, argument);
        return this.resolveBeanRegistrationWithGenericsFromArgument(resolutionContext, argument, path, (beanType, qualifier) -> ((DefaultBeanContext)context).getBeanRegistration(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Object getBeanRegistrationsForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint<T, ?> field = this.fieldInjectionPoints.get(fieldIndex);
        this.instrumentAnnotationMetadata(context, field);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, field);
        return this.doResolveBeanRegistrations(resolutionContext, (DefaultBeanContext)context, field.asArgument(), path);
    }

    @Internal
    protected final BeanRegistration<?> getBeanRegistrationForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint<T, ?> field = this.fieldInjectionPoints.get(fieldIndex);
        this.instrumentAnnotationMetadata(context, field);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, field);
        return this.resolveBeanRegistrationWithGenericsFromArgument(resolutionContext, field.asArgument(), path, (beanType, qualifier) -> ((DefaultBeanContext)context).getBeanRegistration(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Object getBeanRegistrationsForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        MethodInjectionPoint<T, ?> methodInjectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?> argument = this.resolveArgument(context, argIndex, methodInjectionPoint.getArguments());
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, methodInjectionPoint, argument);
        return this.doResolveBeanRegistrations(resolutionContext, (DefaultBeanContext)context, argument, path);
    }

    @Internal
    protected final BeanRegistration<?> getBeanRegistrationForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, int methodIndex, int argIndex) {
        MethodInjectionPoint<T, ?> methodInjectionPoint = this.methodInjectionPoints.get(methodIndex);
        Argument<?> argument = this.resolveArgument(context, argIndex, methodInjectionPoint.getArguments());
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, methodInjectionPoint, argument);
        return this.resolveBeanRegistrationWithGenericsFromArgument(resolutionContext, argument, path, (beanType, qualifier) -> ((DefaultBeanContext)context).getBeanRegistration(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Stream streamOfTypeForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint<T> constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).streamOfType(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Optional findBeanForConstructorArgument(BeanResolutionContext resolutionContext, BeanContext context, ConstructorInjectionPoint<T> constructorInjectionPoint, Argument argument) {
        return this.resolveBeanWithGenericsFromConstructorArgument(resolutionContext, argument, (beanType, qualifier) -> ((DefaultBeanContext)context).findBean(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Object getBeanForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint<T, ?> injectionPoint = this.fieldInjectionPoints.get(fieldIndex);
        this.instrumentAnnotationMetadata(context, injectionPoint);
        return this.getBeanForField(resolutionContext, context, injectionPoint);
    }

    @Internal
    protected final Object getValueForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        FieldInjectionPoint<T, ?> injectionPoint = this.fieldInjectionPoints.get(fieldIndex);
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, injectionPoint);
        try {
            if (context instanceof PropertyResolver) {
                Argument argumentType;
                AnnotationMetadata annotationMetadata = injectionPoint.getAnnotationMetadata();
                String valueAnnVal = annotationMetadata.stringValue(Value.class).orElse(null);
                Argument fieldArgument = injectionPoint.asArgument();
                boolean isCollection = false;
                if (Collection.class.isAssignableFrom(injectionPoint.getType())) {
                    argumentType = fieldArgument.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
                    isCollection = true;
                } else {
                    argumentType = fieldArgument;
                }
                if (this.isInnerConfiguration(argumentType, context)) {
                    Qualifier qualifier = this.resolveQualifier(resolutionContext, fieldArgument, true);
                    if (isCollection) {
                        Collection beans = ((DefaultBeanContext)context).getBeansOfType(resolutionContext, argumentType, qualifier);
                        Object object = this.coerceCollectionToCorrectType(fieldArgument.getType(), beans);
                        return object;
                    }
                    Object beans = ((DefaultBeanContext)context).getBean(resolutionContext, argumentType, qualifier);
                    return beans;
                }
                String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint, valueAnnVal, annotationMetadata);
                ArgumentConversionContext conversionContext = ConversionContext.of((Argument)fieldArgument);
                Optional value = this.resolveValue((ApplicationContext)context, conversionContext, valueAnnVal != null, valString);
                if (argumentType.isOptional()) {
                    Object object = this.resolveOptionalObject(value);
                    return object;
                }
                if (value.isPresent()) {
                    Object t = value.get();
                    return t;
                }
                if (fieldArgument.isDeclaredNullable()) {
                    Object var14_20 = null;
                    return var14_20;
                }
                throw new DependencyInjectionException(resolutionContext, injectionPoint, "Error resolving field value [" + valString + "]. Property doesn't exist or cannot be converted");
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, "@Value requires a BeanContext that implements PropertyResolver");
        }
        finally {
            path.pop();
        }
    }

    @Internal
    protected final <T1> Optional<T1> getValueForPath(BeanResolutionContext resolutionContext, BeanContext context, Argument<T1> propertyType, String ... propertyPath) {
        if (context instanceof PropertyResolver) {
            PropertyResolver propertyResolver = (PropertyResolver)context;
            String pathString = propertyPath.length > 1 ? String.join((CharSequence)".", propertyPath) : propertyPath[0];
            String valString = this.resolvePropertyPath(resolutionContext, pathString);
            return propertyResolver.getProperty(valString, ConversionContext.of(propertyType));
        }
        return Optional.empty();
    }

    @Internal
    protected final <T1> Optional<T1> getValueForPath(BeanResolutionContext resolutionContext, BeanContext context, Argument<T1> propertyType, String propertyPath) {
        if (context instanceof PropertyResolver) {
            PropertyResolver propertyResolver = (PropertyResolver)context;
            String valString = this.substituteWildCards(resolutionContext, propertyPath);
            return propertyResolver.getProperty(valString, ConversionContext.of(propertyType));
        }
        return Optional.empty();
    }

    @Internal
    protected final boolean containsValueForField(BeanResolutionContext resolutionContext, BeanContext context, int fieldIndex) {
        if (context instanceof ApplicationContext) {
            String cliOption;
            boolean result;
            FieldInjectionPoint<T, ?> injectionPoint = this.fieldInjectionPoints.get(fieldIndex);
            AnnotationMetadata annotationMetadata = injectionPoint.getAnnotationMetadata();
            String valueAnnVal = annotationMetadata.stringValue(Value.class).orElse(null);
            String valString = this.resolvePropertyValueName(resolutionContext, injectionPoint, valueAnnVal, annotationMetadata);
            ApplicationContext applicationContext = (ApplicationContext)context;
            Class<?> fieldType = injectionPoint.getType();
            boolean isConfigProps = fieldType.isAnnotationPresent(ConfigurationProperties.class);
            boolean bl = result = isConfigProps || Map.class.isAssignableFrom(fieldType) || Collection.class.isAssignableFrom(fieldType) ? applicationContext.containsProperties(valString) : applicationContext.containsProperty(valString);
            if (!result && this.isConfigurationProperties() && (cliOption = this.resolveCliOption(injectionPoint.getName())) != null) {
                return applicationContext.containsProperty(cliOption);
            }
            return result;
        }
        return false;
    }

    @Internal
    protected final boolean containsProperties(BeanResolutionContext resolutionContext, BeanContext context) {
        return this.containsProperties(resolutionContext, context, null);
    }

    @Internal
    protected final boolean containsProperties(BeanResolutionContext resolutionContext, BeanContext context, String subProperty) {
        boolean isSubProperty = StringUtils.isNotEmpty((CharSequence)subProperty);
        if (!isSubProperty && !this.requiredComponents.isEmpty()) {
            return true;
        }
        if (this.isConfigurationProperties && context instanceof ApplicationContext) {
            AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
            ApplicationContext appCtx = (ApplicationContext)context;
            if (annotationMetadata.getValue(ConfigurationProperties.class, "cliPrefix").isPresent()) {
                return true;
            }
            String path = this.getConfigurationPropertiesPath(resolutionContext);
            return appCtx.containsProperties(path);
        }
        return false;
    }

    @Internal
    protected final Object getBeanForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        Class beanClass = injectionPoint.getType();
        if (beanClass.isArray()) {
            Collection beansOfType = this.getBeansOfTypeForField(resolutionContext, context, injectionPoint);
            return beansOfType.toArray((Object[])Array.newInstance(beanClass.getComponentType(), beansOfType.size()));
        }
        if (Collection.class.isAssignableFrom(beanClass)) {
            Collection beansOfType = this.getBeansOfTypeForField(resolutionContext, context, injectionPoint);
            if (beanClass.isInstance(beansOfType)) {
                return beansOfType;
            }
            return CollectionUtils.convertCollection(beanClass, (Collection)beansOfType).orElse(null);
        }
        if (Stream.class.isAssignableFrom(beanClass)) {
            return this.getStreamOfTypeForField(resolutionContext, context, injectionPoint);
        }
        if (Optional.class.isAssignableFrom(beanClass)) {
            return this.findBeanForField(resolutionContext, context, injectionPoint);
        }
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, injectionPoint);
        Argument argument = injectionPoint.asArgument();
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            Object bean = ((DefaultBeanContext)context).getBean(resolutionContext, argument, qualifier);
            path.pop();
            return bean;
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)argument.getTypeName(), (Object)e.getMessage());
            }
            if (this.isIterable() && this.getAnnotationMetadata().hasDeclaredAnnotation(EachBean.class)) {
                throw new DisabledBeanException("Bean [" + this.getBeanType().getSimpleName() + "] disabled by parent: " + e.getMessage());
            }
            if (injectionPoint.isDeclaredNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, (Throwable)e);
        }
        catch (NoSuchBeanException e) {
            if (injectionPoint.isDeclaredNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, (Throwable)e);
        }
    }

    @Internal
    protected final Optional findBeanForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> ((DefaultBeanContext)context).findBean(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected final Collection getBeansOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> {
            boolean hasNoGenerics;
            boolean bl = hasNoGenerics = !injectionPoint.getType().isArray() && injectionPoint.asArgument().getTypeVariables().isEmpty();
            if (hasNoGenerics) {
                return (Collection)((DefaultBeanContext)context).getBean(resolutionContext, beanType, qualifier);
            }
            return ((DefaultBeanContext)context).getBeansOfType(resolutionContext, beanType, qualifier);
        });
    }

    @Internal
    protected final Stream getStreamOfTypeForField(BeanResolutionContext resolutionContext, BeanContext context, FieldInjectionPoint injectionPoint) {
        return this.resolveBeanWithGenericsForField(resolutionContext, injectionPoint, (beanType, qualifier) -> ((DefaultBeanContext)context).streamOfType(resolutionContext, beanType, qualifier));
    }

    @Internal
    protected Map<String, Argument<?>[]> getTypeArgumentsMap() {
        return Collections.emptyMap();
    }

    protected AnnotationMetadata resolveAnnotationMetadata() {
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private AnnotationMetadata initializeAnnotationMetadata() {
        AnnotationMetadata annotationMetadata = this.resolveAnnotationMetadata();
        if (annotationMetadata != AnnotationMetadata.EMPTY_METADATA) {
            if (annotationMetadata.hasPropertyExpressions()) {
                return new BeanAnnotationMetadata(annotationMetadata);
            }
            return annotationMetadata;
        }
        return AnnotationMetadata.EMPTY_METADATA;
    }

    private AbstractBeanDefinition addInjectionPointInternal(Class declaringType, String method, @Nullable Argument[] arguments, @Nullable AnnotationMetadata annotationMetadata, boolean requiresReflection, List<MethodInjectionPoint<T, ?>> targetInjectionPoints) {
        boolean isPreDestroy = targetInjectionPoints == this.preDestroyMethods;
        boolean isPostConstruct = targetInjectionPoints == this.postConstructMethods;
        DefaultMethodInjectionPoint injectionPoint = requiresReflection ? new ReflectionMethodInjectionPoint((BeanDefinition)this, (Class<?>)declaringType, method, arguments, annotationMetadata) : new DefaultMethodInjectionPoint(this, declaringType, method, arguments, annotationMetadata);
        targetInjectionPoints.add(injectionPoint);
        if (isPostConstruct || isPreDestroy) {
            this.methodInjectionPoints.add(injectionPoint);
        }
        this.addRequiredComponents(arguments);
        return this;
    }

    private Object getBeanForMethodArgument(BeanResolutionContext resolutionContext, BeanContext context, MethodInjectionPoint injectionPoint, Argument argument) {
        Class argumentType = argument.getType();
        if (argumentType.isArray()) {
            Collection beansOfType = this.getBeansOfTypeForMethodArgument(resolutionContext, context, injectionPoint, argument);
            return beansOfType.toArray((Object[])Array.newInstance(argumentType.getComponentType(), beansOfType.size()));
        }
        if (Collection.class.isAssignableFrom(argumentType)) {
            Collection beansOfType = this.getBeansOfTypeForMethodArgument(resolutionContext, context, injectionPoint, argument);
            return this.coerceCollectionToCorrectType(argumentType, beansOfType);
        }
        if (Stream.class.isAssignableFrom(argumentType)) {
            return this.streamOfTypeForMethodArgument(resolutionContext, context, injectionPoint, argument);
        }
        if (Optional.class.isAssignableFrom(argumentType)) {
            return this.findBeanForMethodArgument(resolutionContext, context, injectionPoint, argument);
        }
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, injectionPoint, argument);
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            Object bean = ((DefaultBeanContext)context).getBean(resolutionContext, argument, qualifier);
            path.pop();
            return bean;
        }
        catch (DisabledBeanException e) {
            if (AbstractBeanContextConditional.LOG.isDebugEnabled()) {
                AbstractBeanContextConditional.LOG.debug("Bean of type [{}] disabled for reason: {}", (Object)argumentType.getSimpleName(), (Object)e.getMessage());
            }
            if (this.isIterable() && this.getAnnotationMetadata().hasDeclaredAnnotation(EachBean.class)) {
                throw new DisabledBeanException("Bean [" + this.getBeanType().getSimpleName() + "] disabled by parent: " + e.getMessage());
            }
            if (argument.isDeclaredNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
        catch (NoSuchBeanException e) {
            if (argument.isDeclaredNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    private Optional resolveValue(ApplicationContext context, ArgumentConversionContext<?> argument, boolean hasValueAnnotation, String valString) {
        String cliOption;
        if (hasValueAnnotation) {
            return context.resolvePlaceholders(valString).flatMap(v -> context.getConversionService().convert(v, argument));
        }
        Optional value = context.getProperty(valString, argument);
        if (!value.isPresent() && this.isConfigurationProperties() && (cliOption = this.resolveCliOption(argument.getArgument().getName())) != null) {
            return context.getProperty(cliOption, argument);
        }
        return value;
    }

    private String resolvePropertyValueName(BeanResolutionContext resolutionContext, AnnotationMetadata annotationMetadata, Argument argument, String valueAnnStr) {
        String valString;
        if (valueAnnStr != null) {
            valString = valueAnnStr;
        } else {
            valString = annotationMetadata.stringValue(Property.class, "name").orElseGet(() -> (String)argument.getAnnotationMetadata().stringValue(Property.class, "name").orElseThrow(() -> new DependencyInjectionException(resolutionContext, argument, "Value resolution attempted but @Value annotation is missing")));
            valString = this.substituteWildCards(resolutionContext, valString);
        }
        return valString;
    }

    private String resolvePropertyValueName(BeanResolutionContext resolutionContext, FieldInjectionPoint injectionPoint, String valueAnn, AnnotationMetadata annotationMetadata) {
        String valString;
        if (valueAnn != null) {
            valString = valueAnn;
        } else {
            valString = (String)annotationMetadata.stringValue(Property.class, "name").orElseThrow(() -> new DependencyInjectionException(resolutionContext, injectionPoint, "Value resolution attempted but @Value annotation is missing"));
            valString = this.substituteWildCards(resolutionContext, valString);
        }
        return valString;
    }

    private String resolvePropertyPath(BeanResolutionContext resolutionContext, String path) {
        String valString = this.getConfigurationPropertiesPath(resolutionContext);
        return valString + "." + path;
    }

    private String getConfigurationPropertiesPath(BeanResolutionContext resolutionContext) {
        String valString = (String)this.getAnnotationMetadata().stringValue(ConfigurationReader.class, "prefix").orElseThrow(() -> new IllegalStateException("Resolve property path called for non @ConfigurationProperties bean"));
        valString = this.substituteWildCards(resolutionContext, valString);
        return valString;
    }

    private String substituteWildCards(BeanResolutionContext resolutionContext, String valString) {
        Optional namedBean;
        if (valString.indexOf(42) > -1 && (namedBean = resolutionContext.get(Named.class.getName(), ConversionContext.STRING)).isPresent()) {
            valString = valString.replace("*", (CharSequence)namedBean.get());
        }
        return valString;
    }

    private String resolveCliOption(String name) {
        String attr = "cliPrefix";
        AnnotationMetadata annotationMetadata = this.getAnnotationMetadata();
        if (annotationMetadata.isPresent(ConfigurationProperties.class, attr)) {
            return annotationMetadata.stringValue(ConfigurationProperties.class, attr).map(val -> val + name).orElse(null);
        }
        return null;
    }

    private boolean isInnerConfiguration(Argument<?> argumentType, BeanContext beanContext) {
        Class type = argumentType.getType();
        return this.isConfigurationProperties && type.getName().indexOf(36) > -1 && !type.isEnum() && !type.isPrimitive() && Modifier.isPublic(type.getModifiers()) && Modifier.isStatic(type.getModifiers()) && this.isInnerOfAnySuperclass(type) && beanContext.findBeanDefinition(argumentType).map(bd -> bd.hasStereotype(ConfigurationReader.class) || bd.isIterable()).isPresent();
    }

    private boolean isInnerOfAnySuperclass(Class argumentType) {
        for (Class<T> beanType = this.getBeanType(); beanType != null; beanType = beanType.getSuperclass()) {
            if (!(beanType.getName() + "$" + argumentType.getSimpleName()).equals(argumentType.getName())) continue;
            return true;
        }
        return false;
    }

    private <B, X extends RuntimeException> B resolveBeanWithGenericsFromMethodArgument(BeanResolutionContext resolutionContext, MethodInjectionPoint injectionPoint, Argument argument, BeanResolver<B> beanResolver) throws X {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushMethodArgumentResolve(this, injectionPoint, argument);
        try {
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            Class argumentType = argument.getType();
            Argument genericType = this.resolveGenericType(argument, argumentType);
            B bean = beanResolver.resolveBean(genericType != null ? genericType : argument, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            throw new DependencyInjectionException(resolutionContext, injectionPoint, argument, (Throwable)e);
        }
    }

    private Argument resolveGenericType(Argument argument, Class argumentType) {
        if (!argument.isArray()) {
            return argument.getFirstTypeVariable().orElse(null);
        }
        Argument genericType = Argument.of(argumentType.getComponentType());
        return genericType;
    }

    private <B> B resolveBeanWithGenericsFromConstructorArgument(BeanResolutionContext resolutionContext, Argument argument, BeanResolver<B> beanResolver) {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushConstructorResolve(this, argument);
        try {
            Class argumentType = argument.getType();
            Argument genericType = this.resolveGenericType(argument, argumentType);
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            B bean = beanResolver.resolveBean(genericType != null ? genericType : argument, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            if (argument.isNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    private <B> Collection<BeanRegistration<B>> resolveBeanRegistrationsWithGenericsFromArgument(BeanResolutionContext resolutionContext, Argument<?> argument, BeanResolutionContext.Path path, BiFunction<Argument<B>, Qualifier<B>, Collection<BeanRegistration<B>>> beanResolver) {
        try {
            Supplier<DependencyInjectionException> errorSupplier = () -> new DependencyInjectionException(resolutionContext, argument, "Cannot resolve bean registrations. Argument [" + argument + "] missing generic type information.");
            Argument genericType = (Argument)argument.getFirstTypeVariable().orElseThrow(errorSupplier);
            Argument beanType = argument.isArray() ? genericType : (Argument)genericType.getFirstTypeVariable().orElseThrow(errorSupplier);
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            Collection<BeanRegistration<B>> result = beanResolver.apply(beanType, qualifier);
            path.pop();
            return result;
        }
        catch (NoSuchBeanException e) {
            if (argument.isNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    private Argument<?> resolveArgument(BeanContext context, int argIndex, Argument<?>[] arguments) {
        Object argument = arguments[argIndex];
        if (argument instanceof DefaultArgument && argument.getAnnotationMetadata().hasPropertyExpressions()) {
            argument = new EnvironmentAwareArgument((DefaultArgument)argument);
            this.instrumentAnnotationMetadata(context, argument);
        }
        return argument;
    }

    private <B> BeanRegistration<B> resolveBeanRegistrationWithGenericsFromArgument(BeanResolutionContext resolutionContext, Argument<?> argument, BeanResolutionContext.Path path, BiFunction<Argument<B>, Qualifier<B>, BeanRegistration<B>> beanResolver) {
        try {
            Supplier<DependencyInjectionException> errorSupplier = () -> new DependencyInjectionException(resolutionContext, argument, "Cannot resolve bean registration. Argument [" + argument + "] missing generic type information.");
            Argument genericType = (Argument)argument.getFirstTypeVariable().orElseThrow(errorSupplier);
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            BeanRegistration<B> result = beanResolver.apply(genericType, qualifier);
            path.pop();
            return result;
        }
        catch (NoSuchBeanException e) {
            if (argument.isNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, argument, (Throwable)e);
        }
    }

    private Object doResolveBeanRegistrations(BeanResolutionContext resolutionContext, DefaultBeanContext context, Argument<?> argument, BeanResolutionContext.Path path) {
        Collection beanRegistrations = this.resolveBeanRegistrationsWithGenericsFromArgument(resolutionContext, argument, path, (beanType, qualifier) -> context.getBeanRegistrations(resolutionContext, beanType, qualifier));
        if (CollectionUtils.isNotEmpty(beanRegistrations)) {
            if (argument.isArray()) {
                return beanRegistrations.toArray(new BeanRegistration[beanRegistrations.size()]);
            }
            return this.coerceCollectionToCorrectType(argument.getType(), beanRegistrations);
        }
        if (argument.isArray()) {
            return Array.newInstance(argument.getType(), 0);
        }
        return this.coerceCollectionToCorrectType(argument.getType(), Collections.emptySet());
    }

    private <B> B resolveBeanWithGenericsForField(BeanResolutionContext resolutionContext, FieldInjectionPoint injectionPoint, BeanResolver<B> beanResolver) {
        BeanResolutionContext.Path path = resolutionContext.getPath();
        path.pushFieldResolve(this, injectionPoint);
        Argument argument = injectionPoint.asArgument();
        try {
            Argument genericType = argument.isArray() ? Argument.of(argument.getType().getComponentType()) : argument.getFirstTypeVariable().orElse(argument);
            Qualifier qualifier = this.resolveQualifier(resolutionContext, argument);
            B bean = beanResolver.resolveBean(genericType, qualifier);
            path.pop();
            return bean;
        }
        catch (NoSuchBeanException e) {
            if (argument.isNullable()) {
                path.pop();
                return null;
            }
            throw new DependencyInjectionException(resolutionContext, injectionPoint, (Throwable)e);
        }
    }

    private boolean isConfigurationProperties() {
        return this.isConfigurationProperties;
    }

    private Qualifier resolveQualifier(BeanResolutionContext resolutionContext, Argument argument) {
        return this.resolveQualifier(resolutionContext, argument, false);
    }

    /*
     * Unable to fully structure code
     */
    private Qualifier resolveQualifier(BeanResolutionContext resolutionContext, Argument argument, boolean innerConfiguration) {
        argumentQualifier = Qualifiers.forArgument(argument);
        if (argumentQualifier != null) {
            return argumentQualifier;
        }
        annotationMetadata = argument.getAnnotationMetadata();
        v0 = hasMetadata = annotationMetadata != AnnotationMetadata.EMPTY_METADATA;
        if (hasMetadata && annotationMetadata.hasAnnotation("io.micronaut.inject.qualifiers.InterceptorBindingQualifier")) {
            return Qualifiers.byInterceptorBinding(annotationMetadata);
        }
        v1 = hasMetadata ? (annotationMetadata.hasDeclaredAnnotation(Type.class) ? annotationMetadata.classValues(Type.class) : null) : (byType = null);
        if (byType != null) {
            return Qualifiers.byType(byType);
        }
        qualifier = null;
        if (this.isIterable()) ** GOTO lbl-1000
        if (resolutionContext.get(EachProperty.class.getName(), Class.class).map((Function<Class, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, equals(java.lang.Object ), (Ljava/lang/Class;)Ljava/lang/Boolean;)(this.getBeanType())).orElse(false).booleanValue()) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = isIterable = false;
        }
        if (isIterable) {
            optional = resolutionContext.get("javax.inject.Qualifier", Map.class).map((Function<Map, Qualifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$resolveQualifier$29(io.micronaut.core.type.Argument java.util.Map ), (Ljava/util/Map;)Lio/micronaut/context/Qualifier;)((Argument)argument));
            qualifier = optional.orElse(null);
        }
        if (qualifier == null && (hasMetadata != false && argument.isAnnotationPresent(Parameter.class) != false || innerConfiguration != false && isIterable != false || Qualifier.class == argument.getType())) {
            currentQualifier = resolutionContext.getCurrentQualifier();
            if (currentQualifier != null && currentQualifier.getClass() != InterceptorBindingQualifier.class && currentQualifier.getClass() != TypeAnnotationQualifier.class) {
                qualifier = currentQualifier;
            } else {
                n = resolutionContext.get(AbstractBeanDefinition.NAMED_ATTRIBUTE, ConversionContext.STRING);
                qualifier = n.map((Function<String, Qualifier>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, byName(java.lang.String ), (Ljava/lang/String;)Lio/micronaut/context/Qualifier;)()).orElse(null);
            }
        }
        return qualifier;
    }

    private Object resolveOptionalObject(Optional value) {
        if (!value.isPresent()) {
            return value;
        }
        Object convertedOptional = value.get();
        if (convertedOptional instanceof Optional) {
            return convertedOptional;
        }
        return value;
    }

    private Object coerceCollectionToCorrectType(Class collectionType, Collection beansOfType) {
        if (collectionType.isInstance(beansOfType)) {
            return beansOfType;
        }
        return CollectionUtils.convertCollection((Class)collectionType, (Collection)beansOfType).orElse(null);
    }

    private void addRequiredComponents(Argument ... arguments) {
        block3: {
            if (arguments == null) break block3;
            for (Argument argument : arguments) {
                block5: {
                    block4: {
                        if (argument.isContainerType()) break block4;
                        if (!argument.isProvider()) break block5;
                    }
                    argument.getFirstTypeVariable().map(TypeInformation::getType).ifPresent(this.requiredComponents::add);
                    continue;
                }
                this.requiredComponents.add(argument.getType());
            }
        }
    }

    private void instrumentAnnotationMetadata(BeanContext context, Object object) {
        EnvironmentConfigurable ec;
        if (object instanceof EnvironmentConfigurable && context instanceof ApplicationContext && (ec = (EnvironmentConfigurable)object).hasPropertyExpressions()) {
            ec.configure(((ApplicationContext)context).getEnvironment());
        }
    }

    private static /* synthetic */ Qualifier lambda$resolveQualifier$29(Argument argument, Map map) {
        return (Qualifier)map.get(argument);
    }

    private static interface BeanResolver<T> {
        public T resolveBean(Argument<T> var1, Qualifier<T> var2);
    }

    private final class MethodKey {
        final String name;
        final Class[] argumentTypes;

        MethodKey(String name, Class[] argumentTypes) {
            this.name = name;
            this.argumentTypes = argumentTypes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            if (!this.name.equals(methodKey.name)) {
                return false;
            }
            return Arrays.equals(this.argumentTypes, methodKey.argumentTypes);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.argumentTypes);
            return result;
        }
    }

    private final class BeanAnnotationMetadata
    extends AbstractEnvironmentAnnotationMetadata {
        BeanAnnotationMetadata(AnnotationMetadata targetMetadata) {
            super(targetMetadata);
        }

        @Override
        @Nullable
        protected Environment getEnvironment() {
            return AbstractBeanDefinition.this.environment;
        }
    }
}

