/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.annotation;

import io.micronaut.core.annotation.AnnotationMetadataDelegate;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.AnnotationValueResolver;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import io.micronaut.core.value.OptionalValues;
import io.micronaut.inject.annotation.AnnotationMetadataSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Supplier;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MappingAnnotationMetadataDelegate
implements AnnotationMetadataDelegate {
    public abstract <T extends Annotation> AnnotationValue<T> mapAnnotationValue(AnnotationValue<T> var1);

    public Optional<String> stringValue(String annotation, String member) {
        return this.findAnnotation(annotation).flatMap(av -> av.stringValue(member));
    }

    public Optional<String> stringValue(Class<? extends Annotation> annotation, String member) {
        return this.stringValue(annotation.getName(), member);
    }

    public Optional<String> stringValue(Class<? extends Annotation> annotation) {
        return this.stringValue(annotation, "value");
    }

    public Optional<String> stringValue(String annotation) {
        return this.stringValue(annotation, "value");
    }

    public String[] stringValues(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.stringValues(member)).orElse(StringUtils.EMPTY_STRING_ARRAY);
    }

    public String[] stringValues(Class<? extends Annotation> annotation, String member) {
        return this.stringValues(annotation.getName(), member);
    }

    public String[] stringValues(Class<? extends Annotation> annotation) {
        return this.stringValues(annotation, "value");
    }

    public String[] stringValues(String annotation) {
        return this.stringValues(annotation, "value");
    }

    public <E extends Enum<E>> Optional<E> enumValue(String annotation, Class<E> enumType) {
        return this.enumValue(annotation, "value", enumType);
    }

    public <E extends Enum<E>> Optional<E> enumValue(String annotation, String member, Class<E> enumType) {
        return this.findAnnotation(annotation).flatMap(av -> av.enumValue(member, enumType));
    }

    public <E extends Enum<E>> Optional<E> enumValue(Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValue(annotation.getName(), "value", enumType);
    }

    public <E extends Enum<E>> Optional<E> enumValue(Class<? extends Annotation> annotation, String member, Class<E> enumType) {
        return this.enumValue(annotation.getName(), member, enumType);
    }

    public <E extends Enum<E>> E[] enumValues(String annotation, String member, Class<E> enumType) {
        return this.findAnnotation(annotation).map(av -> av.enumValues(member, enumType)).orElse((Enum[])Array.newInstance(enumType, 0));
    }

    public <E extends Enum<E>> E[] enumValues(String annotation, Class<E> enumType) {
        return this.enumValues(annotation, "value", enumType);
    }

    public <E extends Enum<E>> E[] enumValues(Class<? extends Annotation> annotation, Class<E> enumType) {
        return this.enumValues(annotation.getName(), "value", enumType);
    }

    public <E extends Enum<E>> E[] enumValues(Class<? extends Annotation> annotation, String member, Class<E> enumType) {
        return this.enumValues(annotation.getName(), member, enumType);
    }

    public <T> Class<T>[] classValues(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.classValues(member)).orElse(ReflectionUtils.EMPTY_CLASS_ARRAY);
    }

    public <T> Class<T>[] classValues(String annotation) {
        return this.classValues(annotation, "value");
    }

    public <T> Class<T>[] classValues(Class<? extends Annotation> annotation) {
        return this.classValues(annotation.getName(), "value");
    }

    public <T> Class<T>[] classValues(Class<? extends Annotation> annotation, String member) {
        return this.classValues(annotation.getName(), member);
    }

    public Optional<Boolean> booleanValue(String annotation, String member) {
        return this.findAnnotation(annotation).flatMap(av -> av.booleanValue(member));
    }

    public Optional<Boolean> booleanValue(Class<? extends Annotation> annotation, String member) {
        return this.booleanValue(annotation.getName(), member);
    }

    public Optional<Boolean> booleanValue(Class<? extends Annotation> annotation) {
        return this.booleanValue(annotation.getName(), "value");
    }

    public Optional<Boolean> booleanValue(String annotation) {
        return this.booleanValue(annotation, "value");
    }

    public boolean isTrue(String annotation, String member) {
        return this.getValue(annotation, member, Boolean.class).orElse(false);
    }

    public boolean isTrue(Class<? extends Annotation> annotation, String member) {
        return this.isTrue(annotation.getName(), member);
    }

    public boolean isFalse(String annotation, String member) {
        return !this.isTrue(annotation, member);
    }

    public boolean isFalse(Class<? extends Annotation> annotation, String member) {
        return this.isFalse(annotation.getName(), member);
    }

    public Optional<Class> classValue(String annotation, String member) {
        return this.findAnnotation(annotation).flatMap(av -> av.classValue(member));
    }

    public Optional<Class> classValue(String annotation) {
        return this.classValue(annotation, "value");
    }

    public Optional<Class> classValue(Class<? extends Annotation> annotation) {
        return this.classValue(annotation.getName(), "value");
    }

    public Optional<Class> classValue(Class<? extends Annotation> annotation, String member) {
        return this.classValue(annotation.getName(), member);
    }

    public OptionalInt intValue(String annotation, String member) {
        return this.findAnnotation(annotation).map(AnnotationValue::intValue).orElse(OptionalInt.empty());
    }

    public OptionalInt intValue(Class<? extends Annotation> annotation, String member) {
        return this.intValue(annotation.getName(), member);
    }

    public OptionalInt intValue(Class<? extends Annotation> annotation) {
        return this.intValue(annotation.getName(), "value");
    }

    public OptionalLong longValue(String annotation, String member) {
        return this.findAnnotation(annotation).map(AnnotationValueResolver::longValue).orElse(OptionalLong.empty());
    }

    public OptionalLong longValue(Class<? extends Annotation> annotation, String member) {
        return this.longValue(annotation.getName(), member);
    }

    public OptionalDouble doubleValue(String annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.doubleValue(member)).orElse(OptionalDouble.empty());
    }

    public OptionalDouble doubleValue(Class<? extends Annotation> annotation, String member) {
        return this.findAnnotation(annotation).map(av -> av.doubleValue(member)).orElse(OptionalDouble.empty());
    }

    public OptionalDouble doubleValue(Class<? extends Annotation> annotation) {
        return this.doubleValue(annotation, "value");
    }

    public <T> Optional<T> getValue(String annotation, String member, Argument<T> requiredType) {
        return this.findAnnotation(annotation).flatMap(av -> av.get((CharSequence)member, requiredType));
    }

    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, String member, Argument<T> requiredType) {
        return this.findAnnotation(annotation).flatMap(av -> av.get((CharSequence)member, requiredType));
    }

    public <T> Optional<T> getValue(String annotation, Argument<T> requiredType) {
        return this.getValue(annotation, "value", requiredType);
    }

    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, Argument<T> requiredType) {
        return this.getValue(annotation, "value", requiredType);
    }

    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, String member, Class<T> requiredType) {
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    public <T> Optional<T> getValue(Class<? extends Annotation> annotation, Class<T> requiredType) {
        return this.getValue(annotation, "value", requiredType);
    }

    public <T> Optional<T> getValue(String annotation, String member, Class<T> requiredType) {
        return this.getValue(annotation, member, Argument.of(requiredType));
    }

    public <T> Optional<T> getValue(String annotation, Class<T> requiredType) {
        return this.getValue(annotation, "value", Argument.of(requiredType));
    }

    public Optional<Object> getValue(String annotation, String member) {
        return this.getValue(annotation, member, Object.class);
    }

    public Optional<Object> getValue(Class<? extends Annotation> annotation, String member) {
        return this.getValue(annotation, member, Object.class);
    }

    public Optional<Object> getValue(String annotation) {
        return this.getValue(annotation, "value", Object.class);
    }

    public Optional<Object> getValue(Class<? extends Annotation> annotation) {
        return this.getValue(annotation, "value", Object.class);
    }

    public <T> OptionalValues<T> getValues(Class<? extends Annotation> annotation, Class<T> valueType) {
        return this.getValues(annotation.getName(), valueType);
    }

    public <T> OptionalValues<T> getValues(String annotation, Class<T> valueType) {
        return OptionalValues.of(valueType, this.getValues(annotation));
    }

    public Map<CharSequence, Object> getValues(String annotation) {
        return this.findAnnotation(annotation).map(AnnotationValue::getValues).orElse(Collections.emptyMap());
    }

    public <T extends Annotation> AnnotationValue<T> getDeclaredAnnotation(Class<T> annotationClass) {
        AnnotationValue av = this.getAnnotationMetadata().getDeclaredAnnotation(annotationClass);
        if (av != null) {
            return this.mapAnnotationValue(av);
        }
        return null;
    }

    public <T extends Annotation> AnnotationValue<T> getAnnotation(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass.getName());
    }

    public <T extends Annotation> AnnotationValue<T> getAnnotation(String annotation) {
        AnnotationValue av = this.getAnnotationMetadata().getAnnotation(annotation);
        if (av != null) {
            return this.mapAnnotationValue(av);
        }
        return null;
    }

    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(String annotation) {
        AnnotationValue av = this.getAnnotationMetadata().getAnnotation(annotation);
        if (av != null) {
            return Optional.of(this.mapAnnotationValue(av));
        }
        return Optional.empty();
    }

    public <T extends Annotation> Optional<AnnotationValue<T>> findAnnotation(Class<T> annotationClass) {
        return this.getAnnotationMetadata().findAnnotation(annotationClass).map(this::mapAnnotationValue);
    }

    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(Class<T> annotationClass) {
        return this.findDeclaredAnnotation(annotationClass.getName());
    }

    public <T extends Annotation> Optional<AnnotationValue<T>> findDeclaredAnnotation(String annotation) {
        Optional av = this.getAnnotationMetadata().findDeclaredAnnotation(annotation);
        return av.map(this::mapAnnotationValue);
    }

    public <T extends Annotation> T[] synthesizeDeclaredAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])this.getDeclaredAnnotationValuesByType(annotationClass).stream().map(annotation -> AnnotationMetadataSupport.buildAnnotation(annotationClass, annotation)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    public <T extends Annotation> T[] synthesizeAnnotationsByType(Class<T> annotationClass) {
        return (Annotation[])this.getAnnotationValuesByType(annotationClass).stream().map(annotation -> AnnotationMetadataSupport.buildAnnotation(annotationClass, annotation)).toArray(value -> (Annotation[])Array.newInstance(annotationClass, value));
    }

    public <T extends Annotation> T synthesizeDeclared(Class<T> annotationClass) {
        return (T)((Annotation)this.findDeclaredAnnotation(annotationClass).map(av -> AnnotationMetadataSupport.buildAnnotation(annotationClass, av)).orElse(null));
    }

    public <T extends Annotation> T synthesize(Class<T> annotationClass) {
        return (T)((Annotation)this.findAnnotation(annotationClass).map(av -> AnnotationMetadataSupport.buildAnnotation(annotationClass, av)).orElse(null));
    }

    public <T extends Annotation> T synthesize(Class<T> annotationClass, String sourceAnnotation) {
        AnnotationValue<T> av = this.getAnnotation(sourceAnnotation);
        if (av != null) {
            return AnnotationMetadataSupport.buildAnnotation(annotationClass, av);
        }
        return null;
    }

    public <T extends Annotation> T synthesizeDeclared(Class<T> annotationClass, String sourceAnnotation) {
        AnnotationValue av = this.getDeclaredAnnotation(sourceAnnotation);
        if (av != null) {
            return AnnotationMetadataSupport.buildAnnotation(annotationClass, av);
        }
        return null;
    }

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByType(Class<T> annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getAnnotationValuesByType(annotationType));
    }

    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByType(Class<T> annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getDeclaredAnnotationValuesByType(annotationType));
    }

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByStereotype(String stereotype) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getAnnotationValuesByStereotype(stereotype));
    }

    public <T extends Annotation> List<AnnotationValue<T>> getDeclaredAnnotationValuesByName(String annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getDeclaredAnnotationValuesByName(annotationType));
    }

    public <T extends Annotation> List<AnnotationValue<T>> getAnnotationValuesByName(String annotationType) {
        return this.getAnnotationValues(() -> this.getAnnotationMetadata().getAnnotationValuesByName(annotationType));
    }

    private <T extends Annotation> List<AnnotationValue<T>> getAnnotationValues(Supplier<List<AnnotationValue<T>>> supplier) {
        return supplier.get().stream().map(this::mapAnnotationValue).toList();
    }
}

