/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.conditions;

import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.condition.Condition;
import io.micronaut.context.condition.ConditionContext;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

@Internal
public record MatchesAbsenceOfBeansCondition(AnnotationClassValue<?>[] missingBeans) implements Condition
{
    @Override
    public boolean matches(ConditionContext context) {
        Object component = context.getComponent();
        if (component instanceof BeanDefinition) {
            BeanDefinition bd = (BeanDefinition)component;
            DefaultBeanContext beanContext = (DefaultBeanContext)context.getBeanContext();
            for (AnnotationClassValue<?> bean : this.missingBeans) {
                Class type = bean.getType().orElse(null);
                if (type == null) continue;
                Collection beanDefinitions = beanContext.findBeanCandidates(context.getBeanResolutionContext(), Argument.of((Class)type), bd);
                for (BeanDefinition beanDefinition : beanDefinitions) {
                    if (beanDefinition.isAbstract()) continue;
                    context.fail("Existing bean [" + beanDefinition.getName() + "] of type [" + type.getName() + "] registered in context");
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchesAbsenceOfBeansCondition that = (MatchesAbsenceOfBeansCondition)o;
        return Objects.deepEquals(this.missingBeans, that.missingBeans);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.missingBeans);
    }

    @Override
    public String toString() {
        return "MatchesAbsenceOfBeansCondition{missingBeans=" + Arrays.toString(this.missingBeans) + "}";
    }
}

