/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.type.Argument;
import io.micronaut.inject.BeanDefinition;
import jakarta.inject.Provider;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@FunctionalInterface
public interface BeanProvider<T>
extends Iterable<T> {
    @NonNull
    public T get();

    @NonNull
    default public Provider<T> asJakartaProvider() {
        return this::get;
    }

    default public Optional<T> find(@Nullable Qualifier<T> qualifier) {
        if (this.isPresent()) {
            return Optional.of(this.get());
        }
        return Optional.empty();
    }

    @NonNull
    default public BeanDefinition<T> getDefinition() {
        throw new UnsupportedOperationException("BeanDefinition information can only be obtained from dependency injected providers");
    }

    @NonNull
    default public T get(@Nullable Qualifier<T> qualifier) {
        return this.get();
    }

    @Override
    @NonNull
    default public Iterator<T> iterator() {
        return Collections.singletonList(this.get()).iterator();
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public boolean isUnique() {
        return true;
    }

    default public boolean isPresent() {
        return true;
    }

    default public boolean isResolvable() {
        return this.isUnique() && this.isPresent();
    }

    default public void ifPresent(@NonNull Consumer<T> consumer) {
        if (this.isPresent()) {
            Objects.requireNonNull(consumer, "Consumer cannot be null").accept(this.get());
        }
    }

    default public void ifResolvable(@NonNull Consumer<T> consumer) {
        if (this.isResolvable()) {
            Objects.requireNonNull(consumer, "Consumer cannot be null").accept(this.get());
        }
    }

    @Nullable
    default public T orElse(@Nullable T alternative) {
        if (this.isPresent()) {
            return this.get();
        }
        return alternative;
    }

    @NonNull
    public static <T1> Argument<BeanProvider<T1>> argumentOf(@NonNull Class<T1> type) {
        return Argument.of(BeanProvider.class, (Class[])new Class[]{Objects.requireNonNull(type, "Type cannot be null")});
    }
}

