/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.json;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.type.Argument;
import io.micronaut.json.JsonFeatures;
import io.micronaut.json.JsonMapperSupplier;
import io.micronaut.json.JsonStreamConfig;
import io.micronaut.json.tree.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.reactivestreams.Processor;

public interface JsonMapper {
    @NonNull
    default public JsonMapper createSpecific(@NonNull Argument<?> type) {
        return this;
    }

    public <T> T readValueFromTree(@NonNull JsonNode var1, @NonNull Argument<T> var2) throws IOException;

    default public <T> T readValueFromTree(@NonNull JsonNode tree, @NonNull Class<T> type) throws IOException {
        return this.readValueFromTree(tree, Argument.of(type));
    }

    public <T> T readValue(@NonNull InputStream var1, @NonNull Argument<T> var2) throws IOException;

    @Nullable
    default public <T> T readValue(@NonNull InputStream inputStream, @NonNull Class<T> type) throws IOException {
        Objects.requireNonNull(type, "Type cannot be null");
        return this.readValue(inputStream, Argument.of(type));
    }

    public <T> T readValue(byte @NonNull [] var1, @NonNull Argument<T> var2) throws IOException;

    default public <T> T readValue(@NonNull ByteBuffer<?> byteBuffer, @NonNull Argument<T> type) throws IOException {
        return this.readValue(byteBuffer.toByteArray(), type);
    }

    default public <T> T readValue(@NonNull String string, @NonNull Argument<T> type) throws IOException {
        return this.readValue(string.getBytes(StandardCharsets.UTF_8), type);
    }

    @Nullable
    default public <T> T readValue(byte @NonNull [] byteArray, @NonNull Class<T> type) throws IOException {
        Objects.requireNonNull(type, "Type cannot be null");
        return this.readValue(byteArray, Argument.of(type));
    }

    @Nullable
    default public <T> T readValue(@NonNull String string, @NonNull Class<T> type) throws IOException {
        Objects.requireNonNull(type, "Type cannot be null");
        return this.readValue(string, Argument.of(type));
    }

    @NonNull
    @Deprecated
    default public Processor<byte[], JsonNode> createReactiveParser(@NonNull Consumer<Processor<byte[], JsonNode>> onSubscribe, boolean streamArray) {
        throw new UnsupportedOperationException("Reactive parser not supported");
    }

    @NonNull
    public JsonNode writeValueToTree(@Nullable Object var1) throws IOException;

    @NonNull
    public <T> JsonNode writeValueToTree(@NonNull Argument<T> var1, @Nullable T var2) throws IOException;

    public void writeValue(@NonNull OutputStream var1, @Nullable Object var2) throws IOException;

    public <T> void writeValue(@NonNull OutputStream var1, @NonNull Argument<T> var2, @Nullable T var3) throws IOException;

    public byte[] writeValueAsBytes(@Nullable Object var1) throws IOException;

    public <T> byte[] writeValueAsBytes(@NonNull Argument<T> var1, @Nullable T var2) throws IOException;

    @NonNull
    default public String writeValueAsString(@NonNull Object object) throws IOException {
        Objects.requireNonNull(object, "Object cannot be null");
        return new String(this.writeValueAsBytes(object), StandardCharsets.UTF_8);
    }

    @NonNull
    default public <T> String writeValueAsString(@NonNull Argument<T> type, @Nullable T object) throws IOException {
        return this.writeValueAsString(type, object, StandardCharsets.UTF_8);
    }

    @NonNull
    default public <T> String writeValueAsString(@NonNull Argument<T> type, @Nullable T object, Charset charset) throws IOException {
        Objects.requireNonNull(charset, "Charset cannot be null");
        byte[] bytes = this.writeValueAsBytes(type, object);
        return new String(bytes, charset);
    }

    default public void updateValueFromTree(Object value, @NonNull JsonNode tree) throws IOException {
        throw new UnsupportedOperationException();
    }

    @NonNull
    default public JsonMapper cloneWithFeatures(@NonNull JsonFeatures features) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    default public Optional<JsonFeatures> detectFeatures(@NonNull AnnotationMetadata annotations) {
        return Optional.empty();
    }

    @NonNull
    default public JsonMapper cloneWithViewClass(@NonNull Class<?> viewClass) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public JsonStreamConfig getStreamConfig();

    @NonNull
    public static JsonMapper createDefault() {
        AtomicReference ex = new AtomicReference();
        return (JsonMapper)ServiceLoader.load(JsonMapperSupplier.class).stream().flatMap(p -> {
            try {
                JsonMapperSupplier supplier = (JsonMapperSupplier)p.get();
                return Stream.ofNullable(supplier);
            }
            catch (Exception e) {
                JsonMapper.addException(ex, e);
                return Stream.empty();
            }
        }).sorted(OrderUtil.COMPARATOR).flatMap(jsonMapperSupplier -> {
            try {
                return Stream.of((JsonMapper)jsonMapperSupplier.get());
            }
            catch (Exception e) {
                JsonMapper.addException(ex, e);
                return Stream.empty();
            }
        }).findFirst().orElseThrow(() -> {
            if (ex.get() != null) {
                return (IllegalStateException)ex.get();
            }
            return new IllegalStateException("No default JsonMapper implementation found");
        });
    }

    private static void addException(AtomicReference<IllegalStateException> ref, Exception toAdd) {
        ref.updateAndGet(existing -> {
            if (existing == null) {
                return new IllegalStateException("Failed to initialize default JsonMapper", toAdd);
            }
            existing.addSuppressed(toAdd);
            return existing;
        });
    }
}

