/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.health;

import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.health.HealthStatus;
import io.micronaut.http.HttpStatus;
import io.micronaut.management.endpoint.annotation.Endpoint;
import io.micronaut.management.endpoint.annotation.Read;
import io.micronaut.management.endpoint.health.DetailsVisibility;
import io.micronaut.management.endpoint.health.HealthLevelOfDetail;
import io.micronaut.management.health.aggregator.HealthAggregator;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.reactivex.Single;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Endpoint(value="health", defaultSensitive=false)
public class HealthEndpoint {
    public static final boolean DEFAULT_SENSITIVE = false;
    public static final String NAME = "health";
    public static final String PREFIX = "endpoints.health";
    private HealthAggregator<HealthResult> healthAggregator;
    private HealthIndicator[] healthIndicators;
    private DetailsVisibility detailsVisible = DetailsVisibility.AUTHENTICATED;
    private StatusConfiguration statusConfiguration;

    public HealthEndpoint(HealthAggregator<HealthResult> healthAggregator, HealthIndicator[] healthIndicators) {
        this.healthAggregator = healthAggregator;
        this.healthIndicators = healthIndicators;
    }

    @Read
    public Single<HealthResult> getHealth(@Nullable Principal principal) {
        HealthLevelOfDetail detail = this.levelOfDetail(principal);
        return Single.fromPublisher(this.healthAggregator.aggregate(this.healthIndicators, detail));
    }

    public DetailsVisibility getDetailsVisible() {
        return this.detailsVisible;
    }

    public void setDetailsVisible(DetailsVisibility detailsVisible) {
        this.detailsVisible = detailsVisible;
    }

    public StatusConfiguration getStatusConfiguration() {
        return this.statusConfiguration;
    }

    @Inject
    public void setStatusConfiguration(StatusConfiguration statusConfiguration) {
        if (statusConfiguration != null) {
            this.statusConfiguration = statusConfiguration;
        }
    }

    protected HealthLevelOfDetail levelOfDetail(@Nullable Principal principal) {
        boolean showDetails = false;
        switch (this.detailsVisible) {
            case AUTHENTICATED: {
                showDetails = principal != null;
                break;
            }
            case ANONYMOUS: {
                showDetails = true;
            }
        }
        if (showDetails) {
            return HealthLevelOfDetail.STATUS_DESCRIPTION_DETAILS;
        }
        return HealthLevelOfDetail.STATUS;
    }

    @ConfigurationProperties(value="status")
    public static class StatusConfiguration {
        private Map<String, HttpStatus> httpMapping = new HashMap<String, HttpStatus>();

        public StatusConfiguration() {
            this.httpMapping.put("DOWN", HttpStatus.SERVICE_UNAVAILABLE);
            this.httpMapping.put("UP", HttpStatus.OK);
            this.httpMapping.put(HealthStatus.UNKNOWN.getName(), HttpStatus.OK);
        }

        public Map<String, HttpStatus> getHttpMapping() {
            return this.httpMapping;
        }

        public void setHttpMapping(Map<String, HttpStatus> httpMapping) {
            if (httpMapping != null) {
                for (Map.Entry<String, HttpStatus> entry : httpMapping.entrySet()) {
                    this.httpMapping.put(entry.getKey().toUpperCase(Locale.ENGLISH), entry.getValue());
                }
            }
        }
    }
}

