/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.endpoint.info.source;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.annotation.Value;
import io.micronaut.context.env.PropertySource;
import io.micronaut.core.async.SupplierUtil;
import io.micronaut.core.io.ResourceResolver;
import io.micronaut.management.endpoint.info.InfoEndpoint;
import io.micronaut.management.endpoint.info.source.PropertiesInfoSource;
import io.micronaut.runtime.context.scope.Refreshable;
import io.reactivex.Flowable;
import java.util.Optional;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

@Refreshable
@Requirements(value={@Requires(beans={InfoEndpoint.class}), @Requires(property="endpoints.info.build.enabled", notEquals="false")})
public class BuildInfoSource
implements PropertiesInfoSource {
    private static final String EXTENSION = ".properties";
    private static final String PREFIX = "classpath:";
    private final String buildPropertiesPath;
    private final ResourceResolver resourceResolver;
    private final Supplier<Optional<PropertySource>> supplier;

    public BuildInfoSource(ResourceResolver resourceResolver, @Value(value="${endpoints.info.build.location:META-INF/build-info.properties}") String buildPropertiesPath) {
        this.resourceResolver = resourceResolver;
        this.supplier = SupplierUtil.memoized(this::retrieveBuildInfo);
        this.buildPropertiesPath = buildPropertiesPath;
    }

    @Override
    public Publisher<PropertySource> getSource() {
        Optional<PropertySource> propertySource = this.supplier.get();
        return (Publisher)propertySource.map(Flowable::just).orElse(Flowable.empty());
    }

    private Optional<PropertySource> retrieveBuildInfo() {
        return this.retrievePropertiesPropertySource(this.buildPropertiesPath, PREFIX, EXTENSION, this.resourceResolver);
    }
}

