/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.management.health.monitor;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.health.CurrentHealthStatus;
import io.micronaut.health.HealthStatus;
import io.micronaut.management.health.indicator.HealthIndicator;
import io.micronaut.management.health.indicator.HealthResult;
import io.micronaut.runtime.server.EmbeddedServer;
import io.micronaut.scheduling.annotation.Scheduled;
import io.reactivex.Flowable;
import io.reactivex.MaybeObserver;
import io.reactivex.disposables.Disposable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requirements(value={@Requires(beans={EmbeddedServer.class}), @Requires(property="micronaut.application.name"), @Requires(property="micronaut.health.monitor.enabled", value="true", defaultValue="true")})
public class HealthMonitorTask {
    private static final Logger LOG = LoggerFactory.getLogger(HealthMonitorTask.class);
    private final CurrentHealthStatus currentHealthStatus;
    private final List<HealthIndicator> healthIndicators;

    @Inject
    public HealthMonitorTask(CurrentHealthStatus currentHealthStatus, List<HealthIndicator> healthIndicators) {
        this.currentHealthStatus = currentHealthStatus;
        this.healthIndicators = healthIndicators;
    }

    public HealthMonitorTask(CurrentHealthStatus currentHealthStatus, HealthIndicator ... healthIndicators) {
        this(currentHealthStatus, Arrays.asList(healthIndicators));
    }

    @Scheduled(fixedDelay="${micronaut.health.monitor.interval:1m}", initialDelay="${micronaut.health.monitor.initial-delay:1m}")
    void monitor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting health monitor check");
        }
        List healthResults = this.healthIndicators.stream().map(HealthIndicator::getResult).collect(Collectors.toList());
        Flowable resultFlowable = Flowable.merge(healthResults).filter(healthResult -> {
            HealthStatus status = healthResult.getStatus();
            return status.equals((Object)HealthStatus.DOWN) || status.getOperational().orElse(true) == false;
        });
        resultFlowable.firstElement().subscribe((MaybeObserver)new MaybeObserver<HealthResult>(){

            public void onSubscribe(Disposable d) {
            }

            public void onSuccess(HealthResult healthResult) {
                HealthStatus status = healthResult.getStatus();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Health monitor check failed with status {}", (Object)status);
                }
                HealthMonitorTask.this.currentHealthStatus.update(status);
            }

            public void onError(Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error("Health monitor check failed with exception: " + e.getMessage(), e);
                }
                HealthMonitorTask.this.currentHealthStatus.update(HealthStatus.DOWN.describe("Error occurred running health check: " + e.getMessage()));
            }

            public void onComplete() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Health monitor check passed.");
                }
                HealthMonitorTask.this.currentHealthStatus.update(HealthStatus.UP);
            }
        });
    }
}

