/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Formatting
extends Enum<Formatting> {
    private static final /* synthetic */ Formatting[] $VALUES;

    public static Formatting[] values() {
        return (Formatting[])$VALUES.clone();
    }

    public static Formatting valueOf(String name) {
        return Enum.valueOf(Formatting.class, name);
    }

    public static String rightTrim(String line) {
        int end = 0;
        for (int i = line.length(); i > 0; --i) {
            if (Character.isWhitespace(line.charAt(i - 1))) continue;
            end = i;
            break;
        }
        return line.substring(0, end);
    }

    public static String trim(String line) {
        int start = line.length();
        for (int i = 0; i < line.length(); ++i) {
            if (Character.isWhitespace(line.charAt(i))) continue;
            start = i;
            break;
        }
        int end = start;
        for (int i = line.length(); i > start; --i) {
            if (Character.isWhitespace(line.charAt(i - 1))) continue;
            end = i;
            break;
        }
        return line.substring(start, end);
    }

    private static /* synthetic */ Formatting[] $values() {
        return new Formatting[0];
    }

    static {
        $VALUES = Formatting.$values();
    }

    public static class ReplaceDotsWithUnderscoreLambda
    implements Mustache.Lambda {
        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            writer.write(fragment.execute().replace('.', '_'));
        }
    }

    public static class IndentFormatter
    implements Mustache.Lambda {
        private final String indent;

        public IndentFormatter(int indentSize) {
            this.indent = " ".repeat(Math.max(0, indentSize));
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            String text = Arrays.stream(fragment.execute().split("\n")).map(line -> this.indent + line).collect(Collectors.joining("\n"));
            writer.write(text);
        }
    }

    public static class SingleLineFormatter
    implements Mustache.Lambda {
        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            String text = fragment.execute().replaceAll("\\s+", " ").replaceAll("(?<=<)\\s+|\\s+(?=>)", "");
            writer.write(Formatting.trim(text));
        }
    }

    public static class LineFormatter
    implements Mustache.Lambda {
        private final int maxEmptyLines;

        public LineFormatter(int maxEmptyLines) {
            this.maxEmptyLines = maxEmptyLines;
        }

        public void execute(Template.Fragment fragment, Writer writer) throws IOException {
            String text = fragment.execute();
            String finalWhitespace = this.getFinalWhitespace(text);
            Object lines = Arrays.stream(text.split("\n")).map(Formatting::rightTrim).filter(new LineSkippingPredicate()).collect(Collectors.joining("\n"));
            if (!((String)lines).isEmpty() && this.maxEmptyLines == 0) {
                lines = "\n" + (String)lines + "\n";
            }
            if (!((String)lines).isEmpty()) {
                lines = (String)lines + finalWhitespace;
            }
            writer.write((String)lines);
        }

        private String getFinalWhitespace(String text) {
            int i;
            for (i = text.length(); i > 0 && Character.isWhitespace(text.charAt(i - 1)) && text.charAt(i - 1) != '\n'; --i) {
            }
            return text.substring(i);
        }

        private class LineSkippingPredicate
        implements Predicate<String> {
            private int emptyLines;

            private LineSkippingPredicate() {
            }

            @Override
            public boolean test(String s) {
                this.emptyLines = s.isBlank() ? ++this.emptyLines : 0;
                return this.emptyLines <= LineFormatter.this.maxEmptyLines;
            }
        }
    }
}

