/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.AbstractMicronautKotlinCodegen;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautClientCodegen;
import io.micronaut.openapi.generator.JavaMicronautClientOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautServerCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerOptionsBuilder;
import io.micronaut.openapi.generator.KotlinMicronautClientCodegen;
import io.micronaut.openapi.generator.KotlinMicronautClientOptionsBuilder;
import io.micronaut.openapi.generator.KotlinMicronautServerCodegen;
import io.micronaut.openapi.generator.KotlinMicronautServerOptionsBuilder;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautCodeGeneratorBuilder;
import io.micronaut.openapi.generator.MicronautCodeGeneratorOptionsBuilder;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.ResponseBodyMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.DefaultGenerator;

public final class MicronautCodeGeneratorEntryPoint {
    private final URI definitionFile;
    private final File outputDirectory;
    private final DefaultCodegen codeGenerator;
    private final EnumSet<OutputKind> outputs;
    private final Options options;
    private final JavaMicronautServerCodegen.ServerOptions javaServerOptions;
    private final JavaMicronautClientCodegen.ClientOptions javaClientOptions;
    private final KotlinMicronautServerCodegen.ServerOptions kotlinServerOptions;
    private final KotlinMicronautClientCodegen.ClientOptions kotlinClientOptions;

    private MicronautCodeGeneratorEntryPoint(URI definitionFile, File outputDirectory, DefaultCodegen codeGenerator, EnumSet<OutputKind> outputs, Options options, JavaMicronautServerCodegen.ServerOptions javaServerOptions, JavaMicronautClientCodegen.ClientOptions javaClientOptions, KotlinMicronautServerCodegen.ServerOptions kotlinServerOptions, KotlinMicronautClientCodegen.ClientOptions kotlinClientOptions) {
        this.definitionFile = definitionFile;
        this.outputDirectory = outputDirectory;
        this.codeGenerator = codeGenerator;
        this.outputs = outputs;
        this.options = options;
        this.javaServerOptions = javaServerOptions;
        this.javaClientOptions = javaClientOptions;
        this.kotlinServerOptions = kotlinServerOptions;
        this.kotlinClientOptions = kotlinClientOptions;
    }

    private static void withPath(File file, Consumer<? super String> action) {
        if (file == null) {
            return;
        }
        try {
            String path = file.getCanonicalPath();
            action.accept(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generate() {
        ParseOptions opts = new ParseOptions();
        opts.setResolve(true);
        OpenAPI openAPI = new OpenAPIParser().readLocation(this.definitionFile.toString(), null, opts).getOpenAPI();
        MicronautCodeGeneratorEntryPoint.withPath(this.outputDirectory, this.codeGenerator::setOutputDir);
        Object object = this.codeGenerator;
        if (object instanceof AbstractMicronautJavaCodegen) {
            AbstractMicronautJavaCodegen javaCodegen = (AbstractMicronautJavaCodegen)object;
            javaCodegen.setHideGenerationTimestamp(true);
        } else {
            object = this.codeGenerator;
            if (object instanceof AbstractMicronautKotlinCodegen) {
                AbstractMicronautKotlinCodegen kotlinCodegen = (AbstractMicronautKotlinCodegen)object;
                kotlinCodegen.setHideGenerationTimestamp(true);
            }
        }
        this.configureOptions();
        ClientOptInput input = new ClientOptInput();
        input.openAPI(openAPI);
        input.config((CodegenConfig)this.codeGenerator);
        DefaultGenerator generator = new DefaultGenerator();
        for (OutputKind outputKind : OutputKind.values()) {
            generator.setGeneratorPropertyDefault(outputKind.generatorProperty, "false");
        }
        for (OutputKind outputKind : this.outputs) {
            generator.setGeneratorPropertyDefault(outputKind.generatorProperty, "true");
        }
        generator.opts(input).generate();
    }

    private void configureOptions() {
        DefaultCodegen defaultCodegen;
        if (this.options == null) {
            return;
        }
        if (this.options.additionalProperties != null && !this.options.additionalProperties.isEmpty()) {
            this.codeGenerator.additionalProperties().putAll(this.options.additionalProperties);
        }
        if (this.options.modelPackage != null) {
            this.codeGenerator.setModelPackage(this.options.modelPackage);
        }
        if (this.options.apiPackage != null) {
            this.codeGenerator.setApiPackage(this.options.apiPackage);
        }
        if ((this.options.lang == null || this.options.lang == MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.JAVA) && (defaultCodegen = this.codeGenerator) instanceof AbstractMicronautJavaCodegen) {
            AbstractMicronautJavaCodegen javaCodeGen = (AbstractMicronautJavaCodegen)((Object)defaultCodegen);
            if (this.options.invokerPackage != null) {
                javaCodeGen.setInvokerPackage(this.options.invokerPackage);
            }
            if (this.options.artifactId != null) {
                javaCodeGen.setArtifactId(this.options.artifactId);
            }
            if (this.options.parameterMappings != null) {
                javaCodeGen.addParameterMappings(this.options.parameterMappings);
            }
            if (this.options.responseBodyMappings != null) {
                javaCodeGen.addResponseBodyMappings(this.options.responseBodyMappings);
            }
            if (this.options.schemaMapping != null) {
                javaCodeGen.addSchemaMapping(this.options.schemaMapping);
            }
            if (this.options.importMapping != null) {
                javaCodeGen.addImportMapping(this.options.importMapping);
            }
            if (this.options.nameMapping != null) {
                javaCodeGen.addNameMapping(this.options.nameMapping);
            }
            if (this.options.typeMapping != null) {
                javaCodeGen.addTypeMapping(this.options.typeMapping);
            }
            if (this.options.enumNameMapping != null) {
                javaCodeGen.addEnumNameMapping(this.options.enumNameMapping);
            }
            if (this.options.modelNameMapping != null) {
                javaCodeGen.addModelNameMapping(this.options.modelNameMapping);
            }
            if (this.options.inlineSchemaNameMapping != null) {
                javaCodeGen.addInlineSchemaNameMapping(this.options.inlineSchemaNameMapping);
            }
            if (this.options.inlineSchemaOption != null) {
                javaCodeGen.addInlineSchemaOption(this.options.inlineSchemaOption);
            }
            if (this.options.openapiNormalizer != null) {
                javaCodeGen.addOpenapiNormalizer(this.options.openapiNormalizer);
            }
            if (this.options.apiNamePrefix != null && !this.options.apiNamePrefix.isBlank()) {
                javaCodeGen.setApiNamePrefix(this.options.apiNamePrefix);
            }
            if (this.options.apiNameSuffix != null && !this.options.apiNameSuffix.isBlank()) {
                javaCodeGen.setApiNameSuffix(this.options.apiNameSuffix);
            }
            if (this.options.modelNamePrefix != null && !this.options.modelNamePrefix.isBlank()) {
                javaCodeGen.setModelNamePrefix(this.options.modelNamePrefix);
            }
            if (this.options.modelNameSuffix != null && !this.options.modelNameSuffix.isBlank()) {
                javaCodeGen.setModelNameSuffix(this.options.modelNameSuffix);
            }
            javaCodeGen.setImplicitHeaders(this.options.implicitHeaders);
            if (this.options.implicitHeadersRegex != null && !this.options.implicitHeadersRegex.isBlank()) {
                javaCodeGen.setImplicitHeadersRegex(this.options.implicitHeadersRegex);
            }
            if (this.options.additionalEnumTypeAnnotations != null && !this.options.additionalEnumTypeAnnotations.isEmpty()) {
                javaCodeGen.setAdditionalEnumTypeAnnotations(this.options.additionalEnumTypeAnnotations);
            }
            if (this.options.additionalModelTypeAnnotations != null && !this.options.additionalModelTypeAnnotations.isEmpty()) {
                javaCodeGen.setAdditionalModelTypeAnnotations(this.options.additionalModelTypeAnnotations);
            }
            if (this.options.additionalOneOfTypeAnnotations != null && !this.options.additionalOneOfTypeAnnotations.isEmpty()) {
                javaCodeGen.setAdditionalOneOfTypeAnnotations(this.options.additionalOneOfTypeAnnotations);
            }
            javaCodeGen.setUseJakartaEe(this.options.useJakartaEe);
            javaCodeGen.setUseOneOfInterfaces(this.options.useOneOfInterfaces);
            javaCodeGen.setReactive(this.options.reactive);
            javaCodeGen.setGenerateHttpResponseAlways(this.options.generateHttpResponseAlways);
            javaCodeGen.setGenerateHttpResponseWhereRequired(this.options.generateHttpResponseWhereRequired);
            javaCodeGen.setUseOptional(this.options.optional);
            javaCodeGen.setUseBeanValidation(this.options.beanValidation);
            javaCodeGen.setUseEnumCaseInsensitive(this.options.useEnumCaseInsensitive);
            javaCodeGen.setTestTool(this.options.testFramework.value);
            javaCodeGen.setSerializationLibrary(this.options.serializationLibraryKind.name());
            javaCodeGen.setGenerateSwaggerAnnotations(this.options.generateSwaggerAnnotations);
            javaCodeGen.setDateTimeLibrary(this.options.dateTimeFormat.name());
            javaCodeGen.setSortParamsByRequiredFlag(this.options.sortParamsByRequiredFlag);
            javaCodeGen.setSkipOperationExample(this.options.skipOperationExample);
            javaCodeGen.setSkipSortingOperations(this.options.skipSortingOperations);
            javaCodeGen.setRemoveOperationIdPrefixDelimiter(this.options.removeOperationIdPrefixDelimiter);
            javaCodeGen.setRemoveOperationIdPrefixCount(this.options.removeOperationIdPrefixCount);
            javaCodeGen.setSortModelPropertiesByRequiredFlag(this.options.sortModelPropertiesByRequiredFlag);
            javaCodeGen.setEnsureUniqueParams(this.options.ensureUniqueParams);
            javaCodeGen.setAllowUnicodeIdentifiers(this.options.allowUnicodeIdentifiers);
            javaCodeGen.setPrependFormOrBodyParameters(this.options.prependFormOrBodyParameters);
            this.configureJavaServerOptions();
            this.configureJavaClientOptions();
        } else if (this.options.lang == MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.KOTLIN && (defaultCodegen = this.codeGenerator) instanceof AbstractMicronautKotlinCodegen) {
            AbstractMicronautKotlinCodegen kotlinCodeGen = (AbstractMicronautKotlinCodegen)((Object)defaultCodegen);
            if (this.options.invokerPackage != null) {
                kotlinCodeGen.setPackageName(this.options.invokerPackage);
            }
            if (this.options.artifactId != null) {
                kotlinCodeGen.setArtifactId(this.options.artifactId);
            }
            if (this.options.parameterMappings != null) {
                kotlinCodeGen.addParameterMappings(this.options.parameterMappings);
            }
            if (this.options.responseBodyMappings != null) {
                kotlinCodeGen.addResponseBodyMappings(this.options.responseBodyMappings);
            }
            if (this.options.schemaMapping != null) {
                kotlinCodeGen.addSchemaMapping(this.options.schemaMapping);
            }
            if (this.options.importMapping != null) {
                kotlinCodeGen.addImportMapping(this.options.importMapping);
            }
            if (this.options.nameMapping != null) {
                kotlinCodeGen.addNameMapping(this.options.nameMapping);
            }
            if (this.options.typeMapping != null) {
                kotlinCodeGen.addTypeMapping(this.options.typeMapping);
            }
            if (this.options.enumNameMapping != null) {
                kotlinCodeGen.addEnumNameMapping(this.options.enumNameMapping);
            }
            if (this.options.modelNameMapping != null) {
                kotlinCodeGen.addModelNameMapping(this.options.modelNameMapping);
            }
            if (this.options.inlineSchemaNameMapping != null) {
                kotlinCodeGen.addInlineSchemaNameMapping(this.options.inlineSchemaNameMapping);
            }
            if (this.options.inlineSchemaOption != null) {
                kotlinCodeGen.addInlineSchemaOption(this.options.inlineSchemaOption);
            }
            if (this.options.openapiNormalizer != null) {
                kotlinCodeGen.addOpenapiNormalizer(this.options.openapiNormalizer);
            }
            if (this.options.apiNamePrefix != null && !this.options.apiNamePrefix.isBlank()) {
                kotlinCodeGen.setApiNamePrefix(this.options.apiNamePrefix);
            }
            if (this.options.apiNameSuffix != null && !this.options.apiNameSuffix.isBlank()) {
                kotlinCodeGen.setApiNameSuffix(this.options.apiNameSuffix);
            }
            if (this.options.modelNamePrefix != null && !this.options.modelNamePrefix.isBlank()) {
                kotlinCodeGen.setModelNamePrefix(this.options.modelNamePrefix);
            }
            if (this.options.modelNameSuffix != null && !this.options.modelNameSuffix.isBlank()) {
                kotlinCodeGen.setModelNameSuffix(this.options.modelNameSuffix);
            }
            kotlinCodeGen.setImplicitHeaders(this.options.implicitHeaders);
            if (this.options.implicitHeadersRegex != null && !this.options.implicitHeadersRegex.isBlank()) {
                kotlinCodeGen.setImplicitHeadersRegex(this.options.implicitHeadersRegex);
            }
            if (this.options.additionalEnumTypeAnnotations != null && !this.options.additionalEnumTypeAnnotations.isEmpty()) {
                kotlinCodeGen.setAdditionalEnumTypeAnnotations(this.options.additionalEnumTypeAnnotations);
            }
            if (this.options.additionalModelTypeAnnotations != null && !this.options.additionalModelTypeAnnotations.isEmpty()) {
                kotlinCodeGen.setAdditionalModelTypeAnnotations(this.options.additionalModelTypeAnnotations);
            }
            if (this.options.additionalOneOfTypeAnnotations != null && !this.options.additionalOneOfTypeAnnotations.isEmpty()) {
                kotlinCodeGen.setAdditionalOneOfTypeAnnotations(this.options.additionalOneOfTypeAnnotations);
            }
            kotlinCodeGen.setUseJakartaEe(this.options.useJakartaEe);
            kotlinCodeGen.setUseOneOfInterfaces(this.options.useOneOfInterfaces);
            kotlinCodeGen.setReactive(this.options.reactive);
            kotlinCodeGen.setGenerateHttpResponseAlways(this.options.generateHttpResponseAlways);
            kotlinCodeGen.setGenerateHttpResponseWhereRequired(this.options.generateHttpResponseWhereRequired);
            kotlinCodeGen.setGenerateSwaggerAnnotations(this.options.generateSwaggerAnnotations);
            kotlinCodeGen.setUseBeanValidation(this.options.beanValidation);
            kotlinCodeGen.setUseEnumCaseInsensitive(this.options.useEnumCaseInsensitive);
            kotlinCodeGen.setTestTool(this.options.testFramework.value);
            kotlinCodeGen.setSerializationLibrary(this.options.serializationLibraryKind.name());
            kotlinCodeGen.setDateTimeLibrary(this.options.dateTimeFormat.name());
            kotlinCodeGen.setSortParamsByRequiredFlag(this.options.sortParamsByRequiredFlag);
            kotlinCodeGen.setSkipOperationExample(this.options.skipOperationExample);
            kotlinCodeGen.setSkipSortingOperations(this.options.skipSortingOperations);
            kotlinCodeGen.setRemoveOperationIdPrefixDelimiter(this.options.removeOperationIdPrefixDelimiter);
            kotlinCodeGen.setRemoveOperationIdPrefixCount(this.options.removeOperationIdPrefixCount);
            kotlinCodeGen.setSortModelPropertiesByRequiredFlag(this.options.sortModelPropertiesByRequiredFlag);
            kotlinCodeGen.setEnsureUniqueParams(this.options.ensureUniqueParams);
            kotlinCodeGen.setAllowUnicodeIdentifiers(this.options.allowUnicodeIdentifiers);
            kotlinCodeGen.setPrependFormOrBodyParameters(this.options.prependFormOrBodyParameters);
            this.configureKotlinServerOptions();
            this.configureKotlinClientOptions();
        }
        this.codeGenerator.processOpts();
    }

    private void configureJavaServerOptions() {
        DefaultCodegen defaultCodegen;
        if (this.javaServerOptions != null && (defaultCodegen = this.codeGenerator) instanceof JavaMicronautServerCodegen) {
            JavaMicronautServerCodegen javaServerCodegen = (JavaMicronautServerCodegen)((Object)defaultCodegen);
            if (this.javaServerOptions.controllerPackage() != null) {
                javaServerCodegen.setControllerPackage(this.javaServerOptions.controllerPackage());
            }
            javaServerCodegen.setGenerateImplementationFiles(this.javaServerOptions.generateImplementationFiles());
            javaServerCodegen.setGenerateOperationsToReturnNotImplemented(this.javaServerOptions.generateOperationsToReturnNotImplemented());
            javaServerCodegen.setGenerateControllerFromExamples(this.javaServerOptions.generateControllerFromExamples());
            javaServerCodegen.setUseAuth(this.javaServerOptions.useAuth());
            javaServerCodegen.setLombok(this.javaServerOptions.lombok());
            javaServerCodegen.setPlural(this.javaServerOptions.plural());
            javaServerCodegen.setFluxForArrays(this.javaServerOptions.fluxForArrays());
            javaServerCodegen.setGeneratedAnnotation(this.javaServerOptions.generatedAnnotation());
        }
    }

    public void configureJavaClientOptions() {
        DefaultCodegen defaultCodegen;
        if (this.javaClientOptions != null && (defaultCodegen = this.codeGenerator) instanceof JavaMicronautClientCodegen) {
            JavaMicronautClientCodegen javaClientCodegen = (JavaMicronautClientCodegen)((Object)defaultCodegen);
            if (this.javaClientOptions.additionalClientTypeAnnotations() != null) {
                javaClientCodegen.setAdditionalClientTypeAnnotations(this.javaClientOptions.additionalClientTypeAnnotations());
            }
            if (this.javaClientOptions.clientId() != null && !this.javaClientOptions.clientId().isBlank()) {
                javaClientCodegen.setClientId(this.javaClientOptions.clientId());
            }
            if (this.javaClientOptions.authorizationFilterPattern() != null) {
                javaClientCodegen.setAuthorizationFilterPattern(this.javaClientOptions.authorizationFilterPattern());
            }
            if (this.javaClientOptions.basePathSeparator() != null) {
                javaClientCodegen.setBasePathSeparator(this.javaClientOptions.basePathSeparator());
            }
            javaClientCodegen.setClientPath(this.javaClientOptions.clientPath());
            javaClientCodegen.setGeneratedAnnotation(this.javaClientOptions.generatedAnnotation());
            javaClientCodegen.setConfigureAuthorization(this.javaClientOptions.useAuth());
            javaClientCodegen.setPlural(this.javaClientOptions.plural());
            javaClientCodegen.setFluxForArrays(this.javaClientOptions.fluxForArrays());
            javaClientCodegen.setLombok(this.javaClientOptions.lombok());
        }
    }

    private void configureKotlinServerOptions() {
        DefaultCodegen defaultCodegen;
        if (this.kotlinServerOptions != null && (defaultCodegen = this.codeGenerator) instanceof KotlinMicronautServerCodegen) {
            KotlinMicronautServerCodegen kotlinServerCodegen = (KotlinMicronautServerCodegen)((Object)defaultCodegen);
            if (this.kotlinServerOptions.controllerPackage() != null) {
                kotlinServerCodegen.setControllerPackage(this.kotlinServerOptions.controllerPackage());
            }
            kotlinServerCodegen.setGenerateImplementationFiles(this.kotlinServerOptions.generateImplementationFiles());
            kotlinServerCodegen.setGenerateOperationsToReturnNotImplemented(this.kotlinServerOptions.generateOperationsToReturnNotImplemented());
            kotlinServerCodegen.setGenerateControllerFromExamples(this.kotlinServerOptions.generateControllerFromExamples());
            kotlinServerCodegen.setGeneratedAnnotation(this.kotlinServerOptions.generatedAnnotation());
            kotlinServerCodegen.setKsp(this.kotlinServerOptions.ksp());
            kotlinServerCodegen.setUseAuth(this.kotlinServerOptions.useAuth());
            kotlinServerCodegen.setPlural(this.kotlinServerOptions.plural());
            kotlinServerCodegen.setFluxForArrays(this.kotlinServerOptions.fluxForArrays());
        }
    }

    public void configureKotlinClientOptions() {
        DefaultCodegen defaultCodegen;
        if (this.kotlinClientOptions != null && (defaultCodegen = this.codeGenerator) instanceof KotlinMicronautClientCodegen) {
            KotlinMicronautClientCodegen kotlinClientCodegen = (KotlinMicronautClientCodegen)((Object)defaultCodegen);
            if (this.kotlinClientOptions.additionalClientTypeAnnotations() != null) {
                kotlinClientCodegen.setAdditionalClientTypeAnnotations(this.kotlinClientOptions.additionalClientTypeAnnotations());
            }
            if (this.kotlinClientOptions.clientId() != null && !this.kotlinClientOptions.clientId().isBlank()) {
                kotlinClientCodegen.setClientId(this.kotlinClientOptions.clientId());
            }
            if (this.kotlinClientOptions.authorizationFilterPattern() != null) {
                kotlinClientCodegen.setAuthorizationFilterPattern(this.kotlinClientOptions.authorizationFilterPattern());
            }
            if (this.kotlinClientOptions.basePathSeparator() != null) {
                kotlinClientCodegen.setBasePathSeparator(this.kotlinClientOptions.basePathSeparator());
            }
            kotlinClientCodegen.setClientPath(this.kotlinClientOptions.clientPath());
            kotlinClientCodegen.setGeneratedAnnotation(this.kotlinClientOptions.generatedAnnotation());
            kotlinClientCodegen.setConfigureAuthorization(this.kotlinClientOptions.useAuth());
            kotlinClientCodegen.setPlural(this.kotlinClientOptions.plural());
            kotlinClientCodegen.setFluxForArrays(this.kotlinClientOptions.fluxForArrays());
            kotlinClientCodegen.setKsp(this.kotlinClientOptions.ksp());
        }
    }

    public static MicronautCodeGeneratorBuilder builder() {
        return new DefaultBuilder();
    }

    private record Options(MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage lang, String apiPackage, String modelPackage, String invokerPackage, String artifactId, boolean useJakartaEe, List<ParameterMapping> parameterMappings, List<ResponseBodyMapping> responseBodyMappings, Map<String, String> schemaMapping, Map<String, String> importMapping, Map<String, String> nameMapping, Map<String, String> typeMapping, Map<String, String> enumNameMapping, Map<String, String> modelNameMapping, Map<String, String> inlineSchemaNameMapping, Map<String, String> inlineSchemaOption, Map<String, String> openapiNormalizer, String apiNamePrefix, String apiNameSuffix, String modelNamePrefix, String modelNameSuffix, boolean implicitHeaders, String implicitHeadersRegex, boolean beanValidation, boolean useEnumCaseInsensitive, boolean optional, boolean reactive, boolean useOneOfInterfaces, boolean generateHttpResponseAlways, boolean generateHttpResponseWhereRequired, boolean generateSwaggerAnnotations, TestFramework testFramework, SerializationLibraryKind serializationLibraryKind, MicronautCodeGeneratorOptionsBuilder.DateTimeFormat dateTimeFormat, List<String> additionalEnumTypeAnnotations, List<String> additionalModelTypeAnnotations, List<String> additionalOneOfTypeAnnotations, Map<String, Object> additionalProperties, boolean sortParamsByRequiredFlag, boolean skipOperationExample, boolean skipSortingOperations, String removeOperationIdPrefixDelimiter, int removeOperationIdPrefixCount, boolean sortModelPropertiesByRequiredFlag, boolean ensureUniqueParams, boolean allowUnicodeIdentifiers, boolean prependFormOrBodyParameters) {
    }

    public static enum OutputKind {
        MODELS("models", DefaultBuilder.HAS_OUTPUT),
        MODEL_TESTS("modelTests", DefaultBuilder.HAS_OUTPUT),
        MODEL_DOCS("modelDocs", DefaultBuilder.HAS_OUTPUT),
        APIS("apis", DefaultBuilder.HAS_OUTPUT),
        API_TESTS("apiTests", DefaultBuilder.HAS_OUTPUT),
        API_DOCS("apiDocs", DefaultBuilder.HAS_OUTPUT),
        SUPPORTING_FILES("supportingFiles", DefaultBuilder.HAS_OUTPUT);

        private final String generatorProperty;
        private final Consumer<DefaultBuilder> validationAction;

        private OutputKind(String generatorProperty, Consumer<DefaultBuilder> validationAction) {
            this.generatorProperty = generatorProperty;
            this.validationAction = validationAction;
        }

        public static OutputKind of(String name) {
            for (OutputKind kind : OutputKind.values()) {
                if (!kind.name().equals(name) && !kind.generatorProperty.equals(name)) continue;
                return kind;
            }
            throw new IllegalArgumentException("Unknown output kind '" + name + "'");
        }

        public String getGeneratorProperty() {
            return this.generatorProperty;
        }
    }

    public static enum TestFramework {
        JUNIT5("junit"),
        SPOCK("spock");

        private final String value;

        private TestFramework(String value) {
            this.value = value;
        }
    }

    private static class DefaultBuilder
    implements MicronautCodeGeneratorBuilder {
        private static final Consumer<DefaultBuilder> HAS_OUTPUT = b -> Objects.requireNonNull(b.outputDirectory, "Sources directory must not be null");
        private Options options;
        private DefaultCodegen codeGenerator;
        private URI definitionFile;
        private File outputDirectory;
        private final EnumSet<OutputKind> outputs = EnumSet.noneOf(OutputKind.class);
        private JavaMicronautServerCodegen.ServerOptions javaServerOptions;
        private JavaMicronautClientCodegen.ClientOptions javaClientOptions;
        private KotlinMicronautServerCodegen.ServerOptions kotlinServerOptions;
        private KotlinMicronautClientCodegen.ClientOptions kotlinClientOptions;

        private DefaultBuilder() {
        }

        @Override
        public <B extends GeneratorOptionsBuilder, G extends MicronautCodeGenerator<B>> MicronautCodeGeneratorBuilder forCodeGenerator(G generator, Consumer<? super B> configuration) {
            this.codeGenerator = (DefaultCodegen)((Object)generator);
            B builder = generator.optionsBuilder();
            configuration.accept(builder);
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forJavaClient(Consumer<? super JavaMicronautClientOptionsBuilder> clientOptionsSpec) {
            this.codeGenerator = new JavaMicronautClientCodegen();
            JavaMicronautClientCodegen.DefaultClientOptionsBuilder clientOptionsBuilder = new JavaMicronautClientCodegen.DefaultClientOptionsBuilder();
            clientOptionsSpec.accept(clientOptionsBuilder);
            this.javaClientOptions = clientOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forJavaServer(Consumer<? super JavaMicronautServerOptionsBuilder> serverOptionsSpec) {
            this.codeGenerator = new JavaMicronautServerCodegen();
            JavaMicronautServerCodegen.DefaultServerOptionsBuilder serverOptionsBuilder = new JavaMicronautServerCodegen.DefaultServerOptionsBuilder();
            serverOptionsSpec.accept(serverOptionsBuilder);
            this.javaServerOptions = serverOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forKotlinClient(Consumer<? super KotlinMicronautClientOptionsBuilder> clientOptionsSpec) {
            this.codeGenerator = new KotlinMicronautClientCodegen();
            KotlinMicronautClientCodegen.DefaultClientOptionsBuilder clientOptionsBuilder = new KotlinMicronautClientCodegen.DefaultClientOptionsBuilder();
            clientOptionsSpec.accept(clientOptionsBuilder);
            this.kotlinClientOptions = clientOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder forKotlinServer(Consumer<? super KotlinMicronautServerOptionsBuilder> serverOptionsSpec) {
            this.codeGenerator = new KotlinMicronautServerCodegen();
            KotlinMicronautServerCodegen.DefaultServerOptionsBuilder serverOptionsBuilder = new KotlinMicronautServerCodegen.DefaultServerOptionsBuilder();
            serverOptionsSpec.accept(serverOptionsBuilder);
            this.kotlinServerOptions = serverOptionsBuilder.build();
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withDefinitionFile(URI definitionFile) {
            this.definitionFile = definitionFile;
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOutputDirectory(File outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOutputs(OutputKind ... elements) {
            this.outputs.addAll(Arrays.asList(elements));
            return this;
        }

        @Override
        public MicronautCodeGeneratorBuilder withOptions(Consumer<? super MicronautCodeGeneratorOptionsBuilder> optionsConfigurer) {
            DefaultOptionsBuilder builder = new DefaultOptionsBuilder();
            optionsConfigurer.accept(builder);
            this.options = builder.build();
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.definitionFile, "OpenAPI definition file must not be null");
            Objects.requireNonNull(this.codeGenerator, "You must select either server or client generation");
            for (OutputKind output : this.outputs) {
                output.validationAction.accept(this);
            }
        }

        @Override
        public MicronautCodeGeneratorEntryPoint build() {
            this.validate();
            return new MicronautCodeGeneratorEntryPoint(this.definitionFile, this.outputDirectory, this.codeGenerator, this.outputs, this.options, this.javaServerOptions, this.javaClientOptions, this.kotlinServerOptions, this.kotlinClientOptions);
        }

        private static class DefaultOptionsBuilder
        implements MicronautCodeGeneratorOptionsBuilder {
            private String apiPackage;
            private String artifactId;
            private boolean useJakartaEe = true;
            private boolean beanValidation = true;
            private boolean useEnumCaseInsensitive;
            private String invokerPackage;
            private String modelPackage;
            private List<ParameterMapping> parameterMappings;
            private List<ResponseBodyMapping> responseBodyMappings;
            private Map<String, String> schemaMapping;
            private Map<String, String> importMapping;
            private Map<String, String> nameMapping;
            private Map<String, String> typeMapping;
            private Map<String, String> enumNameMapping;
            private Map<String, String> modelNameMapping;
            private Map<String, String> inlineSchemaNameMapping;
            private Map<String, String> inlineSchemaOption;
            private Map<String, String> openapiNormalizer;
            private String apiNamePrefix;
            private String apiNameSuffix;
            private String modelNamePrefix;
            private String modelNameSuffix;
            private boolean implicitHeaders;
            private String implicitHeadersRegex;
            private boolean optional;
            private boolean reactive = true;
            private boolean useOneOfInterfaces = true;
            private boolean generateHttpResponseAlways;
            private boolean generateHttpResponseWhereRequired = true;
            private boolean generateSwaggerAnnotations;
            private TestFramework testFramework = TestFramework.JUNIT5;
            private SerializationLibraryKind serializationLibraryKind = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON;
            private MicronautCodeGeneratorOptionsBuilder.DateTimeFormat dateTimeFormat = MicronautCodeGeneratorOptionsBuilder.DateTimeFormat.ZONED_DATETIME;
            private MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage lang = MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage.JAVA;
            private List<String> additionalEnumTypeAnnotations;
            private List<String> additionalModelTypeAnnotations;
            private List<String> additionalOneOfTypeAnnotations;
            private Map<String, Object> additionalProperties;
            private boolean sortParamsByRequiredFlag = true;
            private boolean skipOperationExample;
            private boolean skipSortingOperations;
            private String removeOperationIdPrefixDelimiter = "_";
            private int removeOperationIdPrefixCount = 1;
            private boolean sortModelPropertiesByRequiredFlag = true;
            private boolean ensureUniqueParams = true;
            private boolean allowUnicodeIdentifiers;
            private boolean prependFormOrBodyParameters;

            private DefaultOptionsBuilder() {
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withLang(MicronautCodeGeneratorOptionsBuilder.GeneratorLanguage lang) {
                this.lang = lang;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withApiPackage(String apiPackage) {
                this.apiPackage = apiPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withInvokerPackage(String invokerPackage) {
                this.invokerPackage = invokerPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withModelPackage(String modelPackage) {
                this.modelPackage = modelPackage;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withArtifactId(String artifactId) {
                this.artifactId = artifactId;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withParameterMappings(List<ParameterMapping> parameterMappings) {
                this.parameterMappings = parameterMappings;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withResponseBodyMappings(List<ResponseBodyMapping> responseBodyMappings) {
                this.responseBodyMappings = responseBodyMappings;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSchemaMapping(Map<String, String> schemaMapping) {
                this.schemaMapping = schemaMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withImportMapping(Map<String, String> importMapping) {
                this.importMapping = importMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withNameMapping(Map<String, String> nameMapping) {
                this.nameMapping = nameMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withTypeMapping(Map<String, String> typeMapping) {
                this.typeMapping = typeMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withEnumNameMapping(Map<String, String> enumNameMapping) {
                this.enumNameMapping = enumNameMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withModelNameMapping(Map<String, String> modelNameMapping) {
                this.modelNameMapping = modelNameMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withInlineSchemaNameMapping(Map<String, String> inlineSchemaNameMapping) {
                this.inlineSchemaNameMapping = inlineSchemaNameMapping;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withInlineSchemaOption(Map<String, String> inlineSchemaOption) {
                this.inlineSchemaOption = inlineSchemaOption;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withOpenapiNormalizer(Map<String, String> openapiNormalizer) {
                this.openapiNormalizer = openapiNormalizer;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withApiNamePrefix(String apiNamePrefix) {
                this.apiNamePrefix = apiNamePrefix;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withApiNameSuffix(String apiNameSuffix) {
                this.apiNameSuffix = apiNameSuffix;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withModelNamePrefix(String modelNamePrefix) {
                this.modelNamePrefix = modelNamePrefix;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withModelNameSuffix(String modelNameSuffix) {
                this.modelNameSuffix = modelNameSuffix;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withImplicitHeaders(boolean implicitHeaders) {
                this.implicitHeaders = implicitHeaders;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withImplicitHeadersRegex(String implicitHeadersRegex) {
                this.implicitHeadersRegex = implicitHeadersRegex;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withReactive(boolean reactive) {
                this.reactive = reactive;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withGenerateHttpResponseAlways(boolean generateHttpResponseAlways) {
                this.generateHttpResponseAlways = generateHttpResponseAlways;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withGenerateHttpResponseWhereRequired(boolean generateHttpResponseWhereRequired) {
                this.generateHttpResponseWhereRequired = generateHttpResponseWhereRequired;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withGenerateSwaggerAnnotations(boolean generateSwaggerAnnotations) {
                this.generateSwaggerAnnotations = generateSwaggerAnnotations;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withBeanValidation(boolean beanValidation) {
                this.beanValidation = beanValidation;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withUseEnumCaseInsensitive(boolean useEnumCaseInsensitive) {
                this.useEnumCaseInsensitive = useEnumCaseInsensitive;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withOptional(boolean optional) {
                this.optional = optional;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withTestFramework(TestFramework testFramework) {
                this.testFramework = testFramework;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSerializationLibrary(SerializationLibraryKind library) {
                this.serializationLibraryKind = library;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withDateTimeFormat(MicronautCodeGeneratorOptionsBuilder.DateTimeFormat format) {
                this.dateTimeFormat = format;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withUseOneOfInterfaces(boolean useOneOfInterfaces) {
                this.useOneOfInterfaces = useOneOfInterfaces;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withAdditionalEnumTypeAnnotations(List<String> additionalEnumTypeAnnotations) {
                this.additionalEnumTypeAnnotations = additionalEnumTypeAnnotations;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withAdditionalModelTypeAnnotations(List<String> additionalModelTypeAnnotations) {
                this.additionalModelTypeAnnotations = additionalModelTypeAnnotations;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withAdditionalOneOfTypeAnnotations(List<String> additionalOneOfTypeAnnotations) {
                this.additionalOneOfTypeAnnotations = additionalOneOfTypeAnnotations;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withAdditionalProperties(Map<String, Object> additionalProperties) {
                this.additionalProperties = additionalProperties;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withUseJakartaEe(boolean useJakartaEe) {
                this.useJakartaEe = useJakartaEe;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSortParamsByRequiredFlag(boolean sortParamsByRequiredFlag) {
                this.sortParamsByRequiredFlag = sortParamsByRequiredFlag;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSkipOperationExample(boolean skipOperationExample) {
                this.skipOperationExample = skipOperationExample;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSkipSortingOperations(boolean skipSortingOperations) {
                this.skipSortingOperations = skipSortingOperations;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withRemoveOperationIdPrefixDelimiter(String removeOperationIdPrefixDelimiter) {
                this.removeOperationIdPrefixDelimiter = removeOperationIdPrefixDelimiter;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withRemoveOperationIdPrefixCount(int removeOperationIdPrefixCount) {
                this.removeOperationIdPrefixCount = removeOperationIdPrefixCount;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withSortModelPropertiesByRequiredFlag(boolean sortModelPropertiesByRequiredFlag) {
                this.sortModelPropertiesByRequiredFlag = sortModelPropertiesByRequiredFlag;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withEnsureUniqueParams(boolean ensureUniqueParams) {
                this.ensureUniqueParams = ensureUniqueParams;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withAllowUnicodeIdentifiers(boolean allowUnicodeIdentifiers) {
                this.allowUnicodeIdentifiers = allowUnicodeIdentifiers;
                return this;
            }

            @Override
            public MicronautCodeGeneratorOptionsBuilder withPrependFormOrBodyParameters(boolean prependFormOrBodyParameters) {
                this.prependFormOrBodyParameters = prependFormOrBodyParameters;
                return this;
            }

            private Options build() {
                return new Options(this.lang, this.apiPackage, this.modelPackage, this.invokerPackage, this.artifactId, this.useJakartaEe, this.parameterMappings, this.responseBodyMappings, this.schemaMapping, this.importMapping, this.nameMapping, this.typeMapping, this.enumNameMapping, this.modelNameMapping, this.inlineSchemaNameMapping, this.inlineSchemaOption, this.openapiNormalizer, this.apiNamePrefix, this.apiNameSuffix, this.modelNamePrefix, this.modelNameSuffix, this.implicitHeaders, this.implicitHeadersRegex, this.beanValidation, this.useEnumCaseInsensitive, this.optional, this.reactive, this.useOneOfInterfaces, this.generateHttpResponseAlways, this.generateHttpResponseWhereRequired, this.generateSwaggerAnnotations, this.testFramework, this.serializationLibraryKind, this.dateTimeFormat, this.additionalEnumTypeAnnotations, this.additionalModelTypeAnnotations, this.additionalOneOfTypeAnnotations, this.additionalProperties, this.sortParamsByRequiredFlag, this.skipOperationExample, this.skipSortingOperations, this.removeOperationIdPrefixDelimiter, this.removeOperationIdPrefixCount, this.sortModelPropertiesByRequiredFlag, this.ensureUniqueParams, this.allowUnicodeIdentifiers, this.prependFormOrBodyParameters);
            }
        }
    }
}

