/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.samskivert.mustache.Mustache;
import io.micronaut.openapi.generator.Formatting;
import io.micronaut.openapi.generator.GeneratorOptionsBuilder;
import io.micronaut.openapi.generator.JavaMicronautClientCodegen;
import io.micronaut.openapi.generator.JavaMicronautServerCodegen;
import io.micronaut.openapi.generator.MicronautCodeGenerator;
import io.micronaut.openapi.generator.MicronautInlineModelResolver;
import io.micronaut.openapi.generator.ParameterMapping;
import io.micronaut.openapi.generator.ResponseBodyMapping;
import io.micronaut.openapi.generator.SerializationLibraryKind;
import io.micronaut.openapi.generator.Utils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.io.File;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.atteo.evo.inflector.English;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenDiscriminator;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenModelFactory;
import org.openapitools.codegen.CodegenModelType;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenResponse;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.VendorExtension;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.languages.AbstractJavaCodegen;
import org.openapitools.codegen.languages.features.BeanValidationFeatures;
import org.openapitools.codegen.languages.features.OptionalFeatures;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.OnceLogger;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMicronautJavaCodegen<T extends GeneratorOptionsBuilder>
extends AbstractJavaCodegen
implements BeanValidationFeatures,
OptionalFeatures,
MicronautCodeGenerator<T> {
    public static final String OPT_TITLE = "title";
    public static final String OPT_TEST = "test";
    public static final String OPT_TEST_JUNIT = "junit";
    public static final String OPT_TEST_SPOCK = "spock";
    public static final String OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR = "requiredPropertiesInConstructor";
    public static final String OPT_USE_AUTH = "useAuth";
    public static final String OPT_USE_LOMBOK = "lombok";
    public static final String OPT_GENERATE_ENUM_CONVERTERS = "generateEnumConverters";
    public static final String OPT_NO_ARGS_CONSTRUCTOR = "noArgsConstructor";
    public static final String OPT_USE_PLURAL = "plural";
    public static final String OPT_FLUX_FOR_ARRAYS = "fluxForArrays";
    public static final String OPT_GENERATED_ANNOTATION = "generatedAnnotation";
    public static final String OPT_VISITABLE = "visitable";
    public static final String OPT_DATE_LIBRARY_ZONED_DATETIME = "ZONED_DATETIME";
    public static final String OPT_DATE_LIBRARY_OFFSET_DATETIME = "OFFSET_DATETIME";
    public static final String OPT_DATE_LIBRARY_LOCAL_DATETIME = "LOCAL_DATETIME";
    public static final String OPT_DATE_FORMAT = "dateFormat";
    public static final String OPT_DATE_TIME_FORMAT = "dateTimeFormat";
    public static final String OPT_USE_ENUM_CASE_INSENSITIVE = "useEnumCaseInsensitive";
    public static final String OPT_REACTIVE = "reactive";
    public static final String OPT_USE_SEALED = "useSealed";
    public static final String OPT_USE_TAGS = "useTags";
    public static final String OPT_GENERATE_HTTP_RESPONSE_ALWAYS = "generateHttpResponseAlways";
    public static final String OPT_GENERATE_CONTROLLER_AS_ABSTRACT = "generateControllerAsAbstract";
    public static final String OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED = "generateHttpResponseWhereRequired";
    public static final String OPT_APPLICATION_NAME = "applicationName";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS = "generateSwaggerAnnotations";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_1 = "swagger1";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2 = "swagger2";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE = "true";
    public static final String OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE = "false";
    public static final String OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG = "generateOperationOnlyForFirstTag";
    public static final String OPT_SKIP_SORTING_OPERATIONS = "skipSortingOperations";
    public static final String OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS = "jsonIncludeAlwaysForRequiredFields";
    public static final String CONTENT_TYPE_APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_APPLICATION_JSON = "application/json";
    public static final String CONTENT_TYPE_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String CONTENT_TYPE_ANY = "*/*";
    private static final String MONO_CLASS_NAME = "reactor.core.publisher.Mono";
    private static final String FLUX_CLASS_NAME = "reactor.core.publisher.Flux";
    protected SecureRandom random = new SecureRandom();
    protected String title;
    protected boolean useOptional;
    protected boolean visitable;
    protected boolean lombok;
    protected boolean generateEnumConverters = true;
    protected boolean noArgsConstructor;
    protected boolean fluxForArrays;
    protected boolean useTags = true;
    protected boolean plural = true;
    protected boolean generatedAnnotation = true;
    protected String testTool;
    protected boolean requiredPropertiesInConstructor = true;
    protected boolean reactive;
    protected boolean useSealed;
    protected boolean useEnumCaseInsensitive;
    protected boolean generateHttpResponseAlways;
    protected boolean generateHttpResponseWhereRequired = true;
    protected boolean generateControllerAsAbstract;
    protected boolean jsonIncludeAlwaysForRequiredFields;
    protected String appName;
    protected String dateFormat;
    protected String dateTimeFormat;
    protected String generateSwaggerAnnotations;
    protected boolean generateOperationOnlyForFirstTag;
    protected String serializationLibrary = SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name();
    protected List<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>();
    protected List<ResponseBodyMapping> responseBodyMappings = new ArrayList<ResponseBodyMapping>();
    protected Map<String, CodegenModel> allModels = new HashMap<String, CodegenModel>();
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    protected AbstractMicronautJavaCodegen() {
        this.useBeanValidation = true;
        this.useJakartaEe = true;
        this.useOptional = false;
        this.visitable = false;
        this.testTool = OPT_TEST_JUNIT;
        this.outputFolder = this instanceof JavaMicronautClientCodegen ? "generated-code/java-micronaut-client" : "generated-code/java-micronaut";
        this.apiPackage = "org.openapitools.api";
        this.modelPackage = "org.openapitools.model";
        this.invokerPackage = "org.openapitools";
        this.artifactId = this instanceof JavaMicronautClientCodegen ? "openapi-micronaut-client" : "openapi-micronaut";
        this.templateDir = "templates/java-micronaut";
        this.embeddedTemplateDir = "templates/java-micronaut";
        this.apiDocPath = "docs/apis";
        this.modelDocPath = "docs/models";
        this.dateLibrary = OPT_DATE_LIBRARY_ZONED_DATETIME;
        this.reactive = true;
        this.appName = this.artifactId;
        this.generateSwaggerAnnotations = this instanceof JavaMicronautClientCodegen ? OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE : OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
        this.generateOperationOnlyForFirstTag = this instanceof JavaMicronautServerCodegen;
        this.openApiNullable = false;
        this.useOneOfInterfaces = true;
        this.inlineSchemaOption.put("RESOLVE_INLINE_ENUMS", OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE);
        this.languageSpecificPrimitives.addAll(Set.of("char", "float", "double", "byte", "short", "int", "long", "Byte", "Short", "Character"));
        this.typeMapping.put("char", "Character");
        this.typeMapping.put("byte", "Byte");
        GlobalSettings.setProperty((String)"divideOperationsByContentType", (String)OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE);
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.of(SecurityFeature.ApiKey, new SecurityFeature[]{SecurityFeature.BearerToken, SecurityFeature.BasicAuth, SecurityFeature.OAuth2_Implicit, SecurityFeature.OAuth2_AuthorizationCode, SecurityFeature.OAuth2_ClientCredentials, SecurityFeature.OAuth2_Password, SecurityFeature.OpenIDConnect, SecurityFeature.SignatureAuth, SecurityFeature.AWSV4Signature})));
        this.additionalProperties.put("useOneOfInterfaces", this.useOneOfInterfaces);
        this.additionalProperties.put("openbrace", "{");
        this.additionalProperties.put("closebrace", "}");
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.cliOptions.add(new CliOption(OPT_TITLE, "Client service name").defaultValue(this.title));
        this.cliOptions.add(new CliOption(OPT_APPLICATION_NAME, "Micronaut application name (Defaults to the artifactId value)").defaultValue(this.appName));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_LOMBOK, (String)"Whether or not to use lombok annotations in generated code", (boolean)this.lombok));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_ENUM_CONVERTERS, (String)"Generate or not custom enum converters for enum query values and path variables", (boolean)this.generateEnumConverters));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_NO_ARGS_CONSTRUCTOR, (String)"Generate or not no-args constructor for each POJO", (boolean)this.noArgsConstructor));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_PLURAL, (String)"Whether or not to use plural for request body parameter name", (boolean)this.plural));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_FLUX_FOR_ARRAYS, (String)"Whether or not to use Flux<?> instead Mono<List<?>> for arrays in generated code", (boolean)this.fluxForArrays));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATED_ANNOTATION, (String)"Generate code with \"@Generated\" annotation", (boolean)this.generatedAnnotation));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_TAGS, (String)"Whether to use tags for creating interface and controller class names", (boolean)this.useTags));
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations", (boolean)this.useBeanValidation));
        this.cliOptions.add(CliOption.newBoolean((String)"useOptional", (String)"Use Optional container for optional parameters", (boolean)this.useOptional));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_VISITABLE, (String)"Generate visitor for subtypes with a discriminator", (boolean)this.visitable));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, (String)"Allow only to create models with all the required properties provided in constructor", (boolean)this.requiredPropertiesInConstructor));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_REACTIVE, (String)"Make the responses use Reactor Mono as wrapper", (boolean)this.reactive));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_SEALED, (String)"Whether to generate sealed model interfaces and classes", (boolean)this.useSealed));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_ALWAYS, (String)"Always wrap the operations response in HttpResponse object", (boolean)this.generateHttpResponseAlways));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_CONTROLLER_AS_ABSTRACT, (String)"If true, then controller interface will be without @Controller annotation", (boolean)this.generateControllerAsAbstract));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, (String)"Wrap the operations response in HttpResponse object where non-200 HTTP status codes or additional headers are defined", (boolean)this.generateHttpResponseWhereRequired));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, (String)"When false, the operation method will be duplicated in each of the tags if multiple tags are assigned to this operation. If true, each operation will be generated only once in the first assigned tag.", (boolean)this.generateOperationOnlyForFirstTag));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_ENUM_CASE_INSENSITIVE, (String)"Use `equalsIgnoreCase` when String for enum comparison", (boolean)this.useEnumCaseInsensitive));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS, (String)"If set to true, @JsonInclude annotation will be with value ALWAYS for required properties in POJO's", (boolean)this.jsonIncludeAlwaysForRequiredFields));
        CliOption testToolOption = new CliOption(OPT_TEST, "Specify which test tool to generate files for").defaultValue(this.testTool);
        HashMap<String, String> testToolOptionMap = new HashMap<String, String>();
        testToolOptionMap.put(OPT_TEST_JUNIT, "Use JUnit as test tool");
        testToolOptionMap.put(OPT_TEST_SPOCK, "Use Spock as test tool");
        testToolOption.setEnum(testToolOptionMap);
        this.cliOptions.add(testToolOption);
        CliOption generateSwaggerAnnotationsOption = new CliOption(OPT_GENERATE_SWAGGER_ANNOTATIONS, "Specify if you want to generate swagger annotations and which version").defaultValue(this.generateSwaggerAnnotations);
        HashMap<String, String> generateSwaggerAnnotationsOptionMap = new HashMap<String, String>();
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2, "Use io.swagger.core.v3:swagger-annotations for annotating operations and schemas");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_TRUE, "Equivalent to \"swagger2\"");
        generateSwaggerAnnotationsOptionMap.put(OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE, "Do not generate swagger annotations");
        generateSwaggerAnnotationsOption.setEnum(generateSwaggerAnnotationsOptionMap);
        this.cliOptions.add(generateSwaggerAnnotationsOption);
        this.cliOptions.add(new CliOption(OPT_DATE_FORMAT, "Specify the format pattern of date as a string"));
        this.cliOptions.add(new CliOption(OPT_DATE_TIME_FORMAT, "Specify the format pattern of date-time as a string"));
        this.cliOptions.stream().filter(o -> o.getOpt().equals("dateLibrary")).findFirst().ifPresent(opt -> {
            HashMap<String, String> valuesEnum = new HashMap<String, String>();
            valuesEnum.put(OPT_DATE_LIBRARY_OFFSET_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_OFFSET_DATETIME));
            valuesEnum.put(OPT_DATE_LIBRARY_LOCAL_DATETIME, (String)opt.getEnum().get(OPT_DATE_LIBRARY_LOCAL_DATETIME));
            opt.setEnum(valuesEnum);
        });
        CliOption serializationLibraryOpt = CliOption.newString((String)"serializationLibrary", (String)"Serialization library for model");
        serializationLibraryOpt.defaultValue(SerializationLibraryKind.JACKSON.name());
        HashMap<String, String> serializationLibraryOptions = new HashMap<String, String>();
        serializationLibraryOptions.put(SerializationLibraryKind.JACKSON.name(), "Jackson as serialization library");
        serializationLibraryOptions.put(SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name(), "Use micronaut-serialization with Jackson annotations");
        serializationLibraryOpt.setEnum(serializationLibraryOptions);
        this.cliOptions.add(serializationLibraryOpt);
        List<String> micronautReservedWords = List.of("Object", "List", "File", "OffsetDateTime", "LocalDate", "LocalTime", "Client", "Format", "QueryValue", "QueryParam", "PathVariable", "Header", "Cookie", "Authorization", "Body", "Application");
        this.reservedWords.addAll(micronautReservedWords);
        List.of("object", "list", "file", "offsetdatetime", "localdate", "localtime").forEach(this.reservedWords::remove);
        this.importMapping.put("DateTime", "java.time.Instant");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("ZonedDateTime", "java.time.ZonedDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("Function", "java.util.function.Function");
        this.importMapping.put("MultiValuesConverterFactory", "static io.micronaut.core.convert.converters.MultiValuesConverterFactory.*");
    }

    public void setGenerateHttpResponseAlways(boolean generateHttpResponseAlways) {
        this.generateHttpResponseAlways = generateHttpResponseAlways;
    }

    public void setGenerateControllerAsAbstract(boolean generateControllerAsAbstract) {
        this.generateControllerAsAbstract = generateControllerAsAbstract;
    }

    public void setGenerateHttpResponseWhereRequired(boolean generateHttpResponseWhereRequired) {
        this.generateHttpResponseWhereRequired = generateHttpResponseWhereRequired;
    }

    public void setReactive(boolean reactive) {
        this.reactive = reactive;
    }

    public void setUseSealed(boolean useSealed) {
        this.useSealed = useSealed;
    }

    public void setTestTool(String testTool) {
        this.testTool = testTool;
    }

    public void setArtifactId(String artifactId) {
        super.setArtifactId(artifactId);
        this.updateOption("artifactId", artifactId);
    }

    public void setModelPackage(String modelPackage) {
        super.setModelPackage(modelPackage);
        this.updateOption("modelPackage", modelPackage);
    }

    public void setApiPackage(String apiPackage) {
        super.setApiPackage(apiPackage);
        this.updateOption("apiPackage", apiPackage);
    }

    public void setApiNamePrefix(String apiNamePrefix) {
        super.setApiNamePrefix(apiNamePrefix);
        this.updateOption("apiNamePrefix", apiNamePrefix);
    }

    public void setApiNameSuffix(String apiNameSuffix) {
        super.setApiNameSuffix(apiNameSuffix);
        this.updateOption("apiNameSuffix", apiNameSuffix);
    }

    public void setModelNamePrefix(String modelNamePrefix) {
        super.setModelNamePrefix(modelNamePrefix);
        this.updateOption("modelNamePrefix", modelNamePrefix);
    }

    public void setModelNameSuffix(String modelNameSuffix) {
        super.setModelNameSuffix(modelNameSuffix);
        this.updateOption("modelNameSuffix", modelNameSuffix);
    }

    public void setInvokerPackage(String invokerPackage) {
        super.setInvokerPackage(invokerPackage);
        this.updateOption("invokerPackage", this.getInvokerPackage());
    }

    public void setLombok(boolean lombok) {
        this.lombok = lombok;
    }

    public void setGenerateEnumConverters(boolean generateEnumConverters) {
        this.generateEnumConverters = generateEnumConverters;
    }

    public void setUseTags(boolean useTags) {
        this.useTags = useTags;
    }

    public void setGenerateOperationOnlyForFirstTag(boolean generateOperationOnlyForFirstTag) {
        this.generateOperationOnlyForFirstTag = generateOperationOnlyForFirstTag;
    }

    public void setNoArgsConstructor(boolean noArgsConstructor) {
        this.noArgsConstructor = noArgsConstructor;
    }

    public void setPlural(boolean plural) {
        this.plural = plural;
    }

    public void setFluxForArrays(boolean fluxForArrays) {
        this.fluxForArrays = fluxForArrays;
    }

    public void setGeneratedAnnotation(boolean generatedAnnotation) {
        this.generatedAnnotation = generatedAnnotation;
    }

    public void processOpts() {
        if (this.additionalProperties.containsKey("additionalModelTypeAnnotations")) {
            this.setAdditionalModelTypeAnnotations(Utils.readListOfStringsProperty("additionalModelTypeAnnotations", this.additionalProperties));
            this.additionalProperties.remove("additionalModelTypeAnnotations");
        }
        if (this.additionalProperties.containsKey("additionalOneOfTypeAnnotations")) {
            this.setAdditionalOneOfTypeAnnotations(Utils.readListOfStringsProperty("additionalOneOfTypeAnnotations", this.additionalProperties));
            this.additionalProperties.remove("additionalOneOfTypeAnnotations");
        }
        if (this.additionalProperties.containsKey("additionalEnumTypeAnnotations")) {
            this.setAdditionalEnumTypeAnnotations(Utils.readListOfStringsProperty("additionalEnumTypeAnnotations", this.additionalProperties));
            this.additionalProperties.remove("additionalEnumTypeAnnotations");
        }
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_TITLE)) {
            this.title = (String)this.additionalProperties.get(OPT_TITLE);
        }
        if (this.additionalProperties.containsKey("invokerPackage")) {
            this.invokerPackage = (String)this.additionalProperties.get("invokerPackage");
        } else {
            this.additionalProperties.put("invokerPackage", this.invokerPackage);
        }
        if (this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = (String)this.additionalProperties.get("apiPackage");
        } else {
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = (String)this.additionalProperties.get("modelPackage");
        } else {
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        if (this.additionalProperties.containsKey(OPT_APPLICATION_NAME)) {
            this.appName = (String)this.additionalProperties.get(OPT_APPLICATION_NAME);
        } else {
            this.additionalProperties.put(OPT_APPLICATION_NAME, this.artifactId);
        }
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.useBeanValidation = this.convertPropertyToBoolean("useBeanValidation");
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        if (this.additionalProperties.containsKey(OPT_USE_TAGS)) {
            this.useTags = this.convertPropertyToBoolean(OPT_USE_TAGS);
        }
        this.writePropertyBack(OPT_USE_TAGS, this.useTags);
        if (this.additionalProperties.containsKey(OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS)) {
            this.jsonIncludeAlwaysForRequiredFields = this.convertPropertyToBoolean(OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS);
        }
        this.writePropertyBack(OPT_JSON_INCLUDE_ALWAYS_FOR_REQUIRED_FIELDS, this.jsonIncludeAlwaysForRequiredFields);
        if (this.additionalProperties.containsKey(OPT_USE_LOMBOK)) {
            this.lombok = this.convertPropertyToBoolean(OPT_USE_LOMBOK);
        }
        this.writePropertyBack(OPT_USE_LOMBOK, this.lombok);
        if (this.additionalProperties.containsKey(OPT_GENERATE_ENUM_CONVERTERS)) {
            this.generateEnumConverters = this.convertPropertyToBoolean(OPT_GENERATE_ENUM_CONVERTERS);
        }
        this.writePropertyBack(OPT_GENERATE_ENUM_CONVERTERS, this.generateEnumConverters);
        if (this.additionalProperties.containsKey(OPT_NO_ARGS_CONSTRUCTOR)) {
            this.noArgsConstructor = this.convertPropertyToBoolean(OPT_NO_ARGS_CONSTRUCTOR);
        }
        this.writePropertyBack(OPT_NO_ARGS_CONSTRUCTOR, this.noArgsConstructor);
        if (this.additionalProperties.containsKey(OPT_USE_PLURAL)) {
            this.plural = this.convertPropertyToBoolean(OPT_USE_PLURAL);
        }
        this.writePropertyBack(OPT_USE_PLURAL, this.plural);
        if (this.additionalProperties.containsKey(OPT_FLUX_FOR_ARRAYS)) {
            this.fluxForArrays = this.convertPropertyToBoolean(OPT_FLUX_FOR_ARRAYS);
        }
        this.writePropertyBack(OPT_FLUX_FOR_ARRAYS, this.fluxForArrays);
        if (this.additionalProperties.containsKey(OPT_USE_ENUM_CASE_INSENSITIVE)) {
            this.useEnumCaseInsensitive = this.convertPropertyToBoolean(OPT_USE_ENUM_CASE_INSENSITIVE);
        }
        this.writePropertyBack(OPT_USE_ENUM_CASE_INSENSITIVE, this.useEnumCaseInsensitive);
        if (this.additionalProperties.containsKey(OPT_GENERATED_ANNOTATION)) {
            this.generatedAnnotation = this.convertPropertyToBoolean(OPT_GENERATED_ANNOTATION);
        }
        this.writePropertyBack(OPT_GENERATED_ANNOTATION, this.generatedAnnotation);
        if (this.additionalProperties.containsKey("useOptional")) {
            this.useOptional = this.convertPropertyToBoolean("useOptional");
        }
        this.writePropertyBack("useOptional", this.useOptional);
        if (this.additionalProperties.containsKey(OPT_VISITABLE)) {
            this.visitable = this.convertPropertyToBoolean(OPT_VISITABLE);
        }
        this.writePropertyBack(OPT_VISITABLE, this.visitable);
        if (this.additionalProperties.containsKey(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR)) {
            this.requiredPropertiesInConstructor = this.convertPropertyToBoolean(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR);
        }
        this.writePropertyBack(OPT_REQUIRED_PROPERTIES_IN_CONSTRUCTOR, this.requiredPropertiesInConstructor);
        if (this.additionalProperties.containsKey(OPT_REACTIVE)) {
            this.reactive = this.convertPropertyToBoolean(OPT_REACTIVE);
        }
        this.writePropertyBack(OPT_REACTIVE, this.reactive);
        if (this.additionalProperties.containsKey(OPT_USE_SEALED)) {
            this.useSealed = this.convertPropertyToBoolean(OPT_USE_SEALED);
        }
        this.writePropertyBack(OPT_USE_SEALED, this.useSealed);
        if (this.additionalProperties.containsKey(OPT_DATE_FORMAT)) {
            this.dateFormat = (String)this.additionalProperties.get(OPT_DATE_FORMAT);
        }
        this.writePropertyBack(OPT_DATE_FORMAT, this.dateFormat);
        if (this.additionalProperties.containsKey(OPT_DATE_TIME_FORMAT)) {
            this.dateTimeFormat = (String)this.additionalProperties.get(OPT_DATE_TIME_FORMAT);
        }
        this.writePropertyBack(OPT_DATE_TIME_FORMAT, this.dateTimeFormat);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_ALWAYS)) {
            this.generateHttpResponseAlways = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_ALWAYS);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_ALWAYS, this.generateHttpResponseAlways);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_ALWAYS)) {
            this.generateHttpResponseAlways = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_ALWAYS);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_ALWAYS, this.generateHttpResponseAlways);
        if (this.additionalProperties.containsKey(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED)) {
            this.generateHttpResponseWhereRequired = this.convertPropertyToBoolean(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED);
        }
        this.writePropertyBack(OPT_GENERATE_HTTP_RESPONSE_WHERE_REQUIRED, this.generateHttpResponseWhereRequired);
        if (this.additionalProperties.containsKey(OPT_GENERATE_CONTROLLER_AS_ABSTRACT)) {
            this.generateControllerAsAbstract = this.convertPropertyToBoolean(OPT_GENERATE_CONTROLLER_AS_ABSTRACT);
        }
        this.writePropertyBack(OPT_GENERATE_CONTROLLER_AS_ABSTRACT, this.generateControllerAsAbstract);
        if (this.additionalProperties.containsKey(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG)) {
            this.generateOperationOnlyForFirstTag = this.convertPropertyToBoolean(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG);
        }
        this.writePropertyBack(OPT_GENERATE_OPERATION_ONLY_FOR_FIRST_TAG, this.generateOperationOnlyForFirstTag);
        if (this.additionalProperties.containsKey("useJakartaEe")) {
            this.setUseJakartaEe(this.convertPropertyToBoolean("useJakartaEe"));
        }
        this.writePropertyBack("useJakartaEe", this.useJakartaEe);
        this.writePropertyBack("javaxPackage", this.useJakartaEe ? "jakarta" : "javax");
        this.convertPropertyToBooleanAndWriteBack(OPT_SKIP_SORTING_OPERATIONS, arg_0 -> this.setSkipSortingOperations(arg_0));
        this.maybeSetTestTool();
        this.writePropertyBack(OPT_TEST, this.testTool);
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.additionalProperties.put("isTestJunit", true);
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.additionalProperties.put("isTestSpock", true);
        }
        this.maybeSetSwagger();
        if (OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2.equals(this.generateSwaggerAnnotations)) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary((String)this.additionalProperties.get("serializationLibrary"));
        }
        this.additionalProperties.put(this.serializationLibrary.toLowerCase(Locale.US), true);
        if (SerializationLibraryKind.MICRONAUT_SERDE_JACKSON.name().equals(this.serializationLibrary)) {
            this.additionalProperties.put(SerializationLibraryKind.JACKSON.name().toLowerCase(Locale.US), true);
        }
        switch (this.dateLibrary) {
            case "OFFSET_DATETIME": {
                this.typeMapping.put("DateTime", "OffsetDateTime");
                this.typeMapping.put("date-time", "OffsetDateTime");
                this.typeMapping.put("date", "LocalDate");
                this.importMapping.put("DateTime", "java.time.OffsetDateTime");
                this.importMapping.put("date-time", "java.time.OffsetDateTime");
                this.importMapping.put("date", "java.time.LocalDate");
                break;
            }
            case "ZONED_DATETIME": {
                this.typeMapping.put("DateTime", "ZonedDateTime");
                this.typeMapping.put("date-time", "ZonedDateTime");
                this.typeMapping.put("date", "LocalDate");
                this.importMapping.put("DateTime", "java.time.ZonedDateTime");
                this.importMapping.put("date-time", "java.time.ZonedDateTime");
                this.importMapping.put("date", "java.time.LocalDate");
                break;
            }
            case "LOCAL_DATETIME": {
                this.typeMapping.put("DateTime", "LocalDateTime");
                this.typeMapping.put("date-time", "LocalDateTime");
                this.typeMapping.put("date", "LocalDate");
                this.importMapping.put("DateTime", "java.time.LocalDateTime");
                this.importMapping.put("date-time", "java.time.LocalDateTime");
                this.importMapping.put("date", "java.time.LocalDate");
                break;
            }
        }
        this.modelDocTemplateFiles.clear();
        this.modelDocTemplateFiles.put("common/doc/model_doc.mustache", ".md");
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("common/model/model.mustache", ".java");
        this.modelTestTemplateFiles.clear();
        if (this.testTool.equals(OPT_TEST_JUNIT)) {
            this.modelTestTemplateFiles.put("common/test/model_test.mustache", ".java");
        } else if (this.testTool.equals(OPT_TEST_SPOCK)) {
            this.modelTestTemplateFiles.put("common/test/model_test.groovy.mustache", ".groovy");
        }
        String resourceFolder = this.projectFolder + "/resources";
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        String apiFolder = (this.sourceFolder + "/" + this.apiPackage()).replace('.', '/');
        String modelFolder = (this.sourceFolder + "/" + this.modelPackage()).replace('.', '/');
        this.additionalProperties.put("invokerFolder", invokerFolder);
        this.additionalProperties.put("resourceFolder", resourceFolder);
        this.additionalProperties.put("apiFolder", apiFolder);
        this.additionalProperties.put("modelFolder", modelFolder);
        this.additionalProperties.put("formatNoEmptyLines", new Formatting.LineFormatter(0));
        this.additionalProperties.put("formatOneEmptyLine", new Formatting.LineFormatter(1));
        this.additionalProperties.put("formatSingleLine", new Formatting.SingleLineFormatter());
        this.additionalProperties.put("indent", new Formatting.IndentFormatter(4));
    }

    public void addParameterMappings(List<ParameterMapping> parameterMappings) {
        this.parameterMappings.addAll(parameterMappings);
    }

    public void addResponseBodyMappings(List<ResponseBodyMapping> responseBodyMappings) {
        this.responseBodyMappings.addAll(responseBodyMappings);
    }

    public void addSchemaMapping(Map<String, String> schemaMapping) {
        this.schemaMapping.putAll(schemaMapping);
    }

    public void addImportMapping(Map<String, String> importMapping) {
        this.importMapping.putAll(importMapping);
    }

    public void addNameMapping(Map<String, String> nameMapping) {
        this.nameMapping.putAll(nameMapping);
    }

    public void addTypeMapping(Map<String, String> typeMapping) {
        this.typeMapping.putAll(typeMapping);
    }

    public void addEnumNameMapping(Map<String, String> enumNameMapping) {
        this.enumNameMapping.putAll(enumNameMapping);
    }

    public void addModelNameMapping(Map<String, String> modelNameMapping) {
        this.modelNameMapping.putAll(modelNameMapping);
    }

    public void addInlineSchemaNameMapping(Map<String, String> inlineSchemaNameMapping) {
        this.inlineSchemaNameMapping.putAll(inlineSchemaNameMapping);
    }

    public void addInlineSchemaOption(Map<String, String> inlineSchemaOption) {
        this.inlineSchemaOption.putAll(inlineSchemaOption);
    }

    public void addOpenapiNormalizer(Map<String, String> openapiNormalizer) {
        this.openapiNormalizer.putAll(openapiNormalizer);
    }

    private void maybeSetSwagger() {
        if (this.additionalProperties.containsKey(OPT_GENERATE_SWAGGER_ANNOTATIONS)) {
            String value;
            switch (value = String.valueOf(this.additionalProperties.get(OPT_GENERATE_SWAGGER_ANNOTATIONS))) {
                case "swagger1": 
                case "swagger2": 
                case "true": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_SWAGGER_2;
                    break;
                }
                case "false": {
                    this.generateSwaggerAnnotations = OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
                    break;
                }
                default: {
                    throw new RuntimeException("Value \"" + value + "\" for the generateSwaggerAnnotations parameter is unsupported or misspelled");
                }
            }
        }
    }

    private void maybeSetTestTool() {
        if (this.additionalProperties.containsKey(OPT_TEST)) {
            switch ((String)this.additionalProperties.get(OPT_TEST)) {
                case "junit": 
                case "spock": {
                    this.testTool = (String)this.additionalProperties.get(OPT_TEST);
                    break;
                }
                default: {
                    throw new RuntimeException("Test tool \"" + String.valueOf(this.additionalProperties.get(OPT_TEST)) + "\" is not supported or misspelled.");
                }
            }
        }
    }

    public String testFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return (this.getOutputDir() + "/src/test/groovy/").replace('/', File.separatorChar);
        }
        return (this.getOutputDir() + "/src/test/java/").replace('/', File.separatorChar);
    }

    public abstract boolean isServer();

    public String apiTestFileFolder() {
        return this.testFileFolder() + this.apiPackage().replace(".", "/");
    }

    public String modelTestFileFolder() {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.getOutputDir() + "/src/test/groovy/" + this.modelPackage().replace('.', File.separatorChar);
        }
        return this.getOutputDir() + "/src/test/java/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String toApiTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toApiName(name) + "Spec";
        }
        return this.toApiName(name) + "Test";
    }

    public String toModelTestFilename(String name) {
        if (this.testTool.equals(OPT_TEST_SPOCK)) {
            return this.toModelName(name) + "Spec";
        }
        return this.toModelName(name) + "Test";
    }

    public CodegenParameter fromRequestBody(RequestBody body, Set<String> imports, String bodyParameterName) {
        CodegenParameter rqBody = super.fromRequestBody(body, imports, bodyParameterName);
        Schema rqBodySchema = body.getContent() != null && !body.getContent().isEmpty() ? ((MediaType)((Map.Entry)body.getContent().entrySet().iterator().next()).getValue()).getSchema() : null;
        CodegenProperty codegenProperty = this.fromProperty(bodyParameterName, rqBodySchema, false);
        if (rqBodySchema != null) {
            rqBodySchema = this.unaliasSchema(rqBodySchema);
            boolean isRequiredBody = body.getRequired() != null && body.getRequired() != false;
            codegenProperty = this.getUseInlineModelResolver() ? this.fromProperty(bodyParameterName, this.getReferencedSchemaWhenNotEnum(rqBodySchema), isRequiredBody) : this.fromProperty(bodyParameterName, rqBodySchema, isRequiredBody);
            rqBody.setSchema(codegenProperty);
        }
        if (Boolean.TRUE.equals(codegenProperty.isModel)) {
            rqBody.isModel = true;
        }
        rqBody.dataFormat = codegenProperty.dataFormat;
        if (body.getRequired() != null) {
            rqBody.required = body.getRequired();
        }
        rqBody.containerType = codegenProperty.containerType;
        rqBody.containerTypeMapped = codegenProperty.containerTypeMapped;
        this.updateCodegenPropertyEnum(codegenProperty);
        rqBody.isEnum = codegenProperty.isEnum;
        rqBody.isEnumRef = codegenProperty.isEnumRef;
        rqBody._enum = codegenProperty._enum;
        rqBody.allowableValues = codegenProperty.allowableValues;
        if (codegenProperty.isEnum || codegenProperty.isEnumRef) {
            rqBody.datatypeWithEnum = codegenProperty.datatypeWithEnum;
            rqBody.enumName = codegenProperty.enumName;
            if (codegenProperty.defaultValue != null) {
                rqBody.enumDefaultValue = codegenProperty.defaultValue.replace(codegenProperty.enumName + ".", "");
            }
        }
        return rqBody;
    }

    private Schema getReferencedSchemaWhenNotEnum(Schema parameterSchema) {
        Schema referencedSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)parameterSchema);
        if (referencedSchema.getEnum() != null && !referencedSchema.getEnum().isEmpty()) {
            referencedSchema = parameterSchema;
        }
        return referencedSchema;
    }

    public CodegenParameter fromParameter(Parameter p, Set<String> imports) {
        CodegenProperty items;
        Schema parameterSchema;
        CodegenParameter parameter = super.fromParameter(p, imports);
        if (parameter.isPathParam && !parameter.required) {
            parameter.required = true;
        }
        this.checkPrimitives((IJsonSchemaValidationProperties)parameter, this.unaliasSchema(p.getSchema()));
        String realName = parameter.paramName;
        if (realName.startsWith("_") && !parameter.baseName.startsWith("_") && this.isReservedWord(parameter.baseName)) {
            realName = realName.replaceFirst("_", "");
        }
        parameter.vendorExtensions.put("realName", realName);
        if (p.getSchema() != null) {
            parameterSchema = this.unaliasSchema(p.getSchema());
        } else if (p.getContent() != null) {
            Content content = p.getContent();
            if (content.size() > 1) {
                OnceLogger.once((Logger)this.log).warn("Multiple schemas found in content, returning only the first one");
            }
            Map.Entry entry = (Map.Entry)content.entrySet().iterator().next();
            parameterSchema = ((MediaType)entry.getValue()).getSchema();
        } else {
            parameterSchema = null;
        }
        if (parameterSchema != null && parameterSchema.get$ref() != null) {
            parameterSchema = (Schema)this.openAPI.getComponents().getSchemas().get(parameterSchema.get$ref().substring("#/components/schemas/".length()));
        }
        Object defaultValueInit = (items = parameter.items) == null ? (String)this.calcDefaultValues(null, null, false, false, false, false, false, false, false, parameterSchema).getLeft() : (String)this.calcDefaultValues(items.datatypeWithEnum, items.dataType, items.getIsEnumOrRef(), parameter.isArray, items.isString, items.isNumeric, items.isFloat, items.isMap, items.isNullable, parameterSchema).getLeft();
        if (parameterSchema != null && ModelUtils.isEnumSchema((Schema)parameterSchema)) {
            defaultValueInit = parameter.dataType + ".fromValue(" + (String)defaultValueInit + ")";
        }
        if (defaultValueInit != null) {
            parameter.vendorExtensions.put("defaultValueInit", defaultValueInit);
        }
        Utils.addStrValueToEnum(parameter.items);
        return parameter;
    }

    public CodegenResponse fromResponse(String responseCode, ApiResponse response) {
        CodegenResponse resp = super.fromResponse(responseCode, response);
        this.checkPrimitives((IJsonSchemaValidationProperties)resp, (Schema)resp.schema);
        return resp;
    }

    public CodegenProperty fromProperty(String name, Schema schema, boolean required, boolean schemaIsFromAdditionalProperties) {
        CodegenProperty items;
        CodegenProperty property = super.fromProperty(name, schema, required, schemaIsFromAdditionalProperties);
        this.checkPrimitives((IJsonSchemaValidationProperties)property, this.unaliasSchema(schema));
        String realName = property.name;
        if (realName.startsWith("_") && !property.baseName.startsWith("_") && this.isReservedWord(property.baseName)) {
            realName = realName.replaceFirst("_", "");
            property.nameInPascalCase = StringUtils.camelize((String)realName);
            property.nameInCamelCase = StringUtils.camelize((String)realName, (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_LETTER);
            property.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, property.nameInCamelCase);
            if (!property.getter.startsWith("get_")) {
                property.getter = "get" + this.getterAndSetterCapitalize(property.name);
            }
            if (!property.setter.startsWith("set_")) {
                property.setter = "set" + this.getterAndSetterCapitalize(property.name);
            }
        }
        property.vendorExtensions.put("realName", realName);
        if (schema != null && schema.get$ref() != null) {
            Schema refSchema = ModelUtils.getSchemaFromRefToSchemaWithProperties((OpenAPI)this.openAPI, (String)schema.get$ref());
            if (refSchema == null) {
                refSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)schema);
            }
            schema = refSchema;
        }
        Object defaultValueInit = (items = property.items) == null ? (String)this.calcDefaultValues(null, null, false, false, false, false, false, false, false, schema).getLeft() : (String)this.calcDefaultValues(items.datatypeWithEnum, items.dataType, items.getIsEnumOrRef(), property.isArray, items.isString, items.isNumeric, items.isFloat, items.isMap, items.isNullable, schema).getLeft();
        if (schema != null && ModelUtils.isEnumSchema((Schema)schema)) {
            String enumVarName = this.toEnumVarName(property.defaultValue, property.dataType);
            defaultValueInit = enumVarName != null ? property.dataType + "." + enumVarName : null;
        }
        if (defaultValueInit != null) {
            property.vendorExtensions.put("defaultValueInit", defaultValueInit);
        }
        return property;
    }

    public String toEnumVarName(String value, String datatype) {
        if (value == null) {
            return null;
        }
        if (this.enumNameMapping.containsKey(value)) {
            return (String)this.enumNameMapping.get(value);
        }
        if (value.isEmpty()) {
            return "EMPTY";
        }
        if (this.getSymbolName(value) != null) {
            return this.getSymbolName(value).toUpperCase(Locale.ROOT);
        }
        if (" ".equals(value)) {
            return "SPACE";
        }
        if ("Int".equalsIgnoreCase(datatype) || "Byte".equalsIgnoreCase(datatype) || "Short".equalsIgnoreCase(datatype) || "Integer".equalsIgnoreCase(datatype) || "Long".equalsIgnoreCase(datatype) || "Float".equalsIgnoreCase(datatype) || "Double".equalsIgnoreCase(datatype) || "BigDecimal".equals(datatype)) {
            Object varName = "NUMBER_" + value;
            varName = ((String)varName).replaceAll("-", "MINUS_");
            varName = ((String)varName).replaceAll("\\+", "PLUS_");
            varName = ((String)varName).replaceAll("\\.", "_DOT_");
            return varName;
        }
        Object var = StringUtils.underscore((String)value.replaceAll("\\W+", "_")).toUpperCase(Locale.ROOT);
        if (((String)var).matches("\\d.*")) {
            var = "_" + (String)var;
        }
        return this.toVarName((String)var);
    }

    public String toDefaultValue(CodegenProperty cp, Schema schema) {
        if (cp.items != null) {
            return (String)this.calcDefaultValues(cp.items.datatypeWithEnum, cp.items.dataType, cp.items.getIsEnumOrRef(), cp.isArray, cp.items.isString, cp.items.isNumeric, cp.items.isFloat, cp.items.isMap, cp.items.isNullable, schema).getRight();
        }
        return (String)this.calcDefaultValues(null, null, false, false, false, false, false, false, false, schema).getRight();
    }

    private Pair<String, String> calcDefaultValues(String itemsDatatypeWithEnum, String itemsDataType, boolean itemsIsEnumOrRef, boolean isArray, boolean itemsIsString, boolean itemsIsNumeric, boolean itemsIsFloat, boolean itemsIsMap, boolean isNullable, Schema schema) {
        Object defaultValueInit = null;
        String defaultValueStr = null;
        if (ModelUtils.isArraySchema((Schema)(schema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)schema)))) {
            if (schema.getDefault() == null) {
                if (isNullable || this.containerDefaultToNull) {
                    return Pair.of(null, null);
                }
                return this.getDefaultCollectionType(schema);
            }
            return this.arrayDefaultValue(itemsDatatypeWithEnum, itemsDataType, itemsIsEnumOrRef, isArray, itemsIsString, itemsIsNumeric, itemsIsFloat, itemsIsMap, schema);
        }
        if (ModelUtils.isMapSchema((Schema)schema) && !ModelUtils.isComposedSchema((Schema)schema)) {
            if (schema.getProperties() != null && !schema.getProperties().isEmpty() && schema.getDefault() != null) {
                defaultValueInit = super.toDefaultValue(schema);
                defaultValueStr = super.toDefaultValue(schema);
            }
            if (isNullable || this.containerDefaultToNull) {
                return Pair.of(null, null);
            }
            if (ModelUtils.getAdditionalProperties((Schema)schema) == null) {
                return Pair.of(null, null);
            }
            defaultValueInit = String.format(Locale.ROOT, "new %s<>()", this.instantiationTypes().getOrDefault("map", "HashMap"));
            defaultValueStr = null;
        } else if (ModelUtils.isIntegerSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = "int64".equals(schema.getFormat()) ? schema.getDefault().toString() + "L" : schema.getDefault().toString();
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isNumberSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = "float".equals(schema.getFormat()) ? schema.getDefault().toString() + "F" : ("double".equals(schema.getFormat()) ? schema.getDefault().toString() + "D" : "new BigDecimal(\"" + schema.getDefault().toString() + "\")");
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isBooleanSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = schema.getDefault().toString();
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isDateSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                Date date = (Date)schema.getDefault();
                LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                defaultValueInit = "LocalDate.parse(\"%s\")".formatted(localDate.toString());
                defaultValueStr = localDate.toString();
            }
        } else if (ModelUtils.isDateTimeSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                OffsetDateTime offsetDateTime = (OffsetDateTime)schema.getDefault();
                switch (this.dateLibrary) {
                    case "OFFSET_DATETIME": {
                        defaultValueInit = "OffsetDateTime.parse(\"%s\")".formatted(offsetDateTime);
                        defaultValueStr = offsetDateTime.toString();
                        break;
                    }
                    case "ZONED_DATETIME": {
                        ZonedDateTime zonedDateTime = offsetDateTime.toZonedDateTime();
                        defaultValueInit = "ZonedDateTime.parse(\"%s\")".formatted(zonedDateTime);
                        defaultValueStr = zonedDateTime.toString();
                        break;
                    }
                    case "LOCAL_DATETIME": {
                        LocalDateTime localDateTime = offsetDateTime.toLocalDateTime();
                        defaultValueInit = "LocalDateTime.parse(\"%s\")".formatted(localDateTime);
                        defaultValueStr = localDateTime.toString();
                        break;
                    }
                }
            }
        } else if (ModelUtils.isURISchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = "URI.create(\"" + this.escapeText(String.valueOf(schema.getDefault())) + "\")";
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isUUIDSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = "UUID.fromString(\"" + String.valueOf(schema.getDefault()) + "\")";
                defaultValueStr = schema.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                String def = schema.getDefault().toString();
                if (schema.getEnum() == null) {
                    defaultValueInit = "\"" + this.escapeText(def) + "\"";
                    defaultValueStr = this.escapeText(def);
                } else {
                    defaultValueInit = "\"" + def + "\"";
                    defaultValueStr = def;
                }
            }
        } else if (ModelUtils.isObjectSchema((Schema)schema)) {
            if (schema.getDefault() != null) {
                defaultValueInit = super.toDefaultValue(schema);
                defaultValueStr = super.toDefaultValue(schema);
            }
        } else if (ModelUtils.isComposedSchema((Schema)schema) && schema.getDefault() != null) {
            defaultValueInit = super.toDefaultValue(schema);
            defaultValueStr = super.toDefaultValue(schema);
        }
        return Pair.of(defaultValueInit, defaultValueStr);
    }

    public Pair<String, String> arrayDefaultValue(String itemsDatatypeWithEnum, String itemsDataType, boolean itemsIsEnumOrRef, boolean isArray, boolean itemsIsString, boolean itemsIsNumeric, boolean itemsIsFloat, boolean itemsIsMap, Schema schema) {
        if (schema.getDefault() != null) {
            if (isArray) {
                String defaultValue;
                List<Object> values = new ArrayList();
                Object object = schema.getDefault();
                if (object instanceof ArrayNode) {
                    ArrayNode arrayNodeDefault = (ArrayNode)object;
                    if (arrayNodeDefault.isEmpty()) {
                        return this.getDefaultCollectionType(schema);
                    }
                    finalValues = values;
                    arrayNodeDefault.elements().forEachRemaining(element -> finalValues.add(element.asText()));
                } else {
                    finalValues = schema.getDefault();
                    if (finalValues instanceof Collection) {
                        Collection defCollection = finalValues;
                        finalValues = values;
                        defCollection.forEach(element -> finalValues.add(String.valueOf(element)));
                    } else {
                        values = Collections.singletonList(String.valueOf(schema.getDefault()));
                    }
                }
                if (itemsIsEnumOrRef) {
                    ArrayList<CallSite> defaultValues = new ArrayList<CallSite>();
                    for (String string : values) {
                        String enumVarName = this.toEnumVarName(string, itemsDataType);
                        if (enumVarName == null) {
                            defaultValues.add(null);
                            continue;
                        }
                        defaultValues.add((CallSite)((Object)(itemsDatatypeWithEnum + "." + enumVarName)));
                    }
                    defaultValue = org.apache.commons.lang3.StringUtils.join(defaultValues, (String)", ");
                } else if (!values.isEmpty()) {
                    if (itemsIsString) {
                        defaultValueInit = defaultValue = String.format(Locale.ROOT, "\"%s\"", org.apache.commons.lang3.StringUtils.join(values, (String)"\", \""));
                    } else if (itemsIsNumeric) {
                        defaultValue = String.join((CharSequence)", ", values);
                        defaultValueInit = values.stream().map(v -> {
                            if ("BigInteger".equals(itemsDataType)) {
                                return "new BigInteger(\"" + v + "\")";
                            }
                            if ("BigDecimal".equals(itemsDataType)) {
                                return "new BigDecimal(\"" + v + "\")";
                            }
                            if (itemsIsFloat) {
                                return v + "F";
                            }
                            return v;
                        }).collect(Collectors.joining(", "));
                    } else {
                        defaultValue = org.apache.commons.lang3.StringUtils.join(values, (String)", ");
                    }
                } else {
                    return this.getDefaultCollectionType(schema);
                }
                return this.getDefaultCollectionType(schema, defaultValue);
            }
            if (itemsIsMap) {
                return Pair.of(null, null);
            }
            throw new RuntimeException("Error. Codegen Property must be array/set/map: " + String.valueOf(schema));
        }
        return Pair.of(null, null);
    }

    private Pair<String, String> getDefaultCollectionType(Schema schema) {
        return this.getDefaultCollectionType(schema, null);
    }

    private Pair<String, String> getDefaultCollectionType(Schema schema, String defaultValues) {
        String arrayFormat = "new %s<>(Arrays.asList(%s))";
        if (defaultValues == null || defaultValues.isEmpty()) {
            defaultValues = "";
            arrayFormat = "new %s<>()";
        }
        if (ModelUtils.isSet((Schema)schema)) {
            return Pair.of((Object)String.format(Locale.ROOT, arrayFormat, this.instantiationTypes().getOrDefault("set", "LinkedHashSet"), defaultValues), (Object)defaultValues);
        }
        return Pair.of((Object)String.format(Locale.ROOT, arrayFormat, this.instantiationTypes().getOrDefault("array", "ArrayList"), defaultValues), (Object)defaultValues);
    }

    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    public void setUseOptional(boolean useOptional) {
        this.useOptional = useOptional;
    }

    public void setVisitable(boolean visitable) {
        this.visitable = visitable;
    }

    protected CodegenDiscriminator createDiscriminator(String schemaName, Schema schema) {
        CodegenDiscriminator discriminator = super.createDiscriminator(schemaName, schema);
        if (discriminator == null) {
            return null;
        }
        if (discriminator.getMapping() != null) {
            for (Map.Entry entry : discriminator.getMapping().entrySet()) {
                if (((String)entry.getValue()).indexOf(47) < 0) continue;
                String name = ModelUtils.getSimpleRef((String)((String)entry.getValue()));
                Schema referencedSchema = ModelUtils.getSchema((OpenAPI)this.openAPI, (String)name);
                if (referencedSchema == null) {
                    OnceLogger.once((Logger)this.log).error("Failed to lookup the schema '{}' when processing the discriminator mapping of oneOf/anyOf. Please check to ensure it's defined properly.", (Object)name);
                    continue;
                }
                if (referencedSchema.getProperties() == null || referencedSchema.getProperties().isEmpty()) continue;
                boolean isDiscriminatorPropTypeFound = false;
                Map props = referencedSchema.getProperties();
                for (Map.Entry propEntry : props.entrySet()) {
                    if (!((String)propEntry.getKey()).equals(discriminator.getPropertyName())) continue;
                    discriminator.setPropertyType(this.getTypeDeclaration((Schema)propEntry.getValue()));
                    isDiscriminatorPropTypeFound = true;
                    break;
                }
                if (!isDiscriminatorPropTypeFound) continue;
                break;
            }
        }
        return discriminator;
    }

    public String toApiVarName(String name) {
        String apiVarName = super.toApiVarName(name);
        if (this.reservedWords.contains(apiVarName)) {
            apiVarName = this.escapeReservedWord(apiVarName);
        }
        return apiVarName;
    }

    protected boolean isReservedWord(String word) {
        return word != null && this.reservedWords.contains(word);
    }

    public boolean isVisitable() {
        return this.visitable;
    }

    public String sanitizeTag(String tag) {
        return tag;
    }

    public String toApiName(String name) {
        return Utils.toApiName(name, this.apiNamePrefix, this.apiNameSuffix);
    }

    public void addOperationToGroup(String tag, String resourcePath, Operation operation, CodegenOperation co, Map<String, List<CodegenOperation>> operations) {
        if (!this.useTags) {
            int pos;
            String basePath = resourcePath;
            if (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
            if ((pos = basePath.indexOf("/")) > 0) {
                basePath = basePath.substring(0, pos);
            }
            if (basePath.isEmpty()) {
                basePath = "default";
            } else {
                co.subresourceOperation = !co.path.isEmpty();
            }
            basePath = super.sanitizeTag(basePath);
            List opList = operations.computeIfAbsent(basePath, k -> new ArrayList());
            opList.add(co);
            co.baseName = basePath;
            return;
        }
        if (this.generateOperationOnlyForFirstTag && !((Tag)co.tags.get(0)).getName().equals(tag)) {
            return;
        }
        super.addOperationToGroup(super.sanitizeTag(tag), resourcePath, operation, co, operations);
        Tag foundTag = co.tags.stream().filter(t -> (t.getExtensions() == null || !t.getExtensions().containsKey("x-autogenerated")) && t.getName().equals(tag)).findFirst().orElse(null);
        if (foundTag != null) {
            co.vendorExtensions.put("normalizedBaseTag", foundTag.getName());
            co.vendorExtensions.put("normalizedTagDesc", foundTag.getDescription());
        }
    }

    public void preprocessOpenAPI(OpenAPI openApi) {
        if (openApi.getPaths() != null) {
            for (PathItem path : openApi.getPaths().values()) {
                if (path.getParameters() == null || path.getParameters().isEmpty()) continue;
                for (Operation op : path.readOperations()) {
                    if (op.getParameters() == null) {
                        op.setParameters(new ArrayList());
                    }
                    for (Parameter parameter : path.getParameters()) {
                        boolean found = false;
                        for (Parameter opParam : op.getParameters()) {
                            if (!Objects.equals(opParam.getName(), parameter.getName()) || !Objects.equals(opParam.get$ref(), parameter.get$ref())) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        op.getParameters().add(parameter);
                    }
                }
            }
        }
        MicronautInlineModelResolver inlineModelResolver = new MicronautInlineModelResolver(openApi);
        inlineModelResolver.setInlineSchemaNameMapping(this.inlineSchemaNameMapping);
        inlineModelResolver.setInlineSchemaOptions(this.inlineSchemaOption);
        inlineModelResolver.flatten();
        Paths pathItems = openApi.getPaths();
        if (pathItems != null) {
            for (Map.Entry pathEntry : pathItems.entrySet()) {
                for (Map.Entry entry : ((PathItem)pathEntry.getValue()).readOperationsMap().entrySet()) {
                    if (((Operation)entry.getValue()).getResponses() == null) continue;
                    for (Map.Entry responseEntry : ((Operation)entry.getValue()).getResponses().entrySet()) {
                        ApiResponse response = (ApiResponse)responseEntry.getValue();
                        ApiResponse refResponse = ModelUtils.getReferencedApiResponse((OpenAPI)openApi, (ApiResponse)response);
                        if (response.getContent() == null) {
                            response.setContent(refResponse.getContent());
                        }
                        if (response.getDescription() == null) {
                            response.setDescription(refResponse.getDescription());
                        }
                        if (response.getHeaders() == null || response.getHeaders().isEmpty()) {
                            response.setHeaders(refResponse.getHeaders());
                        }
                        if (response.getExtensions() == null || response.getExtensions().isEmpty()) {
                            response.setExtensions(refResponse.getExtensions());
                        }
                        if (response.getLinks() != null && !response.getLinks().isEmpty()) continue;
                        response.setLinks(refResponse.getLinks());
                    }
                }
            }
        }
        super.preprocessOpenAPI(openApi);
    }

    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        Map<String, CodegenModel> models = allModels.stream().map(ModelMap::getModel).collect(Collectors.toMap(v -> v.classname, v -> v));
        OperationMap operations = objs.getOperations();
        List operationList = operations.getOperation();
        boolean needToAddImportFormat = false;
        HashMap<String, Integer> converterCounters = new HashMap<String, Integer>();
        ArrayList<CodegenParameter> enumParams = new ArrayList<CodegenParameter>();
        ArrayList<String> enumImports = new ArrayList<String>();
        for (CodegenOperation op : operationList) {
            objs.put((Object)"normalizedBaseTag", op.vendorExtensions.get("normalizedBaseTag"));
            objs.put((Object)"normalizedTagDesc", op.vendorExtensions.get("normalizedTagDesc"));
            op.vendorExtensions.put("methodAllowsBody", op.httpMethod.equals("PUT") || op.httpMethod.equals("POST") || op.httpMethod.equals("PATCH") || op.httpMethod.equals("OPTIONS") || op.httpMethod.equals("DELETE"));
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)op.notes)) {
                op.notes = op.notes.strip();
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)op.summary)) {
                op.summary = op.summary.strip();
            }
            Utils.normalizeExtraAnnotations("x-operation-extra-annotation", false, op.vendorExtensions);
            if (op.returnType != null) {
                String groovyExample;
                String example;
                if (models.containsKey(op.returnType)) {
                    CodegenModel m = models.get(op.returnType);
                    List allowableValues = null;
                    if (m.allowableValues != null && m.allowableValues.containsKey("values")) {
                        allowableValues = (List)m.allowableValues.get("values");
                    }
                    example = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, false, false);
                    groovyExample = this.getExampleValue(m.defaultValue, null, m.classname, true, allowableValues, null, null, m.requiredVars, true, false);
                } else {
                    example = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, false, false);
                    groovyExample = this.getExampleValue(null, null, op.returnType, false, null, op.returnBaseType, null, null, true, false);
                }
                op.vendorExtensions.put("example", example);
                op.vendorExtensions.put("groovyExample", groovyExample);
            }
            if (CONTENT_TYPE_ANY.equals(op.vendorExtensions.get(VendorExtension.X_CONTENT_TYPE.getName()))) {
                op.vendorExtensions.put(VendorExtension.X_CONTENT_TYPE.getName(), CONTENT_TYPE_APPLICATION_JSON);
            }
            op.consumes = op.consumes == null ? null : op.consumes.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            List list = op.produces = op.produces == null ? null : op.produces.stream().filter(contentType -> !CONTENT_TYPE_ANY.equals(contentType.get("mediaType"))).toList();
            if (op.consumes == null || op.consumes.isEmpty() || op.consumes.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.consumes.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultConsumeOrEmpty", true);
            }
            if (op.produces == null || op.produces.isEmpty() || op.produces.size() == 1 && CONTENT_TYPE_APPLICATION_JSON.equals(((Map)op.produces.get(0)).get("mediaType"))) {
                op.vendorExtensions.put("onlyDefaultProduceOrEmpty", true);
            }
            if (CONTENT_TYPE_APPLICATION_FORM_URLENCODED.equals(op.vendorExtensions.get(VendorExtension.X_CONTENT_TYPE.getName()))) {
                op.formParams.addAll(op.bodyParams);
                op.bodyParams.forEach(p -> {
                    p.isBodyParam = false;
                    p.isFormParam = true;
                });
                op.bodyParams.clear();
            } else if (CONTENT_TYPE_MULTIPART_FORM_DATA.equals(op.vendorExtensions.get(VendorExtension.X_CONTENT_TYPE.getName()))) {
                op.bodyParams.addAll(op.formParams);
                for (CodegenParameter param : op.allParams) {
                    if (!param.isFormParam) continue;
                    param.isBodyParam = true;
                    param.isFormParam = false;
                    param.vendorExtensions.put("isPart", true);
                    if (param.isEnumRef) {
                        param.isEnum = true;
                    }
                    if (!param.isEnum) continue;
                    Utils.addEnumParamsForConverters(this.modelPackage, param, converterCounters, enumParams, enumImports, false);
                }
                op.formParams.forEach(p -> {
                    p.isBodyParam = true;
                    p.isFormParam = false;
                    p.vendorExtensions.put("isPart", true);
                    if (p.isEnumRef) {
                        p.isEnum = true;
                    }
                    if (p.isEnum) {
                        Utils.addEnumParamsForConverters(this.modelPackage, p, converterCounters, enumParams, enumImports, false);
                    }
                });
                op.formParams.clear();
            }
            for (CodegenParameter param : op.allParams) {
                String queryValueFormat;
                if (param.isEnumRef) {
                    param.isEnum = true;
                }
                Utils.processGenericAnnotations(param, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false, false, false);
                if (this.useBeanValidation && !param.isContainer && param.isModel) {
                    param.vendorExtensions.put("withValid", true);
                }
                if (Utils.isDateType(param.dataType)) {
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)param.pattern)) {
                        param.vendorExtensions.put("formatPattern", param.pattern);
                        param.pattern = null;
                    }
                    param.minItems = null;
                    param.maxItems = null;
                    param.minLength = null;
                    param.maxLength = null;
                }
                if ((queryValueFormat = Utils.calcQueryValueFormat(param)) != null) {
                    needToAddImportFormat = true;
                    param.vendorExtensions.put("format", queryValueFormat);
                }
                if (!param.isEnum || param.isBodyParam) continue;
                Utils.addEnumParamsForConverters(this.modelPackage, param, converterCounters, enumParams, enumImports, false);
            }
            if (op.returnProperty == null) continue;
            Utils.processGenericAnnotations(op.returnProperty, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false, false, false);
            op.returnType = op.returnProperty.vendorExtensions.get("typeWithEnumWithGenericAnnotations").toString();
        }
        this.additionalProperties.put("enumImports", enumImports);
        this.additionalProperties.put("enumParams", enumParams);
        if (needToAddImportFormat) {
            objs.getImports().add(Map.of("import", "static io.micronaut.core.convert.converters.MultiValuesConverterFactory.*", "classname", "MultiValuesConverterFactory"));
        }
        return objs;
    }

    private void checkPrimitives(IJsonSchemaValidationProperties obj, Schema schema) {
        Schema refSchema;
        String schemaType;
        String format;
        boolean isFloat;
        boolean isLong;
        boolean isInteger;
        boolean isShort;
        boolean isNumber;
        boolean isNumeric;
        String dataTypeWithEnum;
        String dataType;
        Map extMap;
        if (obj == null) {
            return;
        }
        CodegenModel model = null;
        CodegenParameter param = null;
        CodegenProperty prop = null;
        CodegenResponse response = null;
        if (obj instanceof CodegenModel) {
            CodegenModel m;
            model = m = (CodegenModel)obj;
        } else if (obj instanceof CodegenProperty) {
            CodegenProperty p;
            prop = p = (CodegenProperty)obj;
        } else if (obj instanceof CodegenParameter) {
            CodegenParameter p;
            param = p = (CodegenParameter)obj;
        } else if (obj instanceof CodegenResponse) {
            CodegenResponse r;
            response = r = (CodegenResponse)obj;
        }
        Map map = model != null ? model.vendorExtensions : (param != null ? param.vendorExtensions : (extMap = prop != null ? prop.vendorExtensions : response.vendorExtensions));
        String string = model != null ? model.dataType : (param != null ? param.dataType : (dataType = prop != null ? prop.dataType : response.dataType));
        String string2 = param != null ? param.datatypeWithEnum : (dataTypeWithEnum = prop != null ? prop.datatypeWithEnum : null);
        if (schema == null) {
            extMap.put("baseType", dataType);
            return;
        }
        boolean bl = model != null ? model.isNumeric : (param != null ? param.isNumeric : (isNumeric = prop != null ? prop.isNumeric : response.isNumeric));
        boolean bl2 = model != null ? model.isNumber : (param != null ? param.isNumber : (isNumber = prop != null ? prop.isNumber : response.isNumber));
        boolean bl3 = model != null ? model.isShort : (param != null ? param.isShort : (isShort = prop != null ? prop.isShort : response.isShort));
        boolean bl4 = model != null ? model.isInteger : (param != null ? param.isInteger : (isInteger = prop != null ? prop.isInteger : response.isInteger));
        boolean bl5 = model != null ? model.isLong : (param != null ? param.isLong : (isLong = prop != null ? prop.isLong : response.isLong));
        boolean bl6 = model != null ? model.isFloat : (param != null ? param.isFloat : (isFloat = prop != null ? prop.isFloat : response.isFloat));
        boolean isDouble = model != null ? model.isDouble : (param != null ? param.isDouble : (prop != null ? prop.isDouble : response.isDouble));
        Map extensions = schema.getExtensions();
        String string3 = format = extensions != null ? (String)extensions.get("x-format") : null;
        if (format == null) {
            format = schema.getFormat() == null ? "object" : schema.getFormat();
        }
        String string4 = schemaType = extensions != null ? (String)extensions.get("x-type") : null;
        if (schemaType == null) {
            schemaType = schema.getType() == null ? "object" : schema.getType();
        }
        String baseType = dataType;
        boolean isPrimitive = false;
        if ("char".equals(schemaType) || "character".equals(schemaType)) {
            baseType = "char";
            dataType = "Character";
            dataTypeWithEnum = "Character";
            isPrimitive = true;
        } else if ("byte".equals(schemaType)) {
            baseType = "byte";
            dataType = "Byte";
            dataTypeWithEnum = "Byte";
            isNumeric = true;
            isNumber = true;
            isInteger = true;
            isPrimitive = true;
        } else if ("integer".equals(schemaType) && ("int8".equals(format) || "byte".equals(format))) {
            baseType = "Byte";
            dataType = "Byte";
            dataTypeWithEnum = "Byte";
            isNumeric = true;
            isNumber = true;
            isInteger = true;
        } else if ("short".equals(schemaType)) {
            baseType = "short";
            dataType = "Short";
            dataTypeWithEnum = "Short";
            isNumeric = true;
            isNumber = true;
            isShort = true;
            isPrimitive = true;
        } else if ("integer".equals(schemaType) && ("int16".equals(format) || "short".equals(format))) {
            baseType = "Short";
            dataType = "Short";
            dataTypeWithEnum = "Short";
            isNumeric = true;
            isNumber = true;
            isShort = true;
        } else if ("int".equals(schemaType)) {
            baseType = "int";
            dataType = "Integer";
            dataTypeWithEnum = "Integer";
            isNumeric = true;
            isNumber = true;
            isInteger = true;
            isPrimitive = true;
        } else if ("long".equals(schemaType)) {
            baseType = "long";
            dataType = "Long";
            dataTypeWithEnum = "Long";
            isNumeric = true;
            isNumber = true;
            isLong = true;
            isPrimitive = true;
        } else if ("float".equals(schemaType)) {
            baseType = "float";
            dataType = "Float";
            dataTypeWithEnum = "Float";
            isNumeric = true;
            isNumber = true;
            isFloat = true;
            isPrimitive = true;
        } else if ("double".equals(schemaType)) {
            baseType = "double";
            dataType = "Double";
            dataTypeWithEnum = "Double";
            isNumeric = true;
            isNumber = true;
            isDouble = true;
            isPrimitive = true;
        }
        Schema enumSchema = schema;
        boolean isEnum = ModelUtils.isEnumSchema((Schema)schema);
        if (!isEnum && (refSchema = ModelUtils.getReferencedSchema((OpenAPI)this.openAPI, (Schema)schema)) != null) {
            isEnum = ModelUtils.isEnumSchema((Schema)refSchema);
            enumSchema = refSchema;
        }
        if (isEnum) {
            String enumSchemaFormat;
            String enumSchemaType;
            String string5 = enumSchemaType = enumSchema.getExtensions() != null ? (String)enumSchema.getExtensions().get("x-type") : null;
            if (enumSchemaType == null) {
                enumSchemaType = enumSchema.getType();
            }
            String string6 = enumSchemaFormat = enumSchema.getExtensions() != null ? (String)enumSchema.getExtensions().get("x-format") : null;
            if (enumSchemaFormat == null) {
                enumSchemaFormat = enumSchema.getFormat();
            }
            boolean isEnumPrimitive = "char".equals(enumSchemaType) || "character".equals(enumSchemaType) || "byte".equals(enumSchemaType) || "short".equals(enumSchemaType) || "integer".equals(enumSchemaType) && ("int16".equals(enumSchemaFormat) || "short".equals(enumSchemaFormat)) || "int".equals(enumSchemaType) || "long".equals(enumSchemaType) || "float".equals(enumSchemaType) || "double".equals(enumSchemaType);
            String enumValueType = "Object";
            if ("string".equalsIgnoreCase(enumSchemaType)) {
                enumValueType = "String";
            } else if ("char".equalsIgnoreCase(enumSchemaType)) {
                enumValueType = isEnumPrimitive ? "char" : "Character";
            } else if ("byte".equalsIgnoreCase(enumSchemaType) || "integer".equalsIgnoreCase(enumSchemaType) && "byte".equalsIgnoreCase(enumSchemaFormat) || "integer".equalsIgnoreCase(enumSchemaType) && "int8".equalsIgnoreCase(enumSchemaFormat)) {
                enumValueType = isEnumPrimitive ? "byte" : "Byte";
            } else if ("short".equalsIgnoreCase(enumSchemaType) || "integer".equalsIgnoreCase(enumSchemaType) && "short".equalsIgnoreCase(enumSchemaFormat) || "integer".equalsIgnoreCase(enumSchemaType) && "int16".equalsIgnoreCase(enumSchemaFormat)) {
                enumValueType = isEnumPrimitive ? "short" : "Short";
            } else if ("long".equalsIgnoreCase(enumSchemaType) || "integer".equalsIgnoreCase(enumSchemaType) && "long".equalsIgnoreCase(enumSchemaFormat) || "integer".equalsIgnoreCase(enumSchemaType) && "int64".equalsIgnoreCase(enumSchemaFormat)) {
                enumValueType = isEnumPrimitive ? "long" : "Long";
            } else if ("int".equalsIgnoreCase(enumSchemaType) || "integer".equalsIgnoreCase(enumSchemaType)) {
                enumValueType = isEnumPrimitive ? "int" : "Integer";
            } else if ("float".equalsIgnoreCase(enumSchemaType) || "number".equalsIgnoreCase(enumSchemaType) && "float".equalsIgnoreCase(enumSchemaFormat)) {
                enumValueType = isEnumPrimitive ? "float" : "Float";
            } else if ("double".equalsIgnoreCase(enumSchemaType) || "number".equalsIgnoreCase(enumSchemaType) && "double".equalsIgnoreCase(enumSchemaFormat)) {
                enumValueType = isEnumPrimitive ? "double" : "Double";
            } else if ("boolean".equalsIgnoreCase(enumSchemaType)) {
                enumValueType = isEnumPrimitive ? "boolean" : "Boolean";
            } else if ("biginteger".equalsIgnoreCase(enumSchemaType)) {
                enumValueType = "BigInteger";
            } else if ("bigdecimal".equalsIgnoreCase(enumSchemaType) || "number".equalsIgnoreCase(enumSchemaType)) {
                enumValueType = "BigDecimal";
            }
            extMap.put("enumValueType", enumValueType);
            if (enumSchema.getNullable() != null && enumSchema.getNullable().booleanValue()) {
                extMap.put("enumValueIsNullable", true);
            }
        }
        extMap.put("baseType", baseType);
        extMap.put("isPrimitive", isPrimitive);
        if (model != null) {
            model.dataType = dataType;
            model.isNumeric = isNumeric;
            model.isNumber = isNumber;
            model.isShort = isShort;
            model.isInteger = isInteger;
            model.isLong = isLong;
            model.isFloat = isFloat;
            model.isDouble = isDouble;
        } else if (prop != null) {
            prop.dataType = dataType;
            prop.datatypeWithEnum = dataTypeWithEnum;
            prop.isNumeric = isNumeric;
            prop.isNumber = isNumber;
            prop.isShort = isShort;
            prop.isInteger = isInteger;
            prop.isLong = isLong;
            prop.isFloat = isFloat;
            prop.isDouble = isDouble;
        } else if (param != null) {
            param.dataType = dataType;
            param.datatypeWithEnum = dataTypeWithEnum;
            param.isNumeric = isNumeric;
            param.isNumber = isNumber;
            param.isShort = isShort;
            param.isInteger = isInteger;
            param.isLong = isLong;
            param.isFloat = isFloat;
            param.isDouble = isDouble;
        } else {
            response.dataType = dataType;
            response.isNumeric = isNumeric;
            response.isNumber = isNumber;
            response.isShort = isShort;
            response.isInteger = isInteger;
            response.isLong = isLong;
            response.isFloat = isFloat;
            response.isDouble = isDouble;
        }
    }

    public CodegenModel fromModel(String name, Schema schema) {
        CodegenModel model = super.fromModel(name, schema);
        this.checkPrimitives((IJsonSchemaValidationProperties)model, this.unaliasSchema(schema));
        if (!model.oneOf.isEmpty()) {
            if (this.useOneOfInterfaces) {
                model.vendorExtensions.put("x-is-one-of-interface", true);
            }
            if (ModelUtils.isTypeObjectSchema((Schema)schema)) {
                CodegenModel m = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
                this.updateModelForObject(m, schema);
                model.vars = m.vars;
                model.allVars = m.allVars;
                model.requiredVars = m.requiredVars;
                model.readWriteVars = m.readWriteVars;
                model.optionalVars = m.optionalVars;
                model.readOnlyVars = m.readOnlyVars;
                model.parentVars = m.parentVars;
                model.nonNullableVars = m.nonNullableVars;
                model.setRequiredVarsMap(m.getRequiredVarsMap());
                model.mandatory = m.mandatory;
                model.allMandatory = m.allMandatory;
            }
        }
        Utils.processDuplicateVars(model.getVars());
        model.imports.remove("ApiModel");
        model.imports.remove("ApiModelProperty");
        this.allModels.put(name, model);
        return model;
    }

    private boolean shouldBeImplicitHeader(CodegenParameter parameter) {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.implicitHeadersRegex) && parameter.baseName.matches(this.implicitHeadersRegex);
    }

    public String toEnumValue(String value, String datatype) {
        if ("Integer".equals(datatype) || "Double".equals(datatype)) {
            return value;
        }
        if ("Long".equals(datatype)) {
            return value + "L";
        }
        if ("Float".equals(datatype)) {
            return value + "F";
        }
        if ("BigDecimal".equals(datatype)) {
            return "new BigDecimal(\"" + value + "\")";
        }
        if ("URI".equals(datatype)) {
            return "URI.create(\"" + this.escapeText(value) + "\")";
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation op = super.fromOperation(path, httpMethod, operation, servers);
        if (op.isResponseFile) {
            String responseFileType;
            op.returnType = responseFileType = (String)this.typeMapping.get("responseFile");
            op.returnBaseType = responseFileType;
            op.imports.add(op.returnType);
            if (op.returnProperty != null) {
                op.returnProperty.complexType = responseFileType;
                op.returnProperty.dataType = responseFileType;
                op.returnProperty.datatypeWithEnum = responseFileType;
                op.returnProperty.baseType = responseFileType;
            }
        }
        ArrayList<CodegenParameter> paramsWithoutImplicitHeaders = new ArrayList<CodegenParameter>();
        ArrayList<CodegenParameter> swaggerParams = new ArrayList<CodegenParameter>();
        boolean hasMultipleParams = false;
        int notBodyParamsSize = 0;
        for (CodegenParameter param : op.allParams) {
            if (!param.isHeaderParam || !this.implicitHeaders && !this.shouldBeImplicitHeader(param)) {
                paramsWithoutImplicitHeaders.add(param);
            }
            if (param.isBodyParam || param.isFormParam) continue;
            swaggerParams.add(param);
            if (++notBodyParamsSize <= 1) continue;
            hasMultipleParams = true;
        }
        op.vendorExtensions.put("swaggerParams", swaggerParams);
        op.vendorExtensions.put("originalParams", paramsWithoutImplicitHeaders);
        op.vendorExtensions.put("hasNotBodyParam", notBodyParamsSize > 0);
        op.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
        for (CodegenParameter param : op.allParams) {
            param.vendorExtensions.put("hasNotBodyParam", notBodyParamsSize > 0);
            param.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
        }
        op.vendorExtensions.put("originReturnProperty", op.returnProperty);
        if (op.responses != null && !op.responses.isEmpty()) {
            for (CodegenResponse resp : op.responses) {
                if (!resp.isDefault) continue;
                resp.code = "default";
            }
        }
        this.processParametersWithAdditionalMappings(op.allParams, op.imports);
        this.processWithResponseBodyMapping(op);
        this.processOperationWithResponseWrappers(op);
        return op;
    }

    private void processParametersWithAdditionalMappings(List<CodegenParameter> params, Set<String> imports) {
        LinkedHashMap<String, ParameterMapping> additionalMappings = new LinkedHashMap<String, ParameterMapping>();
        Iterator<CodegenParameter> iter = params.iterator();
        while (iter.hasNext()) {
            CodegenParameter param = iter.next();
            boolean paramWasMapped = false;
            for (ParameterMapping mapping : this.parameterMappings) {
                if (!mapping.doesMatch(param)) continue;
                additionalMappings.put(mapping.mappedName(), mapping);
                paramWasMapped = true;
            }
            if (paramWasMapped) {
                iter.remove();
                continue;
            }
            if (!this.plural || !param.isArray || !param.isBodyParam || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)param.getRef()) || "requestBody".equals(param.paramName)) continue;
            param.paramName = English.plural((String)param.paramName);
        }
        for (ParameterMapping mapping : additionalMappings.values()) {
            String typeName;
            if (mapping.mappedType() == null) continue;
            CodegenParameter newParam = new CodegenParameter();
            newParam.paramName = mapping.mappedName();
            newParam.required = true;
            newParam.isModel = mapping.isValidated();
            newParam.dataType = typeName = this.makeSureImported(mapping.mappedType(), imports);
            if (newParam.paramName == null) {
                newParam.paramName = this.toParamName(typeName);
            }
            params.add(newParam);
        }
    }

    private void processWithResponseBodyMapping(CodegenOperation op) {
        ResponseBodyMapping bodyMapping = null;
        Iterator iter = op.responseHeaders.iterator();
        while (iter.hasNext()) {
            CodegenProperty header = (CodegenProperty)iter.next();
            boolean headerWasMapped = false;
            for (ResponseBodyMapping mapping : this.responseBodyMappings) {
                if (!mapping.doesMatch(header.baseName, op.isArray)) continue;
                if (mapping.mappedBodyType() != null) {
                    bodyMapping = mapping;
                }
                headerWasMapped = true;
            }
            if (!headerWasMapped) continue;
            iter.remove();
        }
        if (bodyMapping != null) {
            this.wrapOperationReturnType(op, bodyMapping.mappedBodyType(), bodyMapping.isValidated(), bodyMapping.isListWrapper());
        }
    }

    private void wrapOperationReturnType(CodegenOperation op, String wrapperType, boolean isValidated, boolean isListWrapper) {
        String originalReturnType;
        CodegenProperty newReturnType = new CodegenProperty();
        newReturnType.required = true;
        newReturnType.isModel = isValidated;
        String typeName = this.makeSureImported(wrapperType, op.imports);
        if ((isListWrapper || this.fluxForArrays) && op.isArray && op.returnProperty.items != null) {
            if (this.fluxForArrays && wrapperType.equals(MONO_CLASS_NAME)) {
                typeName = this.makeSureImported(FLUX_CLASS_NAME, op.imports);
                op.vendorExtensions.put("isReturnFlux", true);
            }
            originalReturnType = op.returnBaseType;
            newReturnType.dataType = typeName + "<" + op.returnBaseType + ">";
            newReturnType.items = op.returnProperty.items;
        } else {
            originalReturnType = op.returnType;
            if (originalReturnType == null) {
                originalReturnType = "Void";
                op.returnProperty = new CodegenProperty();
                op.returnProperty.dataType = "Void";
                op.returnProperty.openApiType = "";
            }
            newReturnType.dataType = typeName + "<" + originalReturnType + ">";
            newReturnType.items = op.returnProperty;
        }
        newReturnType.containerTypeMapped = typeName;
        newReturnType.containerType = typeName;
        op.vendorExtensions.put("originalReturnType", originalReturnType);
        op.returnType = newReturnType.dataType;
        op.returnContainer = newReturnType.containerTypeMapped;
        op.returnProperty = newReturnType;
        op.isArray = op.returnProperty.isArray;
    }

    private void processOperationWithResponseWrappers(CodegenOperation op) {
        boolean requiresHttpResponse;
        boolean hasNon200StatusCodes = op.responses.stream().anyMatch(response -> !"200".equals(response.code) && response.code.startsWith("2"));
        boolean hasNonMappedHeaders = !op.responseHeaders.isEmpty();
        boolean bl = requiresHttpResponse = hasNon200StatusCodes || hasNonMappedHeaders;
        if (this.generateHttpResponseAlways || this.generateHttpResponseWhereRequired && requiresHttpResponse) {
            this.wrapOperationReturnType(op, "io.micronaut.http.HttpResponse", false, false);
        }
        if (this.reactive) {
            this.wrapOperationReturnType(op, MONO_CLASS_NAME, false, false);
        }
    }

    private String makeSureImported(String typeName, Set<String> imports) {
        int firstCapitalIndex = 0;
        for (int i = 0; i < typeName.length(); ++i) {
            if (!Character.isUpperCase(typeName.charAt(i))) continue;
            firstCapitalIndex = i;
            break;
        }
        if (firstCapitalIndex != 0) {
            String dataType = typeName.substring(firstCapitalIndex);
            this.importMapping.put(dataType, typeName);
            typeName = dataType;
        }
        imports.add(typeName);
        return typeName;
    }

    public String toVarName(String name) {
        Object varName = super.toVarName(name);
        if (((String)varName).chars().allMatch(c -> Character.isUpperCase(c) || c == 95)) {
            return varName;
        }
        if (((String)varName).length() >= 2 && Character.isLowerCase(((String)varName).charAt(0)) && Character.isUpperCase(((String)varName).charAt(1))) {
            varName = "" + ((String)varName).charAt(0) + Character.toLowerCase(((String)varName).charAt(1)) + ((String)varName).substring(2);
        }
        if (((String)varName).startsWith("_")) {
            char firstNameChar = ((String)varName).toCharArray()[0];
            String underscorePrefix = this.getUnderscorePrefix(name);
            varName = underscorePrefix + String.valueOf(firstNameChar == '_' && !underscorePrefix.isEmpty() ? "" : Character.valueOf(Character.toLowerCase(firstNameChar))) + ((String)varName).substring(1);
        }
        return varName;
    }

    public String getterAndSetterCapitalize(String name) {
        Object newName = super.getterAndSetterCapitalize(name);
        if (name.startsWith("_")) {
            newName = this.getUnderscorePrefix(name) + Character.toLowerCase(((String)newName).toCharArray()[0]) + ((String)newName).substring(1);
        }
        return newName;
    }

    private String getUnderscorePrefix(String name) {
        char[] nameChars = name.toCharArray();
        StringBuilder newNameBuilder = new StringBuilder();
        for (char nameChar : nameChars) {
            if (nameChar != '_') break;
            newNameBuilder.append('_');
        }
        return newNameBuilder.toString();
    }

    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        CodegenModel model;
        objs = super.postProcessAllModels(objs);
        boolean isServer = this.isServer();
        for (ModelsMap models : objs.values()) {
            model = ((ModelMap)models.getModels().get(0)).getModel();
            ArrayList<CodegenProperty> requiredVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> requiredParentVarsWithoutDiscriminator = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> allVars = new ArrayList<CodegenProperty>();
            this.processParentModel(model, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars);
            ArrayList<CodegenProperty> optionalVars = new ArrayList<CodegenProperty>();
            ArrayList<CodegenProperty> requiredVars = new ArrayList<CodegenProperty>();
            for (CodegenProperty v : model.vars) {
                if (v.required) {
                    requiredVars.add(v);
                    continue;
                }
                optionalVars.add(v);
            }
            model.vendorExtensions.put("hasOwnVars", !model.vars.isEmpty());
            model.vendorExtensions.put("withMultipleVars", model.vars.size() > 1);
            if (!requiredParentVarsWithoutDiscriminator.isEmpty()) {
                model.vendorExtensions.put("requiredParentVarsWithoutDiscriminator", requiredParentVarsWithoutDiscriminator);
            }
            ArrayList<CodegenProperty> requiredVarsWithoutDiscriminatorAndReadOnly = new ArrayList<CodegenProperty>();
            if (!requiredVarsWithoutDiscriminator.isEmpty()) {
                model.vendorExtensions.put("requiredVarsWithoutDiscriminator", requiredVarsWithoutDiscriminator);
                for (CodegenProperty prop : requiredVarsWithoutDiscriminator) {
                    if (!isServer && prop.isReadOnly) continue;
                    requiredVarsWithoutDiscriminatorAndReadOnly.add(prop);
                }
                if (!requiredVarsWithoutDiscriminatorAndReadOnly.isEmpty()) {
                    model.vendorExtensions.put("requiredVarsWithoutDiscriminatorAndReadOnly", requiredVarsWithoutDiscriminatorAndReadOnly);
                }
            }
            model.allVars = allVars;
            model.vendorExtensions.put("requiredVars", requiredVars);
            model.vendorExtensions.put("optionalVars", optionalVars);
            model.vendorExtensions.put("areRequiredVarsAndReadOnlyVars", !requiredVarsWithoutDiscriminator.isEmpty() && !model.readOnlyVars.isEmpty());
            model.vendorExtensions.put("serialId", this.random.nextLong());
            model.vendorExtensions.put("withRequiredVars", !requiredVarsWithoutDiscriminator.isEmpty() && !requiredVarsWithoutDiscriminatorAndReadOnly.isEmpty());
            Utils.normalizeExtraAnnotations("x-class-extra-annotation", false, model.vendorExtensions);
            if (model.discriminator != null) {
                model.vendorExtensions.put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
                model.vendorExtensions.put("hasMultipleMappedModels", model.discriminator.getMappedModels().size() > 1);
                model.discriminator.getVendorExtensions().put("hasMappedModels", !model.discriminator.getMappedModels().isEmpty());
                model.discriminator.getVendorExtensions().put("hasMultipleMappedModels", model.discriminator.getMappedModels().size() > 1);
            }
            model.vendorExtensions.put("isServer", isServer);
            for (CodegenProperty property : model.vars) {
                this.processProperty(property, isServer, model, objs);
            }
            for (CodegenProperty property : model.requiredVars) {
                this.processProperty(property, isServer, model, objs);
            }
            if (model.parentVars != null) {
                for (CodegenProperty property : model.parentVars) {
                    this.processProperty(property, isServer, model, objs);
                }
            }
            if (model.isEnum) {
                this.addImport(model, "Function");
            }
            boolean bl = model.hasVars = !requiredVarsWithoutDiscriminator.isEmpty() || !model.vars.isEmpty();
            if (System.getProperty("micronaut.test.no-vars") != null) {
                model.hasVars = false;
                model.vendorExtensions.put("hasOwnVars", false);
                model.vendorExtensions.put("requiredVarsWithoutDiscriminator", Collections.emptyList());
                model.vendorExtensions.put("optionalVars", Collections.emptyList());
                model.vendorExtensions.put("requiredVars", Collections.emptyList());
                model.vendorExtensions.put("withRequiredVars", false);
                model.vars = Collections.emptyList();
            }
            Utils.addStrValueToEnum(model);
        }
        for (ModelsMap models : objs.values()) {
            model = ((ModelMap)models.getModels().get(0)).getModel();
            this.processOneOfModels(model, objs.values());
        }
        return objs;
    }

    protected void updateEnumVarsWithExtensions(List<Map<String, Object>> enumVars, Map<String, Object> vendorExtensions, String dataType) {
        super.updateEnumVarsWithExtensions(enumVars, vendorExtensions, dataType);
        if (vendorExtensions == null) {
            return;
        }
        List xDeprecated = (List)vendorExtensions.get("x-deprecated");
        if (xDeprecated != null && !xDeprecated.isEmpty()) {
            for (Object deprecatedItem : xDeprecated) {
                Map<String, Object> foundEnumVar = null;
                for (Map<String, Object> enumVar : enumVars) {
                    boolean isString = (Boolean)enumVar.get("isString");
                    Object value = (String)enumVar.get("value");
                    if (!isString) {
                        String upperValue;
                        if (((String)value).startsWith("(short)")) {
                            value = ((String)value).replace("(short) ", "");
                        } else if (((String)value).startsWith("(byte)")) {
                            value = ((String)value).replace("(byte) ", "");
                        }
                        int argPos = ((String)value).indexOf(40);
                        if (argPos >= 0) {
                            value = ((String)value).substring(argPos + 1, ((String)value).indexOf(41));
                        }
                        if ((upperValue = ((String)value).toUpperCase(Locale.ENGLISH)).endsWith("F") || upperValue.endsWith("L") || upperValue.endsWith("D")) {
                            value = ((String)value).substring(0, ((String)value).length() - 1);
                        }
                        if (!((String)value).contains("'")) {
                            value = ((String)value).replace("'", "");
                        }
                        if (!((String)value).contains("\"")) {
                            value = "\"" + (String)value + "\"";
                        }
                    }
                    if (!((String)value).equals("\"" + String.valueOf(deprecatedItem) + "\"")) continue;
                    foundEnumVar = enumVar;
                    break;
                }
                if (foundEnumVar == null) continue;
                foundEnumVar.put("deprecated", true);
            }
        }
        String baseType = (String)vendorExtensions.get("baseType");
        for (Map<String, Object> enumVar : enumVars) {
            if (((Boolean)enumVar.get("isString")).booleanValue()) continue;
            String value = (String)enumVar.get("value");
            value = value.replace("\"", "");
            if ("char".equals(baseType) && !value.startsWith("'")) {
                enumVar.put("value", "'" + value + "'");
                continue;
            }
            if ("short".equalsIgnoreCase(baseType) && !value.startsWith("(short)")) {
                enumVar.put("value", "(short) " + value);
                continue;
            }
            if (!"byte".equalsIgnoreCase(baseType) || value.startsWith("(byte)")) continue;
            enumVar.put("value", "(byte) " + value);
        }
    }

    private void processOneOfModels(CodegenModel model, Collection<ModelsMap> models) {
        if (!model.vendorExtensions.containsKey("x-is-one-of-interface") || !Boolean.parseBoolean(model.vendorExtensions.get("x-is-one-of-interface").toString())) {
            return;
        }
        CodegenDiscriminator discriminator = model.discriminator;
        if (discriminator == null) {
            return;
        }
        String oneOfInterfaceName = model.name;
        for (ModelsMap modelMap : models) {
            Object xImplements;
            CodegenModel m = ((ModelMap)modelMap.getModels().get(0)).getModel();
            if (!m.vendorExtensions.containsKey("x-implements") || !((xImplements = m.vendorExtensions.get("x-implements")) instanceof List)) continue;
            List xImplementsList = (List)xImplements;
            for (Object implInterface : xImplementsList) {
                boolean discriminatorPropFound;
                List requiredVarsWithoutDiscriminator;
                if (!oneOfInterfaceName.equalsIgnoreCase(implInterface.toString())) continue;
                this.fixDiscriminatorProp(m.allVars, discriminator);
                this.fixDiscriminatorProp(m.requiredVars, discriminator);
                List requiredVarsWithoutDiscriminatorAndReadOnly = (List)m.vendorExtensions.get("requiredVarsWithoutDiscriminatorAndReadOnly");
                if (this.fixDiscriminatorProp(requiredVarsWithoutDiscriminatorAndReadOnly, discriminator)) {
                    this.removePropIfContains(discriminator.getPropertyName(), (List<CodegenProperty>)requiredVarsWithoutDiscriminatorAndReadOnly);
                }
                if (this.fixDiscriminatorProp(requiredVarsWithoutDiscriminator = (List)m.vendorExtensions.get("requiredVarsWithoutDiscriminator"), discriminator)) {
                    this.removePropIfContains(discriminator.getPropertyName(), (List<CodegenProperty>)requiredVarsWithoutDiscriminator);
                    m.vendorExtensions.put("withRequiredVars", !requiredVarsWithoutDiscriminator.isEmpty() && !requiredVarsWithoutDiscriminatorAndReadOnly.isEmpty());
                }
                if (discriminatorPropFound = this.fixDiscriminatorProp(m.vars, discriminator)) continue;
                CodegenProperty discriminatorProp = new CodegenProperty();
                discriminatorProp.name = discriminator.getPropertyName();
                discriminatorProp.baseName = discriminator.getPropertyName();
                discriminatorProp.dataType = discriminator.getPropertyType();
                discriminatorProp.baseType = discriminator.getPropertyType();
                discriminatorProp.vendorExtensions.put("typeWithEnumWithGenericAnnotations", discriminator.getPropertyType());
                discriminatorProp.isDiscriminator = true;
                discriminatorProp.isOverridden = true;
                discriminatorProp.isNullable = true;
                discriminatorProp.isOptional = false;
                discriminatorProp.required = true;
                discriminatorProp.isReadOnly = false;
                discriminatorProp.vendorExtensions.put("overridden", true);
                String realName = discriminatorProp.name;
                realName = realName.replaceFirst("_", "");
                discriminatorProp.nameInPascalCase = StringUtils.camelize((String)realName);
                discriminatorProp.nameInCamelCase = StringUtils.camelize((String)realName, (CamelizeOption)CamelizeOption.LOWERCASE_FIRST_LETTER);
                discriminatorProp.nameInSnakeCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, discriminatorProp.nameInCamelCase);
                discriminatorProp.getter = "get" + this.getterAndSetterCapitalize(discriminatorProp.name);
                discriminatorProp.setter = "set" + this.getterAndSetterCapitalize(discriminatorProp.name);
                discriminatorProp.vendorExtensions.put("realName", realName);
                CodegenProperty parentVarDiscriminator = this.findProp(discriminatorProp, m.parentVars);
                if (parentVarDiscriminator != null) continue;
                m.vars.add(discriminatorProp);
                m.allVars.add(discriminatorProp);
                m.vendorExtensions.put("withMultipleVars", true);
            }
        }
    }

    private boolean fixDiscriminatorProp(List<CodegenProperty> props, CodegenDiscriminator discriminator) {
        if (props == null || props.isEmpty()) {
            return false;
        }
        for (CodegenProperty prop : props) {
            if (!prop.name.equals(discriminator.getPropertyName())) continue;
            this.processDiscriminatorProperty(prop, discriminator);
            return true;
        }
        return false;
    }

    private void processDiscriminatorProperty(CodegenProperty prop, CodegenDiscriminator discriminator) {
        prop.isDiscriminator = true;
        prop.isOverridden = true;
        prop.isNullable = false;
        prop.isOptional = false;
        prop.required = true;
        prop.isReadOnly = false;
        prop.vendorExtensions.put("overridden", true);
        prop.openApiType = discriminator.getPropertyType();
        prop.dataType = discriminator.getPropertyType();
        prop.datatypeWithEnum = discriminator.getPropertyType();
        prop.baseType = discriminator.getPropertyType();
        Utils.processGenericAnnotations(prop, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false, false, false);
    }

    private void processProperty(CodegenProperty property, boolean isServer, CodegenModel model, Map<String, ModelsMap> models) {
        property.vendorExtensions.put("inRequiredArgsConstructor", !property.isReadOnly || isServer);
        property.vendorExtensions.put("isServer", isServer);
        property.vendorExtensions.put(OPT_USE_LOMBOK, this.lombok);
        property.vendorExtensions.put("defaultValueIsNotNull", property.defaultValue != null && !property.defaultValue.equals("null"));
        property.vendorExtensions.put("x-implements", model.vendorExtensions.get("x-implements"));
        if (this.useBeanValidation && (!property.isContainer && property.isModel || property.getIsArray() && property.getComplexType() != null && models.containsKey(property.getComplexType()))) {
            property.vendorExtensions.put("withValid", true);
        }
        if (Utils.isDateType(property.dataType)) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)property.pattern)) {
                property.vendorExtensions.put("formatPattern", property.pattern);
                property.pattern = null;
            }
            property.minItems = null;
            property.maxItems = null;
            property.minLength = null;
            property.maxLength = null;
        }
        Utils.processGenericAnnotations(property, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false, false, false);
        Utils.normalizeExtraAnnotations("x-field-extra-annotation", false, property.vendorExtensions);
        Utils.normalizeExtraAnnotations("x-setter-extra-annotation", false, property.vendorExtensions);
    }

    public boolean isGenerateHardNullable() {
        return false;
    }

    private void processParentModel(CodegenModel model, List<CodegenProperty> requiredVarsWithoutDiscriminator, List<CodegenProperty> requiredParentVarsWithoutDiscriminator, List<CodegenProperty> allVars) {
        CodegenModel parent = model.parentModel;
        boolean hasParent = parent != null;
        for (Object variable : model.vars) {
            if (!this.notContainsProp((CodegenProperty)variable, allVars)) continue;
            allVars.add(variable.clone());
        }
        boolean parentIsOneOfInterface = hasParent && Boolean.TRUE.equals(parent.getVendorExtensions().get("x-is-one-of-interface"));
        for (Object v : model.requiredVars) {
            if (!this.notContainsProp((CodegenProperty)v, requiredVarsWithoutDiscriminator) || this.isDiscriminator((CodegenProperty)v, model) && !parentIsOneOfInterface) continue;
            requiredVarsWithoutDiscriminator.add((CodegenProperty)v);
        }
        this.requiredParentVarsWithoutDiscriminator(model, requiredParentVarsWithoutDiscriminator);
        if (hasParent) {
            ArrayList<CodegenProperty> parentVars = new ArrayList<CodegenProperty>();
            for (CodegenProperty v : parent.allVars) {
                if (!this.notContainsProp(v, model.vars)) continue;
                Utils.processGenericAnnotations(v, this.useBeanValidation, this.isGenerateHardNullable(), false, false, false, false, false, false);
                parentVars.add(v);
            }
            model.parentVars = parentVars;
            this.processParentModel(parent, requiredVarsWithoutDiscriminator, requiredParentVarsWithoutDiscriminator, allVars);
        }
        if (parentIsOneOfInterface) {
            for (CodegenProperty variable : parent.vars) {
                if (!this.notContainsProp(variable, model.vars)) continue;
                if (parent.discriminator != null && parent.discriminator.getPropertyName().equals(variable.name)) {
                    variable.isDiscriminator = true;
                    variable.isOverridden = true;
                    this.removePropIfContains(variable, requiredVarsWithoutDiscriminator);
                    this.removePropIfContains(variable, requiredParentVarsWithoutDiscriminator);
                }
                model.vars.add(variable.clone());
            }
            for (CodegenProperty variable : parent.requiredVars) {
                if (!this.notContainsProp(variable, model.requiredVars)) continue;
                model.requiredVars.add(variable);
            }
            model.parentModel = null;
            model.parent = null;
            model.parentVars = null;
        }
    }

    private void requiredParentVarsWithoutDiscriminator(CodegenModel model, List<CodegenProperty> requiredParentVarsWithoutDiscriminator) {
        CodegenModel parent = model.parentModel;
        if (parent == null) {
            return;
        }
        for (CodegenProperty v : parent.vars) {
            boolean isDiscriminator = this.isDiscriminator(v, model);
            if (!v.required || isDiscriminator) continue;
            v.vendorExtensions.put("isServerOrNotReadOnly", !v.isReadOnly || this.isServer());
            if (!this.notContainsProp(v, requiredParentVarsWithoutDiscriminator)) continue;
            requiredParentVarsWithoutDiscriminator.add(v);
        }
    }

    private void removePropIfContains(CodegenProperty prop, List<CodegenProperty> props) {
        this.removePropIfContains(prop.name, props);
    }

    private void removePropIfContains(String propName, List<CodegenProperty> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        props.removeIf(p -> propName.equals(p.name));
    }

    private CodegenProperty findProp(CodegenProperty prop, List<CodegenProperty> props) {
        if (props == null || props.isEmpty()) {
            return null;
        }
        for (CodegenProperty p : props) {
            if (!prop.name.equals(p.name)) continue;
            return p;
        }
        return null;
    }

    private boolean notContainsProp(CodegenProperty prop, List<CodegenProperty> props) {
        for (CodegenProperty p : props) {
            if (!prop.name.equals(p.name)) continue;
            return false;
        }
        return true;
    }

    private boolean isDiscriminator(CodegenProperty prop, CodegenModel model) {
        boolean isDiscriminator = prop.isDiscriminator;
        if (isDiscriminator) {
            return true;
        }
        if (model.parentModel == null) {
            return false;
        }
        CodegenProperty parentProp = null;
        for (CodegenProperty pv : model.parentModel.allVars) {
            if (!pv.required || !pv.name.equals(prop.name)) continue;
            isDiscriminator = pv.isDiscriminator;
            parentProp = pv;
            break;
        }
        if (isDiscriminator) {
            return true;
        }
        return parentProp != null && this.isDiscriminator(parentProp, model.parentModel);
    }

    public void setParameterExampleValue(CodegenParameter p) {
        p.vendorExtensions.put("groovyExample", this.getParameterExampleValue(p, true));
        p.example = this.getParameterExampleValue(p, false);
    }

    protected String getParameterExampleValue(CodegenParameter p, boolean groovy) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        CodegenModel model = this.allModels.get(p.getDataType());
        if (model == null && p.dataType != null) {
            model = this.allModels.get(p.dataType.toLowerCase(Locale.ENGLISH));
        }
        if (!p.vendorExtensions.containsKey("baseType")) {
            p.vendorExtensions.put("baseType", p.isContainer ? p.dataType : p.baseType);
        }
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, model != null ? model.requiredVars : null, groovy, false);
    }

    protected String getPropertyExampleValue(CodegenProperty p, boolean groovy) {
        List allowableValues = p.allowableValues == null ? null : (List)p.allowableValues.get("values");
        CodegenModel model = this.allModels.get(p.getDataType());
        if (model == null && p.dataType != null) {
            model = this.allModels.get(p.dataType.toLowerCase(Locale.ENGLISH));
        }
        if (!p.vendorExtensions.containsKey("baseType")) {
            p.vendorExtensions.put("baseType", p.isContainer ? p.dataType : p.baseType);
        }
        return this.getExampleValue(p.defaultValue, p.example, p.dataType, p.isModel, allowableValues, p.items == null ? null : p.items.dataType, p.items == null ? null : p.items.defaultValue, model != null ? model.requiredVars : null, groovy, true);
    }

    public String getExampleValue(String defaultValue, String example, String dataType, Boolean isModel, List<Object> allowableValues, String itemsType, String itemsExample, List<CodegenProperty> requiredVars, boolean groovy, boolean isProperty) {
        String containerType;
        example = defaultValue != null ? defaultValue : example;
        String string = containerType = dataType == null ? null : dataType.split("<")[0];
        if ("String".equals(dataType)) {
            example = groovy ? (example != null ? "'" + this.escapeTextGroovy((String)example) + "'" : "'example'") : (example != null ? "\"" + this.escapeText((String)example) + "\"" : "\"example\"");
        } else if ("Integer".equals(dataType) || "Short".equals(dataType)) {
            example = example != null ? example : "56";
        } else if ("Long".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "56"), (CharSequence)"L", (CharSequence[])new CharSequence[0]);
        } else if ("Float".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "3.4"), (CharSequence)"F", (CharSequence[])new CharSequence[0]);
        } else if ("Double".equals(dataType)) {
            example = org.apache.commons.lang3.StringUtils.appendIfMissingIgnoreCase((String)(example != null ? example : "3.4"), (CharSequence)"D", (CharSequence[])new CharSequence[0]);
        } else if ("Boolean".equals(dataType)) {
            example = example != null ? example : OPT_GENERATE_SWAGGER_ANNOTATIONS_FALSE;
        } else if ("File".equals(dataType)) {
            example = "null";
        } else if ("OffsetDateTime".equals(dataType)) {
            example = "OffsetDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("LocalDate".equals(dataType)) {
            example = "LocalDate.of(2001, 2, 3)";
        } else if ("LocalDateTime".equals(dataType)) {
            example = "LocalDateTime.of(2001, 2, 3, 4, 5)";
        } else if ("OffsetDateTime".equals(dataType)) {
            example = "OffsetDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("ZonedDateTime".equals(dataType)) {
            example = "ZonedDateTime.of(2001, 2, 3, 12, 0, 0, 0, java.time.ZoneOffset.of(\"+02:00\"))";
        } else if ("MultipartBody".equals(dataType)) {
            example = "MultipartBody.builder().build()";
        } else if ("BigDecimal".equals(dataType)) {
            example = "new BigDecimal(\"78\")";
        } else if (allowableValues != null && !allowableValues.isEmpty()) {
            Object value = example;
            if (value == null || !allowableValues.contains(value)) {
                value = allowableValues.get(0);
            }
            if (isProperty) {
                dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
            }
            example = dataType + ".fromValue(\"" + String.valueOf(value) + "\")";
        } else if (isModel != null && isModel.booleanValue() || isModel == null && !this.languageSpecificPrimitives.contains(dataType)) {
            if (requiredVars == null) {
                example = "null";
            } else if (this.requiredPropertiesInConstructor) {
                StringBuilder builder = new StringBuilder();
                if (isProperty) {
                    dataType = (String)((Object)this.importMapping.getOrDefault(dataType, this.modelPackage + "." + dataType));
                }
                builder.append("new ").append(dataType).append("(");
                for (int i = 0; i < requiredVars.size(); ++i) {
                    if (i != 0) {
                        builder.append(", ");
                    }
                    builder.append(this.getPropertyExampleValue(requiredVars.get(i), groovy));
                }
                builder.append(")");
                example = builder.toString();
            } else {
                example = "new " + dataType + "()";
            }
        }
        if ("List".equals(containerType)) {
            Object innerExample;
            if ("String".equals(itemsType)) {
                String string2 = itemsExample = itemsExample != null ? itemsExample : "example";
                innerExample = groovy ? "'" + this.escapeTextGroovy(itemsExample) + "'" : "\"" + this.escapeText(itemsExample) + "\"";
            } else {
                Object object = innerExample = itemsExample != null ? itemsExample : "";
            }
            example = groovy ? "[" + (String)innerExample + "]" : "List.of(" + (String)innerExample + ")";
        } else if ("Set".equals(containerType)) {
            example = groovy ? "[].asSet()" : "new HashSet<>()";
        } else if ("Map".equals(containerType)) {
            example = groovy ? "[:]" : "new HashMap<>()";
        } else if (example == null) {
            example = "null";
        }
        return example;
    }

    public String escapeTextGroovy(String text) {
        if (text == null) {
            return null;
        }
        return this.escapeText(text).replace("'", "\"");
    }

    protected ImmutableMap.Builder<String, Mustache.Lambda> addMustacheLambdas() {
        return super.addMustacheLambdas().put((Object)"replaceDotsWithUnderscore", (Object)new Formatting.ReplaceDotsWithUnderscoreLambda());
    }

    public void setSerializationLibrary(String serializationLibrary) {
        try {
            this.serializationLibrary = SerializationLibraryKind.valueOf(serializationLibrary).name();
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(serializationLibrary + " is an invalid enum property naming option. Please choose from:");
            for (SerializationLibraryKind availableSerializationLibrary : SerializationLibraryKind.values()) {
                sb.append("\n  ").append(availableSerializationLibrary.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public void setDateTimeLibrary(String name) {
        this.setDateLibrary(name);
    }

    public void setJsonIncludeAlwaysForRequiredFields(boolean jsonIncludeAlwaysForRequiredFields) {
        this.jsonIncludeAlwaysForRequiredFields = jsonIncludeAlwaysForRequiredFields;
    }

    public void setUseOneOfInterfaces(Boolean useOneOfInterfaces) {
        super.setUseOneOfInterfaces(useOneOfInterfaces);
        this.additionalProperties.put("useOneOfInterfaces", useOneOfInterfaces);
    }

    public boolean getUseInlineModelResolver() {
        return false;
    }

    public void setGenerateSwaggerAnnotations(boolean generateSwaggerAnnotations) {
        this.generateSwaggerAnnotations = Boolean.toString(generateSwaggerAnnotations);
        if (generateSwaggerAnnotations) {
            this.additionalProperties.put("generateSwagger2Annotations", true);
        }
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.additionalProperties.put(OPT_DATE_FORMAT, dateFormat);
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        this.additionalProperties.put(OPT_DATE_TIME_FORMAT, dateTimeFormat);
    }

    public void setUseEnumCaseInsensitive(boolean useEnumCaseInsensitive) {
        this.useEnumCaseInsensitive = useEnumCaseInsensitive;
    }

    public void setRequiredPropertiesInConstructor(boolean requiredPropertiesInConstructor) {
        this.requiredPropertiesInConstructor = requiredPropertiesInConstructor;
    }

    public void postProcess() {
    }
}

