/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.openapi.generator;

import io.micronaut.openapi.generator.AbstractMicronautJavaCodegen;
import io.micronaut.openapi.generator.AuthFilterPatternStyle;
import io.micronaut.openapi.generator.JavaMicronautClientOptionsBuilder;
import io.micronaut.openapi.generator.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.config.GlobalSettings;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;

public class JavaMicronautClientCodegen
extends AbstractMicronautJavaCodegen<JavaMicronautClientOptionsBuilder> {
    public static final String OPT_CONFIGURE_AUTH = "configureAuth";
    public static final String OPT_CONFIGURE_AUTH_FILTER_PATTERN = "configureAuthFilterPattern";
    public static final String OPT_CONFIGURE_CLIENT_ID = "configureClientId";
    public static final String OPT_CLIENT_PATH = "clientPath";
    public static final String OPT_USE_OAUTH = "useOauth";
    public static final String OPT_USE_BASIC_AUTH = "useBasicAuth";
    public static final String OPT_USE_API_KEY_AUTH = "useApiKeyAuth";
    public static final String OPT_AUTH_FILTER = "authFilter";
    public static final String OPT_GENERATE_AUTH_CLASSES = "generateAuthClasses";
    public static final String OPT_AUTH_CONFIG_NAME = "authConfigName";
    public static final String OPT_AUTH_FILTER_CLIENT_IDS = "authFilterClientIds";
    public static final String OPT_AUTH_FILTER_EXCLUDED_CLIENT_IDS = "authFilterExcludedClientIds";
    public static final String ADDITIONAL_CLIENT_TYPE_ANNOTATIONS = "additionalClientTypeAnnotations";
    public static final String AUTHORIZATION_FILTER_PATTERN = "authorizationFilterPattern";
    public static final String AUTHORIZATION_FILTER_PATTERN_STYLE = "authorizationFilterPatternStyle";
    public static final String BASE_PATH_SEPARATOR = "basePathSeparator";
    public static final String CLIENT_ID = "clientId";
    public static final String NAME = "java-micronaut-client";
    protected Object additionalClientTypeAnnotations;
    protected Object authorizationFilterPattern;
    protected String authorizationFilterPatternStyle;
    protected String basePathSeparator = ".";
    protected String clientId;
    protected String authConfigName;
    protected Object authFilterClientIds;
    protected Object authFilterExcludedClientIds;
    protected boolean configureAuthorization;
    protected boolean clientPath;
    protected boolean useOauth = true;
    protected boolean useBasicAuth = true;
    protected boolean useApiKeyAuth = true;
    protected boolean authFilter = true;
    protected boolean generateAuthClasses = true;

    JavaMicronautClientCodegen() {
        this.title = "OpenAPI Micronaut Client";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.STABLE).build();
        this.additionalProperties.put("client", "true");
        this.cliOptions.add(CliOption.newString((String)ADDITIONAL_CLIENT_TYPE_ANNOTATIONS, (String)"Additional annotations for client type(class level annotations). List separated by semicolon(;) or new line (Linux or Windows)"));
        this.cliOptions.add(CliOption.newString((String)AUTHORIZATION_FILTER_PATTERN, (String)"Configure the authorization filter pattern for the client. Generally defined when generating clients from multiple specification files"));
        this.cliOptions.add(CliOption.newString((String)BASE_PATH_SEPARATOR, (String)"Configure the separator to use between the application name and base path when referencing the property").defaultValue(this.basePathSeparator));
        this.cliOptions.add(CliOption.newString((String)CLIENT_ID, (String)"Configure the service ID for the Client"));
        this.cliOptions.add(CliOption.newString((String)OPT_AUTH_CONFIG_NAME, (String)"Authorization config name. Using in config properties for HttpBasicAuthConfig and ApiKeyAuthConfig"));
        this.cliOptions.add(CliOption.newString((String)OPT_AUTH_FILTER_CLIENT_IDS, (String)"Client IDs for AuthorizationFilter. If you set `clientId`, then authFilterClientIds will be set only this clientId"));
        this.cliOptions.add(CliOption.newString((String)OPT_AUTH_FILTER_EXCLUDED_CLIENT_IDS, (String)"Excluded client IDs for AuthorizationFilter"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_CONFIGURE_AUTH, (String)"Configure all the authorization methods as specified in the file", (boolean)this.configureAuthorization));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_CLIENT_PATH, (String)"Generate code with @Client annotation path attribute", (boolean)this.clientPath));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_OAUTH, (String)"Generate AuthorizationFilter with support OAuth2.0 or not"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_BASIC_AUTH, (String)"Generate HttpBasicAuthConfig class or not"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_USE_API_KEY_AUTH, (String)"Generate ApiKeyAuthConfig config or not"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_AUTH_FILTER, (String)"Generate AuthorizationFilter or not"));
        this.cliOptions.add(CliOption.newBoolean((String)OPT_GENERATE_AUTH_CLASSES, (String)"Generate authorization classes or not"));
        GlobalSettings.setProperty((String)"apiDocs", (String)"false");
        GlobalSettings.setProperty((String)"modelDocs", (String)"false");
        CliOption authorizationFilterPatternStyleOpt = CliOption.newString((String)AUTHORIZATION_FILTER_PATTERN_STYLE, (String)"Configure the authorization filter pattern style for the client");
        HashMap<String, String> authorizationFilterPatternStyleOptions = new HashMap<String, String>();
        authorizationFilterPatternStyleOptions.put(AuthFilterPatternStyle.ANT.name(), "Ant-style pattern matching.");
        authorizationFilterPatternStyleOptions.put(AuthFilterPatternStyle.REGEX.name(), "Regex-style pattern matching.");
        authorizationFilterPatternStyleOpt.setEnum(authorizationFilterPatternStyleOptions);
        this.cliOptions.add(authorizationFilterPatternStyleOpt);
        this.typeMapping.put("file", "byte[]");
        this.typeMapping.put("responseFile", "ByteBuffer<?>");
        this.importMapping.put("ByteBuffer<?>", "io.micronaut.core.io.buffer.ByteBuffer");
        this.importMapping.put("MultipartBody", "io.micronaut.http.client.multipart.MultipartBody");
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return NAME;
    }

    public String getHelp() {
        return "Generates a Java Micronaut Client.";
    }

    private void postProcessMultipartParam(CodegenOperation op, List<CodegenParameter> params, Collection<String> removedParams) {
        Pair<CodegenParameter, Set<String>> pair = Utils.processMultipartBody(op, params, false);
        CodegenParameter multipartParam = (CodegenParameter)pair.getLeft();
        if (multipartParam != null) {
            this.setParameterExampleValue(multipartParam);
        }
        removedParams.addAll((Collection)pair.getRight());
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        List operationList = operations.getOperation();
        HashSet<String> removedParams = new HashSet<String>();
        boolean alreadyAddedMultipartBodyImport = false;
        for (CodegenOperation op : operationList) {
            boolean hasMultipleParams;
            this.postProcessMultipartParam(op, op.bodyParams, removedParams);
            this.postProcessMultipartParam(op, op.allParams, removedParams);
            op.notNullableParams.removeIf(p -> removedParams.contains(p.paramName));
            op.requiredParams.removeIf(p -> removedParams.contains(p.paramName));
            op.optionalParams.removeIf(p -> removedParams.contains(p.paramName));
            op.requiredAndNotNullableParams.removeIf(p -> removedParams.contains(p.paramName));
            if (op.vendorExtensions.containsKey("originalParams")) {
                ((List)op.vendorExtensions.get("originalParams")).removeIf(p -> removedParams.contains(p.paramName));
            }
            if (!removedParams.isEmpty() && !alreadyAddedMultipartBodyImport) {
                objs.getImports().add(Map.of("import", "io.micronaut.http.client.multipart.MultipartBody", "classname", "MultipartBody"));
                alreadyAddedMultipartBodyImport = true;
            }
            boolean hasNotBodyParam = hasMultipleParams = !op.allParams.isEmpty();
            for (CodegenParameter param : op.allParams) {
                param.vendorExtensions.put("hasNotBodyParam", hasNotBodyParam);
                param.vendorExtensions.put("hasMultipleParams", hasMultipleParams);
            }
        }
        List enumParams = (List)this.additionalProperties.get("enumParams");
        if (this.generateEnumConverters && !enumParams.isEmpty()) {
            String enumConfigName = "Client";
            if (this.clientId != null) {
                enumConfigName = StringUtils.capitalize((String)this.clientId.replace("-", ""));
            }
            String enumConfigClassName = "EnumConverter" + enumConfigName + "Config";
            this.additionalProperties.put("enumConfigClassName", enumConfigClassName);
            String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
            this.supportingFiles.add(new SupportingFile("common/EnumConverterConfig.mustache", invokerFolder + "/config", enumConfigClassName + ".java"));
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(OPT_CONFIGURE_AUTH)) {
            this.configureAuthorization = this.convertPropertyToBoolean(OPT_CONFIGURE_AUTH);
        }
        this.writePropertyBack(OPT_CONFIGURE_AUTH, this.configureAuthorization);
        this.writePropertyBack("useAuth", true);
        this.writePropertyBack(OPT_CONFIGURE_AUTH_FILTER_PATTERN, false);
        this.writePropertyBack(OPT_CONFIGURE_CLIENT_ID, false);
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        if (this.configureAuthorization) {
            List list;
            String str;
            Object object;
            if (this.additionalProperties.containsKey(OPT_GENERATE_AUTH_CLASSES)) {
                this.generateAuthClasses = this.convertPropertyToBoolean(OPT_GENERATE_AUTH_CLASSES);
            }
            this.writePropertyBack(OPT_GENERATE_AUTH_CLASSES, this.generateAuthClasses);
            if (this.additionalProperties.containsKey(OPT_AUTH_FILTER)) {
                this.authFilter = this.convertPropertyToBoolean(OPT_AUTH_FILTER);
            }
            this.writePropertyBack(OPT_AUTH_FILTER, this.authFilter);
            if (this.additionalProperties.containsKey(OPT_USE_OAUTH)) {
                this.useOauth = this.convertPropertyToBoolean(OPT_USE_OAUTH);
            }
            this.writePropertyBack(OPT_USE_OAUTH, this.useOauth);
            if (this.additionalProperties.containsKey(OPT_USE_BASIC_AUTH)) {
                this.useBasicAuth = this.convertPropertyToBoolean(OPT_USE_BASIC_AUTH);
            }
            this.writePropertyBack(OPT_USE_BASIC_AUTH, this.useBasicAuth);
            if (this.additionalProperties.containsKey(OPT_USE_API_KEY_AUTH)) {
                this.useApiKeyAuth = this.convertPropertyToBoolean(OPT_USE_API_KEY_AUTH);
            }
            this.writePropertyBack(OPT_USE_API_KEY_AUTH, this.useApiKeyAuth);
            if (this.generateAuthClasses) {
                String authFolder = invokerFolder + "/auth";
                this.supportingFiles.add(new SupportingFile("client/auth/Authorization.mustache", authFolder, "Authorization.java"));
                this.supportingFiles.add(new SupportingFile("client/auth/AuthorizationBinder.mustache", authFolder, "AuthorizationBinder.java"));
                this.supportingFiles.add(new SupportingFile("client/auth/Authorizations.mustache", authFolder, "Authorizations.java"));
                if (this.authFilter) {
                    this.supportingFiles.add(new SupportingFile("client/auth/AuthorizationFilter.mustache", authFolder, "AuthorizationFilter.java"));
                }
                String authConfigurationFolder = authFolder + "/config";
                if (this.useApiKeyAuth) {
                    this.supportingFiles.add(new SupportingFile("client/auth/config/ApiKeyAuthConfig.mustache", authConfigurationFolder, "ApiKeyAuthConfig.java"));
                }
                if (this.useBasicAuth) {
                    this.supportingFiles.add(new SupportingFile("client/auth/config/HttpBasicAuthConfig.mustache", authConfigurationFolder, "HttpBasicAuthConfig.java"));
                }
                this.supportingFiles.add(new SupportingFile("client/auth/config/ConfigurableAuthorization.mustache", authConfigurationFolder, "ConfigurableAuthorization.java"));
            }
            if (this.additionalProperties.containsKey(AUTHORIZATION_FILTER_PATTERN)) {
                this.authorizationFilterPattern = this.additionalProperties.get(AUTHORIZATION_FILTER_PATTERN);
            }
            List<String> parsedPatterns = Utils.readListOfStringsProperty(this.authorizationFilterPattern);
            this.writePropertyBack(AUTHORIZATION_FILTER_PATTERN, parsedPatterns);
            if (!parsedPatterns.isEmpty()) {
                this.writePropertyBack(OPT_CONFIGURE_AUTH_FILTER_PATTERN, true);
            }
            if (this.additionalProperties.containsKey(OPT_AUTH_FILTER_CLIENT_IDS)) {
                this.authFilterClientIds = this.additionalProperties.get(OPT_AUTH_FILTER_CLIENT_IDS);
            }
            if (this.authFilterClientIds != null && ((object = this.authFilterClientIds) instanceof String && (str = (String)object).isEmpty() || (object = this.authFilterClientIds) instanceof List && (list = (List)object).isEmpty())) {
                this.authFilterClientIds = Collections.emptyList();
            } else {
                List<String> parsedAuthFilterClientIds = Utils.readListOfStringsProperty(this.authFilterClientIds);
                this.writePropertyBack(OPT_AUTH_FILTER_CLIENT_IDS, parsedAuthFilterClientIds);
                if (parsedAuthFilterClientIds.isEmpty() && this.clientId != null) {
                    this.authFilterClientIds = List.of(this.clientId);
                    this.writePropertyBack(OPT_AUTH_FILTER_CLIENT_IDS, this.authFilterClientIds);
                }
            }
            if (this.additionalProperties.containsKey(OPT_AUTH_FILTER_EXCLUDED_CLIENT_IDS)) {
                this.authFilterExcludedClientIds = this.additionalProperties.get(OPT_AUTH_FILTER_EXCLUDED_CLIENT_IDS);
            }
            this.writePropertyBack(OPT_AUTH_FILTER_EXCLUDED_CLIENT_IDS, Utils.readListOfStringsProperty(this.authFilterExcludedClientIds));
            if (this.additionalProperties.containsKey(AUTHORIZATION_FILTER_PATTERN_STYLE)) {
                String additionalPropertiesOpt = (String)this.additionalProperties.get(AUTHORIZATION_FILTER_PATTERN_STYLE);
                this.setAuthorizationFilterPatternStyle(additionalPropertiesOpt);
            }
            this.writePropertyBack(AUTHORIZATION_FILTER_PATTERN_STYLE, this.authorizationFilterPatternStyle);
            if (AuthFilterPatternStyle.ANT.name().equals(this.authorizationFilterPatternStyle)) {
                this.authorizationFilterPatternStyle = null;
                this.additionalProperties.remove(AUTHORIZATION_FILTER_PATTERN_STYLE);
            }
            if (this.additionalProperties.containsKey(OPT_AUTH_CONFIG_NAME)) {
                this.authConfigName = (String)this.additionalProperties.get(OPT_AUTH_CONFIG_NAME);
            }
            if (this.authConfigName == null) {
                this.authConfigName = this.clientId;
            }
            this.writePropertyBack(OPT_AUTH_CONFIG_NAME, this.authConfigName);
        }
        if (this.additionalProperties.containsKey(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS)) {
            this.additionalClientTypeAnnotations = this.additionalProperties.get(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS);
        }
        List<String> parsedAnnotations = Utils.readListOfStringsProperty(this.additionalClientTypeAnnotations);
        this.writePropertyBack(ADDITIONAL_CLIENT_TYPE_ANNOTATIONS, parsedAnnotations);
        Object clientId = this.additionalProperties.get(CLIENT_ID);
        if (clientId != null) {
            this.clientId = clientId.toString();
        }
        if (this.clientId != null) {
            this.writePropertyBack(OPT_CONFIGURE_CLIENT_ID, true);
            this.writePropertyBack(CLIENT_ID, this.clientId);
        }
        if (this.additionalProperties.containsKey(OPT_CLIENT_PATH)) {
            this.clientPath = this.convertPropertyToBoolean(OPT_CLIENT_PATH);
        }
        this.writePropertyBack(OPT_CLIENT_PATH, this.clientPath);
        Object basePathSeparator = this.additionalProperties.get(BASE_PATH_SEPARATOR);
        if (basePathSeparator != null) {
            this.basePathSeparator = basePathSeparator.toString();
        }
        this.writePropertyBack(BASE_PATH_SEPARATOR, this.basePathSeparator);
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("client/api.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        if (this.testTool.equals("junit")) {
            this.apiTestTemplateFiles.put("client/test/api_test.mustache", ".java");
        } else if (this.testTool.equals("spock")) {
            this.apiTestTemplateFiles.put("client/test/api_test.groovy.mustache", ".groovy");
        }
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public void setAdditionalClientTypeAnnotations(Object additionalClientTypeAnnotations) {
        this.additionalClientTypeAnnotations = additionalClientTypeAnnotations;
    }

    public void setAuthorizationFilterPattern(Object authorizationFilterPattern) {
        this.authorizationFilterPattern = authorizationFilterPattern;
    }

    public void setAuthorizationFilterPatternStyle(String authorizationFilterPatternStyle) {
        if (authorizationFilterPatternStyle == null) {
            this.authorizationFilterPatternStyle = null;
            return;
        }
        try {
            this.authorizationFilterPatternStyle = AuthFilterPatternStyle.valueOf(authorizationFilterPatternStyle.toUpperCase()).name();
        }
        catch (IllegalArgumentException ex) {
            StringBuilder sb = new StringBuilder(authorizationFilterPatternStyle + " is an invalid enum property naming option. Please choose from:");
            for (AuthFilterPatternStyle availableOpt : AuthFilterPatternStyle.values()) {
                sb.append("\n  ").append(availableOpt.name());
            }
            throw new RuntimeException(sb.toString());
        }
    }

    public void setAuthFilterClientIds(Object authFilterClientIds) {
        this.authFilterClientIds = authFilterClientIds;
    }

    public void setAuthFilterExcludedClientIds(Object authFilterExcludedClientIds) {
        this.authFilterExcludedClientIds = authFilterExcludedClientIds;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setAuthConfigName(String authConfigName) {
        this.authConfigName = authConfigName;
    }

    public void setClientPath(boolean clientPath) {
        this.clientPath = clientPath;
    }

    public void setUseOauth(boolean useOauth) {
        this.useOauth = useOauth;
    }

    public void setUseBasicAuth(boolean useBasicAuth) {
        this.useBasicAuth = useBasicAuth;
    }

    public void setUseApiKeyAuth(boolean useApiKeyAuth) {
        this.useApiKeyAuth = useApiKeyAuth;
    }

    public void setAuthFilter(boolean authFilter) {
        this.authFilter = authFilter;
    }

    public void setGenerateAuthClasses(boolean generateAuthClasses) {
        this.generateAuthClasses = generateAuthClasses;
    }

    public void setBasePathSeparator(String basePathSeparator) {
        this.basePathSeparator = basePathSeparator;
    }

    public void setConfigureAuthorization(boolean configureAuthorization) {
        this.configureAuthorization = configureAuthorization;
    }

    @Override
    public JavaMicronautClientOptionsBuilder optionsBuilder() {
        return new DefaultClientOptionsBuilder();
    }

    static class DefaultClientOptionsBuilder
    implements JavaMicronautClientOptionsBuilder {
        private List<String> additionalClientTypeAnnotations;
        private String authorizationFilterPattern;
        private String authorizationFilterPatternStyle;
        private List<String> authFilterClientIds;
        private List<String> authFilterExcludedClientIds;
        private String basePathSeparator;
        private String clientId;
        private String authConfigName;
        private boolean clientPath;
        private boolean useAuth;
        private boolean generateAuthClasses = true;
        private boolean useOauth = true;
        private boolean useBasicAuth = true;
        private boolean useApiKeyAuth = true;
        private boolean authFilter = true;
        private boolean plural;
        private boolean fluxForArrays;
        private boolean generatedAnnotation = true;
        private boolean lombok;
        private boolean noArgsConstructor;

        DefaultClientOptionsBuilder() {
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthorization(boolean useAuth) {
            this.useAuth = useAuth;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withGenerateAuthClasses(boolean generateAuthClasses) {
            this.generateAuthClasses = generateAuthClasses;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthFilter(boolean authFilter) {
            this.authFilter = authFilter;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withUseOauth(boolean useOauth) {
            this.useOauth = useOauth;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withUseBasicAuth(boolean useBasicAuth) {
            this.useBasicAuth = useBasicAuth;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withUseApiKeyAuth(boolean useApiKeyAuth) {
            this.useApiKeyAuth = useApiKeyAuth;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthorizationFilterPattern(String authorizationFilterPattern) {
            this.authorizationFilterPattern = authorizationFilterPattern;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthorizationFilterPatternStyle(String authorizationFilterPatternStyle) {
            this.authorizationFilterPatternStyle = authorizationFilterPatternStyle;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthFilterClientIds(List<String> authFilterClientIds) {
            this.authFilterClientIds = authFilterClientIds;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthFilterExcludedClientIds(List<String> authFilterExcludedClientIds) {
            this.authFilterExcludedClientIds = authFilterExcludedClientIds;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAuthConfigName(String authConfigName) {
            this.authConfigName = authConfigName;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withAdditionalClientTypeAnnotations(List<String> additionalClientTypeAnnotations) {
            this.additionalClientTypeAnnotations = additionalClientTypeAnnotations;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withBasePathSeparator(String basePathSeparator) {
            this.basePathSeparator = basePathSeparator;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withFluxForArrays(boolean fluxForArrays) {
            this.fluxForArrays = fluxForArrays;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withPlural(boolean plural) {
            this.plural = plural;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withGeneratedAnnotation(boolean generatedAnnotation) {
            this.generatedAnnotation = generatedAnnotation;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withClientPath(boolean clientPath) {
            this.clientPath = clientPath;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withLombok(boolean lombok) {
            this.lombok = lombok;
            return this;
        }

        @Override
        public JavaMicronautClientOptionsBuilder withNoArgsConstructor(boolean noArgsConstructor) {
            this.noArgsConstructor = noArgsConstructor;
            return this;
        }

        ClientOptions build() {
            return new ClientOptions(this.additionalClientTypeAnnotations, this.authorizationFilterPattern, this.authorizationFilterPatternStyle, this.authFilterClientIds, this.authFilterExcludedClientIds, this.basePathSeparator, this.clientId, this.authConfigName, this.clientPath, this.useAuth, this.generateAuthClasses, this.authFilter, this.useOauth, this.useBasicAuth, this.useApiKeyAuth, this.plural, this.fluxForArrays, this.generatedAnnotation, this.lombok, this.noArgsConstructor);
        }
    }

    record ClientOptions(List<String> additionalClientTypeAnnotations, String authorizationFilterPattern, String authorizationFilterPatternStyle, List<String> authFilterClientIds, List<String> authFilterExcludedClientIds, String basePathSeparator, String clientId, String authConfigName, boolean clientPath, boolean useAuth, boolean generateAuthClasses, boolean authFilter, boolean useOauth, boolean useBasicAuth, boolean useApiKeyAuth, boolean plural, boolean fluxForArrays, boolean generatedAnnotation, boolean lombok, boolean noArgsConstructor) {
    }
}

