/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token.jwt.generator;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.token.claims.ClaimsGenerator;
import io.micronaut.security.token.generator.TokenGenerator;
import io.micronaut.security.token.jwt.encryption.EncryptionConfiguration;
import io.micronaut.security.token.jwt.signature.SignatureGeneratorConfiguration;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.text.ParseException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JwtTokenGenerator
implements TokenGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(JwtTokenGenerator.class);
    protected final ClaimsGenerator claimsGenerator;
    protected final SignatureGeneratorConfiguration signatureConfiguration;
    protected final EncryptionConfiguration encryptionConfiguration;

    public JwtTokenGenerator(@Nullable @Named(value="generator") SignatureGeneratorConfiguration signatureConfiguration, @Nullable @Named(value="generator") EncryptionConfiguration encryptionConfiguration, ClaimsGenerator claimsGenerator) {
        this.signatureConfiguration = signatureConfiguration;
        this.encryptionConfiguration = encryptionConfiguration;
        this.claimsGenerator = claimsGenerator;
    }

    public SignatureGeneratorConfiguration getSignatureConfiguration() {
        return this.signatureConfiguration;
    }

    public EncryptionConfiguration getEncryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    protected String internalGenerate(JWTClaimsSet claimsSet) throws JOSEException, ParseException {
        Object jwt = this.signatureConfiguration == null ? new PlainJWT(claimsSet) : this.signatureConfiguration.sign(claimsSet);
        if (this.encryptionConfiguration != null) {
            return this.encryptionConfiguration.encrypt((JWT)jwt);
        }
        return jwt.serialize();
    }

    protected String generate(Map<String, Object> claims) throws JOSEException, ParseException {
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        for (Map.Entry<String, Object> entry : claims.entrySet()) {
            builder.claim(entry.getKey(), entry.getValue());
        }
        return this.internalGenerate(builder.build());
    }

    public Optional<String> generateToken(Authentication authentication, @Nullable Integer expiration) {
        Map claims = this.claimsGenerator.generateClaims(authentication, expiration);
        return this.generateToken(claims);
    }

    public Optional<String> generateToken(Map<String, Object> claims) {
        block4: {
            try {
                return Optional.of(this.generate(claims));
            }
            catch (ParseException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Parse exception while generating token {}", (Object)e.getMessage());
                }
            }
            catch (JOSEException e) {
                if (!LOG.isWarnEnabled()) break block4;
                LOG.warn("JOSEException while generating token {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }
}

