/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.config;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.context.ServerContextPathProvider;
import io.micronaut.security.config.RedirectConfiguration;
import io.micronaut.security.config.RedirectService;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.config.ServerContextPathProviderUtils;
import jakarta.inject.Singleton;

@Requires(beans={ServerContextPathProvider.class, SecurityConfiguration.class})
@Singleton
public class DefaultRedirectService
implements RedirectService {
    private final ServerContextPathProvider serverContextPathProvider;
    private final RedirectConfiguration redirectConfiguration;

    public DefaultRedirectService(RedirectConfiguration redirectConfiguration, ServerContextPathProvider serverContextPathProvider) {
        if (serverContextPathProvider == null) {
            throw new ConfigurationException("no server context path providers available");
        }
        this.redirectConfiguration = redirectConfiguration;
        this.serverContextPathProvider = serverContextPathProvider;
    }

    @Override
    @NonNull
    public String loginSuccessUrl() {
        return ServerContextPathProviderUtils.prependContextPath(this.redirectConfiguration.getLoginSuccess(), this.serverContextPathProvider);
    }

    @Override
    @NonNull
    public String loginFailureUrl() {
        return ServerContextPathProviderUtils.prependContextPath(this.redirectConfiguration.getLoginFailure(), this.serverContextPathProvider);
    }

    @Override
    @NonNull
    public String logoutUrl() {
        return ServerContextPathProviderUtils.prependContextPath(this.redirectConfiguration.getLogout(), this.serverContextPathProvider);
    }

    @Override
    @NonNull
    public String unauthorizedUrl() {
        return ServerContextPathProviderUtils.prependContextPath(this.redirectConfiguration.getUnauthorized().getUrl(), this.serverContextPathProvider);
    }

    @Override
    @NonNull
    public String forbiddenUrl() {
        return ServerContextPathProviderUtils.prependContextPath(this.redirectConfiguration.getForbidden().getUrl(), this.serverContextPathProvider);
    }

    @Override
    @NonNull
    public String refreshUrl() {
        return ServerContextPathProviderUtils.prependContextPath(this.redirectConfiguration.getRefresh().getUrl(), this.serverContextPathProvider);
    }
}

