/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.endpoints;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.StringUtils;
import io.micronaut.security.endpoints.ControllerConfiguration;
import java.util.Set;

@Internal
abstract class ControllerConfigurationProperties
implements ControllerConfiguration {
    public static final boolean DEFAULT_ENABLED = true;
    private static final Set<String> DEFAULT_CONTENT_TYPES_FOR_POST_ENDPOINTS = Set.of("application/json", "application/x-www-form-urlencoded");
    private boolean enabled = true;
    private String path;
    private Set<String> postContentTypes = DEFAULT_CONTENT_TYPES_FOR_POST_ENDPOINTS;

    ControllerConfigurationProperties(String path) {
        this.path = path;
    }

    @Override
    public Set<String> getPostContentTypes() {
        return this.postContentTypes;
    }

    public void setPostContentTypes(Set<String> postContentTypes) {
        this.postContentTypes = postContentTypes;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @NonNull
    public String getPath() {
        return this.path;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setPath(String path) {
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            this.path = path;
        }
    }
}

