/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.token;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.http.server.util.locale.HttpLocaleResolver;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.event.TokenValidatedEvent;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.token.reader.TokenResolver;
import io.micronaut.security.token.validator.TokenValidator;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

@Requirements(value={@Requires(classes={HttpRequest.class}), @Requires(beans={HttpHostResolver.class})})
@Singleton
public class TokenAuthenticationFetcher
implements AuthenticationFetcher<HttpRequest<?>> {
    public static final Integer ORDER = 0;
    protected final Collection<TokenValidator<HttpRequest<?>>> tokenValidators;
    protected final HttpHostResolver httpHostResolver;
    protected final HttpLocaleResolver httpLocaleResolver;
    protected final ApplicationEventPublisher<TokenValidatedEvent> tokenValidatedEventPublisher;
    private final TokenResolver<HttpRequest<?>> tokenResolver;

    @Deprecated(forRemoval=true, since="4.4.0")
    public TokenAuthenticationFetcher(Collection<TokenValidator<HttpRequest<?>>> tokenValidators, TokenResolver<HttpRequest<?>> tokenResolver, ApplicationEventPublisher<TokenValidatedEvent> tokenValidatedEventPublisher) {
        this(CollectionUtils.iterableToList(tokenValidators), tokenResolver, tokenValidatedEventPublisher);
    }

    @Deprecated(forRemoval=true, since="4.7.0")
    public TokenAuthenticationFetcher(List<TokenValidator<HttpRequest<?>>> tokenValidators, TokenResolver<HttpRequest<?>> tokenResolver, ApplicationEventPublisher<TokenValidatedEvent> tokenValidatedEventPublisher) {
        this(tokenValidators, tokenResolver, tokenValidatedEventPublisher, request -> null, new HttpLocaleResolver(){

            @NonNull
            public Optional<Locale> resolve(@NonNull HttpRequest<?> context) {
                return Optional.of(Locale.getDefault());
            }

            @NonNull
            public Locale resolveOrDefault(@NonNull HttpRequest<?> context) {
                return Locale.getDefault();
            }
        });
    }

    @Inject
    public TokenAuthenticationFetcher(List<TokenValidator<HttpRequest<?>>> tokenValidators, TokenResolver<HttpRequest<?>> tokenResolver, ApplicationEventPublisher<TokenValidatedEvent> tokenValidatedEventPublisher, HttpHostResolver httpHostResolver, HttpLocaleResolver httpLocaleResolver) {
        this.tokenValidatedEventPublisher = tokenValidatedEventPublisher;
        this.tokenResolver = tokenResolver;
        this.tokenValidators = tokenValidators;
        this.httpHostResolver = httpHostResolver;
        this.httpLocaleResolver = httpLocaleResolver;
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        List<String> tokens = this.tokenResolver.resolveTokens(request);
        if (CollectionUtils.isEmpty(tokens)) {
            return Flux.empty();
        }
        return Flux.fromIterable(tokens).flatMap(tokenValue -> Flux.fromIterable(this.tokenValidators).flatMap(tokenValidator -> tokenValidator.validateToken((String)tokenValue, request)).next().map(authentication -> {
            request.setAttribute(SecurityFilter.TOKEN, tokenValue);
            this.tokenValidatedEventPublisher.publishEvent((Object)new TokenValidatedEvent(tokenValue, this.httpHostResolver.resolve(request), this.httpLocaleResolver.resolveOrDefault((Object)request)));
            return authentication;
        }));
    }

    public int getOrder() {
        return ORDER;
    }
}

